/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JSStubBase<PsiT extends JSElement>
extends StubBase<PsiT>
implements JSStubElement<PsiT> {
    private int myFlags;

    protected JSStubBase(PsiT psi, StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase", "<init>"));
        }
        super(parent, elementType);
    }

    protected JSStubBase(StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase", "<init>"));
        }
        super(parent, elementType);
    }

    protected JSStubBase(StubInputStream dataStream, StubElement parentStub, IStubElementType elementType) throws IOException {
        super(parentStub, elementType);
        int flagsSize = this.getFlagsStructure().size();
        if (flagsSize > 0) {
            assert (flagsSize <= 32) : ((Object)((Object)this)).getClass();
            this.myFlags = dataStream.readInt();
        }
    }

    public void serialize(StubOutputStream dataStream) throws IOException {
        if (this.getFlagsStructure().size() > 0) {
            dataStream.writeInt(this.myFlags);
        }
    }

    protected static void writeString(StringRef ref, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(StringRef.toString((StringRef)ref));
    }

    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FlagsStructure.EMPTY;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    protected <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return IntFlagsSerializer.INSTANCE.readValue(this.getFlagsStructure(), structureElement, this.myFlags);
    }

    protected <T> void writeFlag(FlagsStructureElement<T> structureElement, T value) {
        this.myFlags = IntFlagsSerializer.INSTANCE.writeValue(this.getFlagsStructure(), structureElement, value, this.myFlags);
    }
}

