/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JSVariableStubBaseImpl<T extends JSVariable>
extends JSQualifiedObjectStubBase<T>
implements JSVariableStubBase<T> {
    private static final BooleanStructureElement IS_CONST_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_BLOCK_SCOPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement TYPE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INITIALIZER_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INITIALIZER_TEXT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, IS_CONST_FLAG, HAS_BLOCK_SCOPE_FLAG, TYPE_EXPLICITLY_DECLARED_FLAG, HAS_INITIALIZER_FLAG, HAS_INITIALIZER_TEXT_FLAG, HAS_TYPE_FLAG);
    private final StringRef myTypeString;
    private final StringRef myInitializerText;

    public JSVariableStubBaseImpl(T var, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl", "<init>"));
        }
        super(var, parent, elementType);
        JSType type = var.getType();
        this.myTypeString = StringRef.fromString(type != null ? type.getTypeText(JSType.TypeTextFormat.SERIALIZED) : null);
        this.writeFlag(TYPE_EXPLICITLY_DECLARED_FLAG, type != null && type.getSource().isExplicitlyDeclared());
        this.myInitializerText = StringRef.fromString((String)var.getLiteralOrReferenceInitializerText());
        this.writeFlag(IS_CONST_FLAG, var.isConst());
        this.writeFlag(HAS_BLOCK_SCOPE_FLAG, var.hasBlockScope());
        this.writeFlag(HAS_INITIALIZER_FLAG, var.hasInitializer());
        this.writeFlag(HAS_INITIALIZER_TEXT_FLAG, this.myInitializerText != null);
        this.writeFlag(HAS_TYPE_FLAG, this.myTypeString != null);
    }

    public JSVariableStubBaseImpl(StubInputStream dataStream, StubElement parentStub, @NotNull IStubElementType elementType) throws IOException {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl", "<init>"));
        }
        super(dataStream, parentStub, elementType);
        this.myTypeString = this.readFlag(HAS_TYPE_FLAG) != false ? dataStream.readName() : null;
        this.myInitializerText = this.readFlag(HAS_INITIALIZER_TEXT_FLAG) != false ? dataStream.readName() : null;
    }

    public JSVariableStubBaseImpl(String name, boolean isConst, String type, String initial, String qName, StubElement parentStub, @NotNull JSContext jsContext, @NotNull JSAttributeList.AccessType accessType, @NotNull IStubElementType elementType) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl", "<init>"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl", "<init>"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl", "<init>"));
        }
        super(name, qName, parentStub, jsContext, accessType, elementType);
        this.myTypeString = StringRef.fromString((String)type);
        this.myInitializerText = StringRef.fromString((String)initial);
        this.writeFlag(IS_CONST_FLAG, isConst);
        this.writeFlag(HAS_BLOCK_SCOPE_FLAG, false);
        this.writeFlag(HAS_INITIALIZER_FLAG, this.myInitializerText != null);
        this.writeFlag(TYPE_EXPLICITLY_DECLARED_FLAG, false);
        this.writeFlag(HAS_INITIALIZER_TEXT_FLAG, this.myInitializerText != null);
        this.writeFlag(HAS_TYPE_FLAG, this.myTypeString != null);
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSVariableStubBaseImpl.writeString(this.myTypeString, dataStream);
        }
        if (this.readFlag(HAS_INITIALIZER_TEXT_FLAG).booleanValue()) {
            JSVariableStubBaseImpl.writeString(this.myInitializerText, dataStream);
        }
    }

    public String getTypeString() {
        return this.myTypeString != null ? this.myTypeString.getString() : null;
    }

    public boolean isTypeExplicitlyDeclared() {
        return this.readFlag(TYPE_EXPLICITLY_DECLARED_FLAG);
    }

    public boolean isConst() {
        return this.readFlag(IS_CONST_FLAG);
    }

    public boolean hasInitializer() {
        return this.readFlag(HAS_INITIALIZER_FLAG);
    }

    public String getLiteralOrReferenceInitializerText() {
        return this.myInitializerText != null ? this.myInitializerText.getString() : null;
    }

    public boolean hasBlockScope() {
        return this.readFlag(HAS_BLOCK_SCOPE_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

