/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCallExpressionType
extends JSSimpleTypeBaseImpl {
    @NotNull
    private final String myMethod;

    public JSCallExpressionType(@NotNull String method, @NotNull JSTypeSource source) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "<init>"));
        }
        super(source);
        this.myMethod = method;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "#call" + this.myMethod;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "getTypeText"));
            }
            return string;
        }
        String string = JSAnyType.get((PsiElement)this.getScope(), false).getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "getTypeText"));
        }
        return string;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        return true;
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        if (type == null) {
            return false;
        }
        if (type.getClass() != this.getClass()) {
            return false;
        }
        return this.getTypeText(JSType.TypeTextFormat.SERIALIZED).equals(type.getTypeText(JSType.TypeTextFormat.SERIALIZED));
    }

    @NotNull
    public String getMethod() {
        String string = this.myMethod;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "getMethod"));
        }
        return string;
    }

    @NotNull
    public JSCallExpressionType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "copyWithNewSource"));
        }
        JSCallExpressionType jSCallExpressionType = new JSCallExpressionType(this.getMethod(), source);
        if (jSCallExpressionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCallExpressionType", "copyWithNewSource"));
        }
        return jSCallExpressionType;
    }
}

