/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl {
    private boolean myIsOptimized = false;
    public static final int TYPES_NUMBER_LIMIT = 5;
    public static final Comparator<JSType> GENERIC_PARAMETER_LAST = new Comparator<JSType>(){

        @Override
        public int compare(JSType o1, JSType o2) {
            if (o1 instanceof JSGenericParameterImpl) {
                return 1;
            }
            if (o2 instanceof JSGenericParameterImpl) {
                return -1;
            }
            return 0;
        }
    };

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        if (!(currentType instanceof JSCompositeTypeImpl)) {
            return currentType;
        }
        JSCompositeTypeImpl compositeType = (JSCompositeTypeImpl)currentType;
        if (compositeType.isOptimized()) {
            return compositeType;
        }
        ArrayList types = compositeType.getTypes();
        ArrayList typesWithoutEmpty = ContainerUtil.newArrayList();
        JSType emptyType = null;
        for (JSType type : types) {
            if (JSCompositeTypeImpl.isEmptyType(type)) {
                emptyType = type;
                continue;
            }
            typesWithoutEmpty.add(type);
        }
        if (typesWithoutEmpty.size() == 0 && emptyType != null) {
            return emptyType;
        }
        types = typesWithoutEmpty;
        ArrayList filteredEqualsTypes = ContainerUtil.newArrayList((Iterable)types);
        HashSet removedTypes = ContainerUtil.newHashSet();
        HashMap typeOfTypeToEvaluate = ContainerUtil.newHashMap();
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        for (JSType type : types) {
            if (removedTypes.contains(type)) continue;
            JSType fromCompare = JSCompositeTypeImpl.getOrPutTypeOfType(typeOfTypeToEvaluate, type);
            Iterator iter = filteredEqualsTypes.iterator();
            while (iter.hasNext()) {
                JSType next = (JSType)iter.next();
                JSType toCompare = JSCompositeTypeImpl.getOrPutTypeOfType(typeOfTypeToEvaluate, next);
                if (type == next || !fromCompare.isEquivalentTo(toCompare, null)) continue;
                iter.remove();
                removedTypes.add(next);
            }
        }
        if (filteredEqualsTypes.size() == 1) {
            JSType resultType = (JSType)filteredEqualsTypes.get(0);
            JSType typeOfType = (JSType)typeOfTypeToEvaluate.get(resultType);
            return typeOfType == null ? resultType : typeOfType;
        }
        return new JSCompositeTypeImpl(compositeType.getSource(), true, JSCompositeTypeImpl.mapTypes(typeOfTypeToEvaluate, filteredEqualsTypes));
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean checkEquality) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        ArrayList allCommonTypes = ContainerUtil.newArrayList();
        if (type1 instanceof JSCompositeTypeImpl) {
            allCommonTypes.addAll(((JSCompositeTypeImpl)type1).getTypes());
            if (source == null) {
                source = type1.getSource();
            }
        } else {
            allCommonTypes.add(type1);
        }
        if (type2 instanceof JSCompositeTypeImpl) {
            allCommonTypes.addAll(((JSCompositeTypeImpl)type2).getTypes());
            if (source == null) {
                source = type2.getSource();
            }
        } else {
            allCommonTypes.add(type2);
        }
        if (source == null) {
            source = type1.getSource();
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSType currentType : allCommonTypes) {
            if (currentType instanceof JSAnyType) {
                JSType jSType = currentType;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
                }
                return jSType;
            }
            if (currentType instanceof JSNullType) continue;
            boolean add = true;
            for (JSType resultedType : result) {
                if ((!checkEquality || !currentType.isEquivalentTo(resultedType, null)) && (checkEquality || (!(type1 instanceof JSNamedType) || !(type2 instanceof JSNamedType) || !type1.getTypeText().equals(type2.getTypeText())) && (!(type1 instanceof JSPrimitiveType) || !(type2 instanceof JSPrimitiveType) || !type1.isEquivalentTo(type2, null)))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(currentType);
        }
        if (result.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem((Collection)result, null);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, result);
        if (jSCompositeTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        return jSCompositeTypeImpl;
    }

    private static JSType getOrPutTypeOfType(Map<JSType, JSType> typeOfTypeToEvaluate, JSType type) {
        JSType result = type;
        if (type instanceof JSTypeofTypeImpl) {
            JSType evaluate = typeOfTypeToEvaluate.get(type);
            if (evaluate == null) {
                evaluate = ((JSTypeofTypeImpl)type).evaluateType();
                typeOfTypeToEvaluate.put(type, evaluate);
            }
            result = evaluate;
        }
        return result;
    }

    private static List<JSType> mapTypes(Map<JSType, JSType> typeOfTypeToEvaluate, List<JSType> filteredEqualsTypes) {
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)filteredEqualsTypes.size());
        for (JSType type : filteredEqualsTypes) {
            JSType typeOfType = typeOfTypeToEvaluate.get(type);
            result.add(typeOfType == null ? type : typeOfType);
        }
        return result;
    }

    private JSCompositeTypeImpl(JSTypeSource source, boolean isOptimized, List<JSType> _types) {
        super(source, _types);
        this.myIsOptimized = isOptimized;
    }

    public JSCompositeTypeImpl(JSTypeSource source, JSType ... _types) {
        super(source, _types);
    }

    public JSCompositeTypeImpl(JSTypeSource source, List<JSType> _types) {
        super(source, _types);
    }

    @Override
    protected String getTypeSeparator() {
        return "|";
    }

    @Override
    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSCompositeTypeImpl && this.isTypeScript()) {
            for (JSType type : ((JSCompositeTypeImpl)elementType).getTypes()) {
                if (this.isDirectlyAssignableType(type, processingContext)) continue;
                return false;
            }
            return true;
        }
        for (JSType t : this.getTypes()) {
            if (!t.isDirectlyAssignableType(elementType, processingContext)) continue;
            return true;
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    private boolean isOptimized() {
        return this.myIsOptimized;
    }

    @Override
    protected JSCompositeTypeBaseImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformedTypes", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "createType"));
        }
        if (newSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSource", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "createType"));
        }
        return new JSCompositeTypeImpl(newSource, transformedTypes);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result = this.getSimpleCompositeTypeResult();
        if (result != null) {
            JSType jSType = result;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeIfComposite(this);
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSType jSType = rawTypeToProcess;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.isExplicitlyDeclared());
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
            }
            return jSAnyType;
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        PsiElement sourceElement = this.getSource().getSourceElement();
        ArrayList resultMembers = ContainerUtil.newArrayList();
        block0: for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            for (JSRecordType resolvedType : resolvedTypes) {
                boolean hasCurrent = false;
                for (JSRecordType.TypeMember typeMember : resolvedType.getTypeMembers()) {
                    if (member.isEquivalentTo(typeMember)) {
                        hasCurrent = true;
                        continue;
                    }
                    if (!(member instanceof JSRecordTypeImpl.PropertySignature) || !(typeMember instanceof JSRecordTypeImpl.PropertySignature)) continue;
                    JSRecordTypeImpl.PropertySignature memberProperty = (JSRecordTypeImpl.PropertySignature)member;
                    JSRecordTypeImpl.PropertySignature typeMemberProperty = (JSRecordTypeImpl.PropertySignature)typeMember;
                    if (sourceElement == null || !StringUtil.equals((CharSequence)memberProperty.getName(), (CharSequence)typeMemberProperty.getName())) continue;
                    JSType type1 = memberProperty.getType();
                    JSType type2 = typeMemberProperty.getType();
                    if (type1 == null || type2 == null) continue;
                    JSRecordTypeImpl.PropertySignature commonType = new JSRecordTypeImpl.PropertySignature(typeMemberProperty.getName(), JSTypeUtils.getCommonType(type1, type2, DialectDetector.dialectOfElement(sourceElement)), memberProperty.optional);
                    resultMembers.add(commonType);
                    continue block0;
                }
                if (hasCurrent) continue;
                continue block0;
            }
            resultMembers.add(member);
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
        }
        return jSRecordTypeImpl;
    }
}

