/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final List<JSParameterTypeDecorator> myParameters;
    private final JSType myThisType;
    private final JSType myNewType;
    private final JSType myReturnType;

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSParameterTypeDecorator> parameters, @Nullable JSType returnType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "<init>"));
        }
        this(source, parameters, returnType, null, null);
    }

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSParameterTypeDecorator> parameters, @Nullable JSType returnType, @Nullable JSType thisType, @Nullable JSType newType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "<init>"));
        }
        super(source);
        this.myParameters = Collections.unmodifiableList(parameters);
        this.myReturnType = returnType;
        this.myThisType = thisType;
        this.myNewType = newType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = this.getTypeText(format, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getTypeText"));
        }
        return string;
    }

    @NotNull
    String getTypeText(JSType.TypeTextFormat format, boolean appendKeyword) {
        boolean typeScriptCodeFormat = false;
        if (format == JSType.TypeTextFormat.CODE) {
            if (this.isEcma()) {
                if ("Function" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getTypeText"));
                }
                return "Function";
            }
            typeScriptCodeFormat = true;
        }
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Function" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getTypeText"));
            }
            return "Function";
        }
        StringBuilder builder = new StringBuilder();
        if (appendKeyword && !typeScriptCodeFormat) {
            builder.append("function");
        }
        builder.append("(");
        String prefix = "";
        if (this.myThisType != null && !typeScriptCodeFormat) {
            builder.append("this:");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myThisType, format);
            prefix = ", ";
        }
        if (this.myNewType != null && !typeScriptCodeFormat) {
            builder.append(prefix);
            builder.append("new:");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myNewType, format);
            prefix = ", ";
        }
        int pIndex = 1;
        for (JSParameterTypeDecorator decorator : this.myParameters) {
            JSType parameter = this.getParameterType(decorator, format);
            builder.append(prefix);
            if (typeScriptCodeFormat) {
                builder.append(this.getParameterName(pIndex++));
                if (decorator.isOptional()) {
                    builder.append("?");
                }
                if (parameter == null) {
                    prefix = ", ";
                    continue;
                }
                builder.append(":");
            }
            if (decorator.isRest()) {
                assert (parameter != null);
                builder.append("...[");
                builder.append(parameter.getTypeText(format));
                builder.append("]");
            } else {
                assert (parameter != null);
                JSFunctionTypeImpl.appendAndWrapIfNeed(builder, parameter, format);
            }
            if (decorator.isOptional() && !typeScriptCodeFormat) {
                builder.append("=");
            }
            prefix = ", ";
        }
        builder.append(")");
        if (this.myReturnType != null) {
            builder.append(typeScriptCodeFormat ? "=>" : ": ");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myReturnType, format);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Nullable
    protected JSType getParameterType(@NotNull JSParameterTypeDecorator decorator, @NotNull JSType.TypeTextFormat format) {
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getParameterType"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getParameterType"));
        }
        JSType parameter = decorator.getType();
        if (parameter == null) {
            parameter = JSAnyType.get((PsiElement)this.getScope(), false);
        }
        return parameter;
    }

    @NotNull
    protected String getParameterName(int index) {
        String string = "p" + index;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getParameterName"));
        }
        return string;
    }

    @Override
    public JSClass resolveClass() {
        return null;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)elementType;
            if (this.isTypeScript()) {
                JSRecordTypeImpl recordType = JSTypeUtils.buildRecordType(this);
                return recordType.isDirectlyAssignableType(elementType, processingContext);
            }
            if (this.myThisType != null && functionType.myThisType != null && !this.myThisType.isDirectlyAssignableType(functionType.myThisType, processingContext)) {
                return false;
            }
            if (this.myNewType != null && functionType.myNewType != null && !this.myNewType.isDirectlyAssignableType(functionType.myNewType, processingContext)) {
                return false;
            }
            if (this.myReturnType != null && functionType.myReturnType != null && !this.myReturnType.isDirectlyAssignableType(functionType.myReturnType, processingContext)) {
                return false;
            }
            return JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), this.getParameters(), processingContext, true, true, false);
        }
        if (elementType instanceof JSRecordTypeImpl) {
            JSRecordTypeImpl recordType = (JSRecordTypeImpl)elementType;
            for (JSRecordType.TypeMember typeMember : recordType.getTypeMembers()) {
                if (!(typeMember instanceof JSRecordTypeImpl.CallSignature) || ((JSRecordTypeImpl.CallSignature)typeMember).hasNew || !this.isDirectlyAssignableType(((JSRecordTypeImpl.CallSignature)typeMember).functionType, processingContext)) continue;
                return true;
            }
            return false;
        }
        if (elementType instanceof JSTypeImpl || elementType instanceof JSGenericTypeImpl) {
            JSType resolvedElementType;
            if (elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).inheritsFunction()) {
                return true;
            }
            if (this.isTypeScript() && (resolvedElementType = elementType.substitute()) != elementType) {
                return this.isDirectlyAssignableType(resolvedElementType, processingContext);
            }
        } else if (elementType instanceof JSPrimitiveFunctionType || elementType instanceof JSNullType) {
            return true;
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    private static void appendAndWrapIfNeed(@NotNull StringBuilder builder, @NotNull JSType type, @NotNull JSType.TypeTextFormat format) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "appendAndWrapIfNeed"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "appendAndWrapIfNeed"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "appendAndWrapIfNeed"));
        }
        boolean isNeedWrap = type instanceof JSCompositeTypeBaseImpl;
        if (isNeedWrap) {
            builder.append("(");
        }
        builder.append(type.getTypeText(format));
        if (isNeedWrap) {
            builder.append(")");
        }
    }

    public boolean isEquivalentTo(JSType type, ProcessingContext processingContext) {
        if (type instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)type;
            if (this.myThisType != null && !this.myThisType.isEquivalentTo(functionType.getThisType(), processingContext)) {
                return false;
            }
            if (this.myNewType != null && !this.myNewType.isEquivalentTo(functionType.getNewType(), processingContext)) {
                return false;
            }
            if (this.myReturnType != null && !this.myReturnType.isEquivalentTo(functionType.getReturnType(), processingContext)) {
                return false;
            }
            Iterator<JSParameterTypeDecorator> iterator = functionType.getParameters().iterator();
            for (JSParameterTypeDecorator p : this.getParameters()) {
                if (!iterator.hasNext()) {
                    return false;
                }
                JSParameterTypeDecorator next = iterator.next();
                JSType paramType = p.getType();
                if (p.isOptional() == next.isOptional() && p.isRest() == next.isRest() && p.isExplicitlyDeclared() == next.isExplicitlyDeclared() && (paramType != null || next.getType() == null) && (paramType == null || paramType.isEquivalentTo(next.getType(), processingContext))) continue;
                return false;
            }
            return !iterator.hasNext();
        }
        return JSTypeCastUtil.isEquivalentCommon(this, type, processingContext);
    }

    @NotNull
    public List<JSParameterTypeDecorator> getParameters() {
        List<JSParameterTypeDecorator> list = this.myParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "getParameters"));
        }
        return list;
    }

    @Nullable
    public JSType getThisType() {
        return this.myThisType;
    }

    @Nullable
    public JSType getNewType() {
        return this.myNewType;
    }

    @Nullable
    public JSType getReturnType() {
        return this.myReturnType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSFunctionType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        if (this.myNewType != null) {
            this.myNewType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
        if (this.myThisType != null) {
            this.myThisType.accept(visitor);
        }
        for (JSParameterTypeDecorator parameter : this.myParameters) {
            JSType type = parameter.getType();
            if (type == null) continue;
            type.accept(visitor);
        }
    }

    @Override
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, @Nullable JSTypeSource newSource) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "copyTypeHierarchy"));
        }
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(this.getNewType(), childTransform, newSource);
        JSType returnType = JSTypeUtils.transformTypeHierarchySafe(this.getReturnType(), childTransform, newSource);
        JSType thisType = JSTypeUtils.transformTypeHierarchySafe(this.getThisType(), childTransform, newSource);
        ArrayList<JSParameterTypeDecorator> newParameters = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterTypeDecorator p : this.getParameters()) {
            newParameters.add(new JSParameterTypeDecoratorImpl(JSTypeUtils.transformTypeHierarchySafe(p.getType(), childTransform, newSource), p.isOptional(), p.isRest(), p.isExplicitlyDeclared()));
        }
        return this.createType(this.getSourceForCopy(newSource), newType, returnType, thisType, newParameters);
    }

    @NotNull
    protected JSFunctionTypeImpl createType(@NotNull JSTypeSource newSource, JSType newType, JSType returnType, JSType thisType, ArrayList<JSParameterTypeDecorator> newParameters) {
        if (newSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSource", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "createType"));
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(newSource, newParameters, returnType, thisType, newType);
        if (jSFunctionTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "createType"));
        }
        return jSFunctionTypeImpl;
    }

    public List<Pair<String, JSParameterTypeDecorator>> getParametersWithName() {
        ArrayList result = ContainerUtil.newArrayList();
        int i = 1;
        for (JSParameterTypeDecorator decorator : this.getParameters()) {
            result.add(Pair.create((Object)this.getParameterName(i++), (Object)decorator));
        }
        return result;
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "copyWithNewSource"));
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(source, this.getParameters(), this.getReturnType(), this.getThisType(), this.getNewType());
        if (jSFunctionTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "copyWithNewSource"));
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl.CallSignature callSignature = new JSRecordTypeImpl.CallSignature(false, this);
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), Collections.singletonList(callSignature));
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl", "asRecordTypeNoCache"));
        }
        return jSRecordTypeImpl;
    }
}

