/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;
    @Nullable
    private final Map<String, JSType> myOuterArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList();
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @Nullable JSType argument) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList((Object[])new JSType[]{argument});
        this.myOuterArguments = null;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList(arguments);
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, List<JSType> arguments) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "<init>"));
        }
        this(source, type, arguments, null);
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
        for (JSType argument : this.myArguments) {
            argument.accept(visitor);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myType.getTypeText(format));
        if (!this.isTypeScript()) {
            builder.append('.');
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            builder.append(prefix);
            builder.append(argument.getTypeText(format));
            prefix = ", ";
        }
        builder.append(">");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            return true;
        }
        if (this.isTypeScript()) {
            String elementQName;
            JSType elementMyType;
            JSType typedef;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if (elementType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)elementType).getTypedef(null, processingContext)) != null) {
                elementType = typedef;
            }
            if (elementType instanceof JSArrayType) {
                elementType = ((JSArrayType)elementType).asGenericType();
            } else {
                JSType resolved;
                if (elementType instanceof JSCompositeTypeImpl) {
                    boolean isAssignable = true;
                    for (JSType type : ((JSCompositeTypeImpl)elementType).getTypes()) {
                        if (this.isDirectlyAssignableType(type, processingContext)) continue;
                        isAssignable = false;
                        break;
                    }
                    return isAssignable;
                }
                if (elementType instanceof JSRecordTypeImpl && this != (resolved = this.substitute())) {
                    return resolved.isDirectlyAssignableType(elementType, processingContext);
                }
            }
            if (elementType instanceof JSGenericTypeImpl && this.myType.isEquivalentTo(elementMyType = ((JSGenericTypeImpl)elementType).myType, processingContext)) {
                String elementText;
                String thisText = this.getResolvedTypeText();
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisText, elementText = elementType.getResolvedTypeText(), processingContext)) {
                    return true;
                }
                JSTypeCastUtil.AssignableResult result = this.isEquivalentTo((JSGenericTypeImpl)elementType, processingContext, false);
                if (result.isAssignable()) {
                    return true;
                }
                JSTypeCastUtil.endRecursiveTypesComparison(thisText, elementText, processingContext);
                if (this.myType instanceof JSPrimitiveArrayType && elementMyType instanceof JSPrimitiveArrayType) {
                    return false;
                }
            }
            if ((elementQName = JSTypeUtils.getQualifiedNameMatchingType(elementType, true)) != null) {
                String thisQName = JSTypeUtils.getQualifiedNameMatchingType(this, true);
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisQName, elementQName, processingContext)) {
                    return true;
                }
                JSType resolved = this.substitute();
                if (resolved != this) {
                    boolean result = resolved.isDirectlyAssignableType(elementType, processingContext);
                    JSTypeCastUtil.endRecursiveTypesComparison(thisQName, elementQName, processingContext);
                    return result;
                }
            }
        } else {
            if (elementType instanceof JSGenericTypeImpl) {
                if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                    return false;
                }
                List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).myArguments;
                ListIterator<JSType> iterator = elementTypeArgs.listIterator();
                boolean allArgumentsEquivalent = true;
                for (JSType argument : this.myArguments) {
                    allArgumentsEquivalent &= iterator.hasNext() && JSTypeUtils.areTypesCompatible(argument, iterator.next(), processingContext, null);
                }
                return this.getSource().getLanguage() == JSTypeSource.SourceLanguage.JS || allArgumentsEquivalent && !iterator.hasNext();
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
                return false;
            }
        }
        if (elementType instanceof JSTypeofTypeImpl) {
            return this.isDirectlyAssignableType(elementType.substitute(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        if (type instanceof JSGenericTypeImpl) {
            if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext)) {
                return false;
            }
            return this.isEquivalentTo((JSGenericTypeImpl)type, processingContext, true) == JSTypeCastUtil.AssignableResult.STRICTLY_ASSIGNABLE;
        }
        return false;
    }

    public JSTypeCastUtil.AssignableResult isEquivalentTo(@NotNull JSGenericTypeImpl type, @Nullable ProcessingContext processingContext, boolean checkGenericEquivalent) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "isEquivalentTo"));
        }
        Iterator<JSType> iterator = type.myArguments.iterator();
        for (JSType argument : this.myArguments) {
            boolean result;
            if (!iterator.hasNext()) {
                return JSTypeCastUtil.AssignableResult.POSSIBLY_ASSIGNABLE;
            }
            JSType next = iterator.next();
            if (!(checkGenericEquivalent ? !argument.isEquivalentTo(next, processingContext) : !(result = argument.isDirectlyAssignableType(next, processingContext)))) continue;
            return JSTypeCastUtil.AssignableResult.STRICTLY_NOT_ASSIGNABLE;
        }
        return iterator.hasNext() ? JSTypeCastUtil.AssignableResult.POSSIBLY_ASSIGNABLE : JSTypeCastUtil.AssignableResult.STRICTLY_ASSIGNABLE;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            String typeText = genericType.myType.getResolvedTypeText();
            return "Vector".equals(typeText) && genericType.myArguments.size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "getType"));
        }
        return jSType;
    }

    @Deprecated
    void addGenericArgument(JSType type) {
        this.myArguments.add(type);
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list = this.myArguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "getArguments"));
        }
        return list;
    }

    @Override
    protected JSType copyTypeHierarchy(final @NotNull Function<JSType, JSType> childTransform, final @Nullable JSTypeSource newSource) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "copyTypeHierarchy"));
        }
        return new JSGenericTypeImpl(this.getSourceForCopy(newSource), JSTypeUtils.transformTypeHierarchySafe(this.getType(), childTransform, newSource), ContainerUtil.map(this.getArguments(), (Function)new Function<JSType, JSType>(){

            public JSType fun(JSType type) {
                return JSTypeUtils.transformTypeHierarchySafe(type, (Function<JSType, JSType>)childTransform, newSource);
            }
        }), this.getOuterArguments());
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "copyWithNewSource"));
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, this.getType(), this.getArguments(), this.getOuterArguments());
        if (jSGenericTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "copyWithNewSource"));
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.resolveQualifiedType(this);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "substitute"));
        }
        return jSType;
    }

    @Nullable
    public Map<String, JSType> getOuterArguments() {
        return this.myOuterArguments;
    }

    @Override
    @NotNull
    public JSRecordType asRecordType() {
        JSRecordType jSRecordType = this.asRecordTypeNoCache();
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl", "asRecordType"));
        }
        return jSRecordType;
    }
}

