/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class JSNamedType
extends JSSimpleTypeBaseImpl {
    private static final String PROTOTYPE_SUFFIX = ".prototype";
    protected static final String STATIC_SUFFIX = "^s";
    private static final String PROTOTYPE_CONSTRUCTOR_SUFFIX = ".prototype.constructor";
    public static final char QUOTE_ESCAPE_MARK = 'q';
    public static final String QUOTE_ESCAPE = '^' + Character.toString('q');
    static final String FUNCTION_TYPE_SUFFIX = "^f";
    private final JSTypeContext myContext;

    protected JSNamedType(JSTypeSource source, JSTypeContext jsTypeContext) {
        super(source);
        this.myContext = jsTypeContext;
    }

    public static JSType createExplicitlyType(@NotNull String typeString, PsiElement element) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSNamedType", "createExplicitlyType"));
        }
        return JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource(element, true), JSContext.INSTANCE);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSContext staticOrInstance) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if (staticOrInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticOrInstance", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        JSType jSType = JSNamedType.createType(typeString, source, JSTypeContext.fromJSContext(staticOrInstance));
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        return jSType;
    }

    @NotNull
    public static JSType createFunctionBasedType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext jsContext) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSNamedType", "createFunctionBasedType"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSNamedType", "createFunctionBasedType"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/types/JSNamedType", "createFunctionBasedType"));
        }
        JSType jSType = JSNamedType.createType(typeString, source, jsContext, true);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createFunctionBasedType"));
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext jsContext) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        JSType jSType = JSNamedType.createType(typeString, source, jsContext, false);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext jsContext, boolean inheritsFunction) {
        JSType primitiveType;
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        if ("*".equals(typeString) || source.getLanguage() == JSTypeSource.SourceLanguage.TS && "any".equals(typeString)) {
            JSAnyType jSAnyType = JSAnyType.get((PsiElement)source.getScope(), true);
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
            }
            return jSAnyType;
        }
        PsiFile scope = source.getScope();
        if (scope != null && scope != scope.getOriginalFile()) {
            source = new JSTypeSource(scope.getOriginalFile(), source.getSourceElement(), source.getLanguage(), source.isExplicitlyDeclared());
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.AS) {
            JSType genericArgument = null;
            if ("Vector$object".equals(typeString)) {
                genericArgument = JSNamedType.createType("Object", source, JSContext.INSTANCE);
            }
            if ("Vector$int".equals(typeString)) {
                genericArgument = JSNamedType.createType("int", source, JSContext.INSTANCE);
            }
            if ("Vector$uint".equals(typeString)) {
                genericArgument = JSNamedType.createType("uint", source, JSContext.INSTANCE);
            }
            if ("Vector$double".equals(typeString)) {
                genericArgument = JSNamedType.createType("Number", source, JSContext.INSTANCE);
            }
            if (genericArgument != null) {
                JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, JSNamedType.createType("Vector", source, jsContext), genericArgument);
                if (jSGenericTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
                }
                return jSGenericTypeImpl;
            }
        }
        if ((primitiveType = JSSpecialNamedTypeImpl.getSpecialType(typeString, source, jsContext)) != null) {
            JSType jSType = primitiveType;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
            }
            return jSType;
        }
        if ((typeString = typeString.replace(QUOTE_ESCAPE, "\"")).endsWith(FUNCTION_TYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - FUNCTION_TYPE_SUFFIX.length());
            inheritsFunction = true;
        }
        if (typeString.endsWith(STATIC_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - STATIC_SUFFIX.length());
            jsContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith(PROTOTYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_SUFFIX.length());
            jsContext = JSTypeContext.PROTOTYPE;
        } else if (typeString.endsWith(PROTOTYPE_CONSTRUCTOR_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_CONSTRUCTOR_SUFFIX.length());
            jsContext = JSTypeContext.STATIC;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.JS && source.getSourceElement() instanceof JSFunctionItem && jsContext != JSTypeContext.INSTANCE) {
            inheritsFunction = true;
        }
        JSTypeImpl jSTypeImpl = new JSTypeImpl(typeString, source, jsContext, inheritsFunction);
        if (jSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "createType"));
        }
        return jSTypeImpl;
    }

    @NotNull
    public JSContext isStaticOrInstance() {
        JSContext jSContext = this.myContext.toJSContext();
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "isStaticOrInstance"));
        }
        return jSContext;
    }

    @NotNull
    public JSTypeContext getTypeContext() {
        JSTypeContext jSTypeContext = this.myContext;
        if (jSTypeContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "getTypeContext"));
        }
        return jSTypeContext;
    }

    @NotNull
    public static String appendStaticSuffix(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSNamedType", "appendStaticSuffix"));
        }
        String string = type + STATIC_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "appendStaticSuffix"));
        }
        return string;
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSNamedType", "copyWithNewSource"));
        }
        JSType jSType = JSNamedType.createType(this.getTypeText(), source, this.isStaticOrInstance());
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSNamedType", "copyWithNewSource"));
        }
        return jSType;
    }
}

