/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    private final List<JSRecordType.TypeMember> myTypeMembers;

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "<init>"));
        }
        if (typeMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMembers", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "<init>"));
        }
        super(source);
        THashMap overloads = new THashMap();
        boolean hasOverloads = false;
        for (JSRecordType.TypeMember member : typeMembers) {
            if (!(member instanceof PropertySignature)) continue;
            String name = ((PropertySignature)member).getName();
            List addedWithSameName = (List)overloads.get(name);
            if (addedWithSameName == null) {
                overloads.put(name, new SmartList((Object)((PropertySignature)member)));
                continue;
            }
            hasOverloads = true;
            addedWithSameName.add((PropertySignature)member);
        }
        if (hasOverloads) {
            ArrayList<Object> newTypeMembers = new ArrayList<Object>(typeMembers.size());
            block1: for (JSRecordType.TypeMember member : typeMembers) {
                if (!(member instanceof PropertySignature)) {
                    newTypeMembers.add(member);
                    continue;
                }
                String name = ((PropertySignature)member).getName();
                List signaturesToMerge = (List)overloads.get(name);
                if (signaturesToMerge == null) continue;
                if (signaturesToMerge.size() == 1) {
                    newTypeMembers.add(signaturesToMerge.get(0));
                    continue;
                }
                ArrayList<JSRecordType.TypeMember> toMerge = new ArrayList<JSRecordType.TypeMember>(signaturesToMerge.size());
                boolean isAllMergedSignatureOptional = true;
                for (PropertySignature signature : signaturesToMerge) {
                    JSType type;
                    if (!signature.optional) {
                        isAllMergedSignatureOptional = false;
                    }
                    if (!((type = signature.getType()) instanceof JSFunctionTypeImpl)) {
                        newTypeMembers.add(signature);
                        continue block1;
                    }
                    toMerge.add(new CallSignature(false, (JSFunctionTypeImpl)type));
                }
                newTypeMembers.add(new PropertySignature(name, new JSRecordTypeImpl(source, toMerge), isAllMergedSignatureOptional));
                overloads.remove(name);
            }
            this.myTypeMembers = Collections.unmodifiableList(newTypeMembers);
        } else {
            this.myTypeMembers = Collections.unmodifiableList(typeMembers);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder("{");
        String prefix = "";
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            builder.append(prefix);
            if (typeMember instanceof PropertySignature) {
                PropertySignature property = (PropertySignature)typeMember;
                String name = property.name;
                boolean hasDot = name.contains(".");
                builder.append(format == JSType.TypeTextFormat.SERIALIZED || !hasDot ? name : "[" + name + "]");
                if (property.optional) {
                    builder.append('?');
                }
                if (property.type != null) {
                    builder.append(": ");
                    boolean appendBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(property.type);
                    if (appendBrackets) {
                        builder.append("(");
                    }
                    builder.append(property.type.getTypeText(format));
                    if (appendBrackets) {
                        builder.append(")");
                    }
                }
            } else if (typeMember instanceof CallSignature) {
                CallSignature call = (CallSignature)typeMember;
                if (call.hasNew) {
                    builder.append("new");
                }
                builder.append(call.functionType.getTypeText(format, false));
            }
            prefix = ", ";
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    public JSClass resolveClass() {
        return null;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSFunctionTypeImpl || elementType instanceof JSTypeBaseImpl && ((JSTypeBaseImpl)elementType).isTypeScript() && (elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                return this.isDirectlyAssignableType(substitute, processingContext);
            }
            elementType = elementType.asRecordType();
        }
        if (elementType instanceof JSArrayType && elementType.getSource().isTypeScript()) {
            elementType = ((JSArrayType)elementType).asGenericType().asRecordType();
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType recordType, @Nullable ProcessingContext processingContext) {
        if (recordType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isDirectlyAssignableRecordType"));
        }
        THashMap recTypeProperties = new THashMap(recordType.getTypeMembers().size());
        ArrayList callSignatures = null;
        for (JSRecordType.TypeMember typeMember : recordType.getTypeMembers()) {
            if (typeMember instanceof CallSignature) {
                if (callSignatures == null) {
                    callSignatures = ContainerUtil.newArrayList();
                }
                callSignatures.add((CallSignature)typeMember);
                continue;
            }
            if (!(typeMember instanceof PropertySignature)) continue;
            JSRecordTypeImpl.addPropertyToMap((Map<String, List<JSType>>)recTypeProperties, (PropertySignature)typeMember);
        }
        JSTypeSource source = recordType.getSource();
        JSUndefinedType undefinedType = null;
        Collection<JSRecordType.TypeMember> functionMembers = null;
        for (JSRecordType.TypeMember typeMember : this.getTypeMembers()) {
            if (typeMember instanceof PropertySignature) {
                String propName = ((PropertySignature)typeMember).name;
                List recordPropertyTypes = (List)recTypeProperties.get(propName);
                if (recordPropertyTypes == null && !((PropertySignature)typeMember).optional) {
                    if (source.getLanguage() == JSTypeSource.SourceLanguage.JS) {
                        JSType propertyType;
                        if (undefinedType == null) {
                            undefinedType = new JSUndefinedType(source);
                        }
                        if ((propertyType = ((PropertySignature)typeMember).type) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext)) continue;
                    }
                    if (callSignatures != null) {
                        if (functionMembers == null) {
                            functionMembers = QualifiedItemProcessor.getFunctionTypeMembers(this.getSource().getSourceElement());
                        }
                        if (functionMembers.contains(typeMember)) continue;
                        boolean exists = false;
                        for (JSRecordType.TypeMember member : functionMembers) {
                            if (!member.isEquivalentTo(typeMember)) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                    }
                    return false;
                }
                if (recordPropertyTypes == null) continue;
                boolean hasAssignable = false;
                for (JSType recordPropertyType : recordPropertyTypes) {
                    JSType propertyType = ((PropertySignature)typeMember).type;
                    if (!JSRecordTypeImpl.skipTypeChecking(propertyType) && !JSRecordTypeImpl.skipTypeChecking(recordPropertyType) && !propertyType.isDirectlyAssignableType(recordPropertyType, processingContext)) continue;
                    hasAssignable = true;
                    break;
                }
                if (hasAssignable) continue;
                return false;
            }
            if (!(typeMember instanceof CallSignature)) continue;
            boolean matchedCallSignatureFound = false;
            if (callSignatures != null) {
                for (JSRecordType.TypeMember callSignature : callSignatures) {
                    if (((CallSignature)typeMember).hasNew() != ((CallSignature)callSignature).hasNew()) continue;
                    JSFunctionTypeImpl functionType = ((CallSignature)typeMember).getFunctionType();
                    JSType returnType = functionType.getReturnType();
                    JSFunctionTypeImpl otherFunctionType = ((CallSignature)callSignature).getFunctionType();
                    JSType otherReturnType = otherFunctionType.getReturnType();
                    if (!JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !this.isTypeScript(), this.isTypeScript()) || returnType != null && !(returnType instanceof JSVoidType) && !returnType.isDirectlyAssignableType(otherReturnType, processingContext)) continue;
                    matchedCallSignatureFound = true;
                    break;
                }
            }
            if (matchedCallSignatureFound) continue;
            return false;
        }
        return true;
    }

    private static void addPropertyToMap(Map<String, List<JSType>> recTypeProperties, PropertySignature typeMember) {
        String name = typeMember.name;
        List<JSType> types = recTypeProperties.get(name);
        if (types != null) {
            if (types.size() == 1) {
                ArrayList<JSType> arrayList = new ArrayList<JSType>();
                arrayList.add(types.get(0));
                recTypeProperties.put(name, arrayList);
                types = arrayList;
            }
            types.add(typeMember.type);
        } else {
            recTypeProperties.put(name, Collections.singletonList(typeMember.type));
        }
    }

    public boolean isEquivalentTo(JSType type, ProcessingContext processingContext) {
        return type instanceof JSRecordTypeImpl && this.getResolvedTypeText().equals(type.getResolvedTypeText());
    }

    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list = this.myTypeMembers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "getTypeMembers"));
        }
        return list;
    }

    public boolean hasProperty(String name) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof PropertySignature) || !name.equals(((PropertySignature)typeMember).name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PropertySignature findPropertySignature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "findPropertySignature"));
        }
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof PropertySignature) || !name.equals(((PropertySignature)typeMember).name)) continue;
            return (PropertySignature)typeMember;
        }
        return null;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSRecordType((JSType)this);
    }

    private static boolean skipTypeChecking(JSType type) {
        return type == null || type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS && !type.getSource().isExplicitlyDeclared();
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            JSType type;
            JSType type2;
            if (typeMember instanceof PropertySignature) {
                type2 = ((PropertySignature)typeMember).type;
                if (type2 == null) continue;
                type2.accept(visitor);
                continue;
            }
            if (typeMember instanceof CallSignature) {
                type2 = ((CallSignature)typeMember).getFunctionType();
                type2.accept(visitor);
                continue;
            }
            if (!(typeMember instanceof IndexSignature)) continue;
            JSType parameterType = ((IndexSignature)typeMember).parameterType;
            if (parameterType != null) {
                parameterType.accept(visitor);
            }
            if ((type = ((IndexSignature)typeMember).type) == null) continue;
            type.accept(visitor);
        }
    }

    @Override
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, @Nullable JSTypeSource newSource) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyTypeHierarchy"));
        }
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        JSTypeSource appliedTypeSource = this.getSourceForCopy(newSource);
        boolean shouldCleanSource = appliedTypeSource.getSourceElement() == null;
        for (JSRecordType.TypeMember member : this.getTypeMembers()) {
            if (member instanceof CallSignature) {
                CallSignature callSignature = (CallSignature)member;
                JSType newFunctionType = JSTypeUtils.transformTypeHierarchySafe(callSignature.getFunctionType(), childTransform, newSource);
                CallSignature newCallSignature = new CallSignature(callSignature.hasNew(), (JSFunctionTypeImpl)newFunctionType);
                typeMembers.add(newCallSignature);
                continue;
            }
            if (member instanceof IndexSignature) {
                IndexSignature indexSignature = (IndexSignature)member;
                typeMembers.add(new IndexSignature(JSTypeUtils.transformTypeHierarchySafe(indexSignature.getParameterType(), childTransform, newSource), JSTypeUtils.transformTypeHierarchySafe(indexSignature.getType(), childTransform, newSource), shouldCleanSource ? null : member.getSource()));
                continue;
            }
            if (!(member instanceof PropertySignature)) continue;
            PropertySignature propertySignature = (PropertySignature)member;
            PropertySignature newPropertySignature = new PropertySignature(propertySignature.name, JSTypeUtils.transformTypeHierarchySafe(propertySignature.getType(), childTransform, newSource), propertySignature.optional, shouldCleanSource ? null : member.getSource());
            typeMembers.add(newPropertySignature);
        }
        return new JSRecordTypeImpl(this.getSourceForCopy(newSource), typeMembers);
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyWithNewSource"));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, this.getTypeMembers());
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyWithNewSource"));
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    public JSRecordType asRecordType() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "asRecordType"));
        }
        return jSRecordTypeImpl;
    }

    public static class PropertySignature
    implements JSRecordType.TypeMember {
        @NotNull
        public final String name;
        @Nullable
        public final JSType type;
        public final boolean optional;
        @Nullable
        private PsiElement mySource;

        public PropertySignature(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement source) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignature", "<init>"));
            }
            this(name, type, optional);
            this.mySource = source;
        }

        public PropertySignature(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignature", "<init>"));
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignature", "getName"));
            }
            return string;
        }

        @Nullable
        public JSType getType() {
            return this.type;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertySignature)) {
                return false;
            }
            return this.name.equals(((PropertySignature)other).name) && (this.type != null ? this.type.isEquivalentTo(((PropertySignature)other).getType(), null) : ((PropertySignature)other).getType() == null) && this.optional == ((PropertySignature)other).optional;
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }
    }

    public static class IndexSignature
    implements JSRecordType.TypeMember {
        final JSType parameterType;
        final JSType type;
        private final PsiElement mySource;

        public IndexSignature(JSType parameterType, JSType type, PsiElement source) {
            this.mySource = source;
            this.parameterType = parameterType;
            this.type = type;
        }

        @NotNull
        public JSType getParameterType() {
            Object object = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignature", "getParameterType"));
            }
            return object;
        }

        @NotNull
        public JSType getType() {
            Object object = this.type != null ? this.type : JSAnyType.get(null, false);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignature", "getType"));
            }
            return object;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other) {
            if (!(other instanceof IndexSignature)) {
                return false;
            }
            return this.getParameterType().isEquivalentTo(((IndexSignature)other).getParameterType(), null) && this.getType().isEquivalentTo(((IndexSignature)other).getType(), null);
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }
    }

    public static class CallSignature
    implements JSRecordType.TypeMember {
        final boolean hasNew;
        @NotNull
        final JSFunctionTypeImpl functionType;

        public CallSignature(boolean hasNew, @NotNull JSFunctionTypeImpl functionType) {
            if (functionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignature", "<init>"));
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        public boolean hasNew() {
            return this.hasNew;
        }

        @NotNull
        public JSFunctionTypeImpl getFunctionType() {
            JSFunctionTypeImpl jSFunctionTypeImpl = this.functionType;
            if (jSFunctionTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignature", "getFunctionType"));
            }
            return jSFunctionTypeImpl;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other) {
            if (!(other instanceof CallSignature)) {
                return false;
            }
            return ((CallSignature)other).hasNew() == this.hasNew() && ((CallSignature)other).getFunctionType().isEquivalentTo(this.getFunctionType(), null);
        }

        @Nullable
        public PsiElement getSource() {
            return this.functionType.getSource().getSourceElement();
        }
    }
}

