/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringLiteralTypeImpl
extends JSStringType {
    private final String myLiteral;
    private final boolean myStrict;

    public JSStringLiteralTypeImpl(@NotNull String literal, JSTypeSource source) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "<init>"));
        }
        this(literal, false, source);
    }

    public JSStringLiteralTypeImpl(@NotNull String literal, boolean strict, JSTypeSource source) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "<init>"));
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myStrict = strict;
    }

    public String getLiteral() {
        return this.myLiteral;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (this.isEcma() || format == JSType.TypeTextFormat.RESOLVED) {
            if ("String" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "getTypeText"));
            }
            return "String";
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            if ("string" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "getTypeText"));
            }
            return "string";
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "\"" + this.myLiteral + "\"" + (this.myStrict ? "!" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = "String(\"" + this.myLiteral + "\")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSStringLiteralTypeImpl && this.getSource().isExplicitlyDeclared() && (this.isJavaScript() || this.myStrict)) {
            return this.myLiteral.equals(((JSStringLiteralTypeImpl)elementType).myLiteral);
        }
        if (this.myStrict && elementType instanceof JSStringType) {
            return false;
        }
        return super.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentTo(JSType type, ProcessingContext processingContext) {
        return type instanceof JSStringLiteralTypeImpl && this.myLiteral.equals(((JSStringLiteralTypeImpl)type).myLiteral) || JSTypeCastUtil.isEquivalentCommon(this, type, processingContext);
    }

    @Override
    @NotNull
    public JSStringLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "copyWithNewSource"));
        }
        JSStringLiteralTypeImpl jSStringLiteralTypeImpl = new JSStringLiteralTypeImpl(this.getLiteral(), this.myStrict, source);
        if (jSStringLiteralTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl", "copyWithNewSource"));
        }
        return jSStringLiteralTypeImpl;
    }
}

