/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeGuardChecker {
    private static final boolean IS_ENABLED_FOR_JS = true;
    public static final String[] TYPE_NAMES = new String[]{"string", "number", "boolean"};
    private final String myVariableName;
    private final PsiElement myPlace;
    @NotNull
    private final JSTypeSource mySource;
    @Nullable
    private final JSType myType;
    private final boolean myIsTypeScript;

    private static boolean isEnabledForJs() {
        return true;
    }

    public static boolean isAvailable(@NotNull PsiElement place, @Nullable JSType type) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "isAvailable"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(place);
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null) {
            return false;
        }
        if (holder == null || holder.isECMA4) {
            return false;
        }
        if (holder.isTypeScript && (type == null || type instanceof JSAnyType)) {
            return false;
        }
        if (!holder.isTypeScript && !JSTypeGuardChecker.isEnabledForJs()) {
            return false;
        }
        return !(type instanceof JSArrayTypeImpl) && !(type instanceof JSPrimitiveType) && !(type instanceof JSPrimitiveArrayType) && !(type instanceof JSUndefinedType);
    }

    public JSTypeGuardChecker(@NotNull PsiElement place, @Nullable JSType startType, @NotNull String variableName) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "<init>"));
        }
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "<init>"));
        }
        this.myVariableName = variableName;
        this.myPlace = place;
        this.myType = startType;
        this.mySource = this.myType == null ? JSTypeSource.EMPTY : this.myType.getSource();
        this.myIsTypeScript = DialectDetector.isTypeScript(place);
    }

    @Nullable
    public JSType getNarrowedType() {
        JSType defType;
        JSType type = this.myType;
        boolean typeWasNarrowed = false;
        if (type != null && type instanceof JSTypeImpl && (defType = ((JSTypeImpl)type).getTypedef(null, new ProcessingContext())) != null) {
            type = defType;
        }
        PsiElement node = this.myPlace;
        while (node.getParent() != null) {
            JSType distinct;
            JSBinaryExpression binaryExpression;
            PsiElement child = node;
            node = node.getParent();
            JSType narrowedType = type;
            if (node instanceof JSExecutionScope && !(node instanceof JSFunctionExpression) || node instanceof TypeScriptModule) break;
            if (node instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)node;
                if (ifStatement.getCondition() != child) {
                    narrowedType = this.narrowType(type, ifStatement.getCondition(), child == ifStatement.getThen());
                }
            } else if (node instanceof JSConditionalExpression) {
                JSConditionalExpression conditionalExpression = (JSConditionalExpression)node;
                if (conditionalExpression.getCondition() != child) {
                    narrowedType = this.narrowType(type, conditionalExpression.getCondition(), conditionalExpression.getThen() == child);
                }
            } else if (node instanceof JSBinaryExpression && child == (binaryExpression = (JSBinaryExpression)node).getROperand()) {
                if (binaryExpression.getOperationSign() == JSTokenTypes.ANDAND) {
                    narrowedType = this.narrowType(type, binaryExpression.getLOperand(), true);
                } else if (binaryExpression.getOperationSign() == JSTokenTypes.OROR) {
                    narrowedType = this.narrowType(type, binaryExpression.getLOperand(), false);
                }
            }
            if (narrowedType != type) {
                if (this.isVariableAssignedWithin(node)) break;
                type = narrowedType;
                typeWasNarrowed = true;
            }
            if ((distinct = this.getDistinctTypeFromUnionType(type)) == null) continue;
            return distinct;
        }
        if (!typeWasNarrowed) {
            return this.myType;
        }
        JSType distinct = this.getDistinctTypeFromUnionType(type);
        if (distinct != null) {
            return distinct;
        }
        return type;
    }

    @Nullable
    protected JSType getDistinctTypeFromUnionType(@Nullable JSType type) {
        List<JSType> types;
        if (type instanceof JSCompositeTypeImpl && (types = ((JSCompositeTypeImpl)type).getTypes()).size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types, null);
        }
        return null;
    }

    private boolean isVariableAssignedWithin(PsiElement element) {
        ASTNode astNode = element.getNode();
        if (astNode instanceof CompositeElement) {
            return JSTreeUtil.definedOrAssignedInCodeBlock(this.myVariableName, true, (CompositeElement)astNode);
        }
        return false;
    }

    @Nullable
    private JSType narrowTypeByEquality(@Nullable JSType type, JSBinaryExpression expr, boolean assumeTrue) {
        JSExpression left = expr.getLOperand();
        JSExpression right = expr.getROperand();
        if (left instanceof JSPrefixExpression && ((JSPrefixExpression)left).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD && right instanceof JSLiteralExpression) {
            JSExpression expression = ((JSPrefixExpression)left).getExpression();
            if (expression == null) {
                return type;
            }
            if (!expression.getText().equals(this.myVariableName)) {
                return type;
            }
            Object value = ((JSLiteralExpression)right).getValue();
            if (!(value instanceof String)) {
                return type;
            }
            String possiblePrimitiveTypeName = (String)value;
            if (expr.getOperationSign() == JSTokenTypes.NEQEQ) {
                boolean bl = assumeTrue = !assumeTrue;
            }
            if (assumeTrue) {
                if (!JSTypeGuardChecker.isPrimitiveType(possiblePrimitiveTypeName)) {
                    return this.removeTypeFromUnionType(type, TYPE_NAMES, true);
                }
                if (type == null || this.isTypeSubTypeOf(possiblePrimitiveTypeName, type)) {
                    return this.buildPrimitiveType(possiblePrimitiveTypeName);
                }
                return this.removeTypeFromUnionType(type, possiblePrimitiveTypeName, false);
            }
            if (JSTypeGuardChecker.isPrimitiveType(possiblePrimitiveTypeName)) {
                return this.removeTypeFromUnionType(type, possiblePrimitiveTypeName, true);
            }
            return type;
        }
        return type;
    }

    @Nullable
    private JSType narrowTypeByAnd(@Nullable JSType type, JSBinaryExpression expr, boolean assumeTrue) {
        if (assumeTrue) {
            return this.narrowType(this.narrowType(type, expr.getLOperand(), true), expr.getROperand(), true);
        }
        JSType type1 = this.narrowType(type, expr.getLOperand(), false);
        JSType type2 = this.narrowType(this.narrowType(type, expr.getLOperand(), true), expr.getROperand(), false);
        if (type1 == type) {
            return type2;
        }
        if (type2 == type) {
            return type1;
        }
        return this.getUnionType(type1, type2);
    }

    @Nullable
    private JSType narrowTypeByOr(@Nullable JSType type, JSBinaryExpression expr, boolean assumeTrue) {
        if (assumeTrue) {
            return this.getUnionType(this.narrowType(type, expr.getLOperand(), true), this.narrowType(this.narrowType(type, expr.getLOperand(), false), expr.getROperand(), true));
        }
        return this.narrowType(this.narrowType(type, expr.getLOperand(), false), expr.getROperand(), false);
    }

    @Nullable
    private JSType narrowTypeByInstanceof(@Nullable JSType type, JSBinaryExpression expr, boolean assumeTrue) {
        if (this.myIsTypeScript && type instanceof JSAnyType || !assumeTrue) {
            return type;
        }
        JSExpression lOperand = expr.getLOperand();
        if (!(lOperand instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)lOperand, this.myVariableName)) {
            return type;
        }
        JSExpression rOperand = expr.getROperand();
        if (!(rOperand instanceof JSReferenceExpression)) {
            return type;
        }
        JSReferenceExpression operand = (JSReferenceExpression)rOperand;
        JSType rightType = JSSymbolUtil.createTypeFromReferenceExpression(operand, JSTypeContext.INSTANCE);
        if (rightType == null) {
            return type;
        }
        return JSTypeGuardChecker.getNarrowedType(type, rightType);
    }

    private static JSType getNarrowedType(@Nullable JSType type, JSType narrowedTypeCandidate) {
        if (type instanceof JSCompositeTypeImpl) {
            return JSTypeGuardChecker.saveOnlySubtypes((JSCompositeTypeImpl)type, narrowedTypeCandidate);
        }
        if (type == null || type instanceof JSAnyType || JSTypeGuardChecker.isTypeSubTypeOf(narrowedTypeCandidate, type)) {
            return narrowedTypeCandidate;
        }
        return type;
    }

    private JSType narrowTypeByTypePredicate(@Nullable JSType type, JSCallExpression expr, boolean assumeTrue) {
        if (this.myIsTypeScript && type instanceof JSAnyType || !this.myIsTypeScript) {
            return type;
        }
        JSType expressionJSType = JSResolveUtil.getExpressionJSType((JSExpression)expr);
        if (!(expressionJSType instanceof TypeScriptTypePredicateTypeImpl)) {
            return type;
        }
        TypeScriptTypePredicateTypeImpl typePredicate = (TypeScriptTypePredicateTypeImpl)expressionJSType;
        int index = typePredicate.getParameterIndex();
        JSType guardType = typePredicate.getGuardType();
        if (index < 0 || guardType == null) {
            return type;
        }
        JSExpression[] arguments = expr.getArguments();
        if (arguments.length <= index) {
            return type;
        }
        JSExpression argument = arguments[index];
        if (!(argument instanceof JSReferenceExpression)) {
            return type;
        }
        if (!JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)argument, this.myVariableName)) {
            return type;
        }
        if (!assumeTrue && type instanceof JSCompositeTypeImpl) {
            return JSTypeGuardChecker.removeOnlySubtypes((JSCompositeTypeImpl)type, guardType);
        }
        return JSTypeGuardChecker.getNarrowedType(type, guardType);
    }

    @Nullable
    private JSType narrowType(@Nullable JSType type, JSExpression expression, boolean assumeTrue) {
        if (expression instanceof JSParenthesizedExpression) {
            return this.narrowType(type, ((JSParenthesizedExpression)expression).getInnerExpression(), assumeTrue);
        }
        if (expression instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            if (sign == JSTokenTypes.EQEQEQ || sign == JSTokenTypes.NEQEQ) {
                return this.narrowTypeByEquality(type, binaryExpression, assumeTrue);
            }
            if (sign == JSTokenTypes.ANDAND) {
                return this.narrowTypeByAnd(type, binaryExpression, assumeTrue);
            }
            if (sign == JSTokenTypes.OROR) {
                return this.narrowTypeByOr(type, binaryExpression, assumeTrue);
            }
            if (sign == JSTokenTypes.INSTANCEOF_KEYWORD) {
                return this.narrowTypeByInstanceof(type, binaryExpression, assumeTrue);
            }
        }
        if (expression instanceof JSPrefixExpression && ((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.EXCL) {
            return this.narrowType(type, ((JSPrefixExpression)expression).getExpression(), !assumeTrue);
        }
        if (expression instanceof JSCallExpression) {
            return this.narrowTypeByTypePredicate(type, (JSCallExpression)expression, assumeTrue);
        }
        return type;
    }

    @Nullable
    private JSType getUnionType(@Nullable JSType type1, @Nullable JSType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return JSCompositeTypeImpl.getCommonType(type1, type2, this.mySource, false);
    }

    @Nullable
    private JSType removeTypeFromUnionType(@Nullable JSType type, String typeName, boolean isOfType) {
        if (type == null) {
            return null;
        }
        return this.removeTypeFromUnionType(type, new String[]{typeName}, isOfType);
    }

    @Nullable
    private JSType removeTypeFromUnionType(@Nullable JSType type, String[] typeNames, boolean isOfType) {
        if (type instanceof JSCompositeTypeImpl) {
            ArrayList result = ContainerUtil.newArrayList();
            for (JSType jsType : ((JSCompositeTypeImpl)type).getTypes()) {
                if (ArrayUtil.contains((String)jsType.getTypeText(), (String[])typeNames) == isOfType) continue;
                result.add(jsType);
            }
            if (!result.isEmpty()) {
                return new JSCompositeTypeImpl(this.mySource, result);
            }
        }
        return type;
    }

    private static boolean isPrimitiveType(String name) {
        return ArrayUtil.contains((String)name, (String[])TYPE_NAMES);
    }

    @NotNull
    private JSType buildPrimitiveType(String name) {
        JSType jSType = JSNamedType.createType(name, this.mySource, JSContext.INSTANCE);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "buildPrimitiveType"));
        }
        return jSType;
    }

    @NotNull
    private static JSType saveOnlySubtypes(@NotNull JSCompositeTypeImpl type, @NotNull JSType typeForFilter) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "saveOnlySubtypes"));
        }
        if (typeForFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeForFilter", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "saveOnlySubtypes"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSType jsType : type.getTypes()) {
            if (!JSTypeGuardChecker.isTypeSubTypeOf(jsType, typeForFilter)) continue;
            result.add(jsType);
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(type.getSource(), result);
        if (jSCompositeTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "saveOnlySubtypes"));
        }
        return jSCompositeTypeImpl;
    }

    @NotNull
    private static JSType removeOnlySubtypes(@NotNull JSCompositeTypeImpl type, @NotNull JSType typeForFilter) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "removeOnlySubtypes"));
        }
        if (typeForFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeForFilter", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "removeOnlySubtypes"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSType jsType : type.getTypes()) {
            if (JSTypeGuardChecker.isTypeSubTypeOf(jsType, typeForFilter)) continue;
            result.add(jsType);
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(type.getSource(), result);
        if (jSCompositeTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "removeOnlySubtypes"));
        }
        return jSCompositeTypeImpl;
    }

    private boolean isTypeSubTypeOf(String name, @NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "isTypeSubTypeOf"));
        }
        return type.isDirectlyAssignableType(this.buildPrimitiveType(name), null);
    }

    private static boolean isTypeSubTypeOf(@NotNull JSType type1, @NotNull JSType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "isTypeSubTypeOf"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSTypeGuardChecker", "isTypeSubTypeOf"));
        }
        return type2.isDirectlyAssignableType(type1, null);
    }
}

