/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeParser {
    public static final char GENERIC_PARAMETER_DELIMITER = '%';
    public static final String TYPEOF_IDENTIFIER = "#typeof";
    public static final String COMPONENT_OF_ITERABLE_IDENTIFIER = "#compof";
    public static final String CALL_EXPRESSION_PREFIX = "#call";
    public static final String TYPE_PREDICATE_PREFIX = "#guard";
    public static final char SINGLE_TYPE_SPECIAL_CHAR = '^';
    public static final String SOME_INVALID_TYPE_PART = "^^";
    public static final String MIXIN_DELIMITER = "+";
    public static final String MODULE_PREFIX = "module:";
    public static final String EVENT_PREFIX = "event:";
    @NotNull
    private final String myTypeString;
    private final JSTypeVisitor myVisitor;
    private int myCurrentOffset;
    @NotNull
    private final JSTypeSource mySource;
    private boolean myParsingFunction;

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSTypeParser", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeParser", "<init>"));
        }
        this(typeString, source, null);
    }

    public JSTypeParser(@NotNull String typeString, JSTypeVisitor visitor) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSTypeParser", "<init>"));
        }
        this(typeString, JSTypeSource.EMPTY, visitor);
    }

    private JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource typeSource, @Nullable JSTypeVisitor visitor) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/types/JSTypeParser", "<init>"));
        }
        if (typeSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSource", "com/intellij/lang/javascript/psi/types/JSTypeParser", "<init>"));
        }
        this.myTypeString = typeString;
        this.mySource = typeSource;
        this.myVisitor = visitor;
        this.myCurrentOffset = 0;
    }

    @Nullable
    public JSType parse() {
        return this.parse(false);
    }

    @Nullable
    public JSType parse(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseComposite(true), allowCommentAfterType);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType() {
        return this.parseParameterType(false);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseInnerParameterType(true), allowCommentAfterType);
    }

    @Nullable
    public JSType parseNamepath() {
        return this.handleParseResult(this.parseSingleType(true), false);
    }

    private <T> T handleParseResult(T result, boolean allowCommentAfterType) {
        if (!allowCommentAfterType && this.myCurrentOffset != this.myTypeString.length()) {
            return null;
        }
        return result;
    }

    public int getTypeStringLength() {
        return this.myCurrentOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSParameterTypeDecorator parseInnerParameterType(boolean allowComma) {
        JSType type;
        this.advanceSpaces();
        boolean rest = false;
        if (this.myTypeString.startsWith("...", this.myCurrentOffset)) {
            char afterDotsChar;
            rest = true;
            this.myCurrentOffset += 3;
            this.advanceSpaces();
            if (this.myCurrentOffset >= this.myTypeString.length() || (afterDotsChar = this.myTypeString.charAt(this.myCurrentOffset)) == ',' || afterDotsChar == ')' || afterDotsChar == '}') {
                type = JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared());
            } else {
                boolean parseBrackets;
                boolean bl = parseBrackets = this.myParsingFunction && this.myTypeString.startsWith("[", this.myCurrentOffset);
                if (parseBrackets) {
                    ++this.myCurrentOffset;
                }
                type = this.parseComposite(false);
                if (parseBrackets) {
                    if (!this.myTypeString.startsWith("]", this.myCurrentOffset)) return null;
                    ++this.myCurrentOffset;
                }
            }
        } else {
            type = this.parseComposite(allowComma);
        }
        this.advanceSpaces();
        boolean optional = false;
        if (this.myTypeString.startsWith("?", this.myCurrentOffset) || this.myTypeString.startsWith("=", this.myCurrentOffset)) {
            optional = true;
            ++this.myCurrentOffset;
            this.advanceSpaces();
            while (this.myCurrentOffset < this.myTypeString.length() && (this.myTypeString.charAt(this.myCurrentOffset) == '\"' || StringUtil.isJavaIdentifierPart((char)this.myTypeString.charAt(this.myCurrentOffset)))) {
                ++this.myCurrentOffset;
            }
        } else if (this.myTypeString.startsWith(",", this.myCurrentOffset)) {
            int beforeCommaOffset = this.myCurrentOffset++;
            this.advanceSpaces();
            if (this.myTypeString.startsWith("optional", this.myCurrentOffset)) {
                this.myCurrentOffset += 8;
                optional = true;
            } else {
                this.myCurrentOffset = beforeCommaOffset;
            }
        }
        this.advanceSpaces();
        if (type == null && !optional) {
            if (!rest) return null;
        }
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(type, optional, rest, this.mySource.isExplicitlyDeclared());
        return jSParameterTypeDecoratorImpl;
    }

    private JSType parseComposite(boolean allowComma) {
        return this.parseComposite(allowComma, "|/", true);
    }

    @Nullable
    private JSType parseComposite(boolean allowComma, @NotNull String delimiters, boolean isUnion) {
        if (delimiters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiters", "com/intellij/lang/javascript/psi/types/JSTypeParser", "parseComposite"));
        }
        this.advanceSpaces();
        if (this.myCurrentOffset >= this.myTypeString.length()) {
            return null;
        }
        JSType type = this.parseTypeFromComposite(isUnion);
        this.advanceSpaces();
        ArrayList<JSType> addedUnionOptions = null;
        while (this.myCurrentOffset < this.myTypeString.length() && (delimiters.indexOf(this.myTypeString.charAt(this.myCurrentOffset)) != -1 || allowComma && ',' == this.myTypeString.charAt(this.myCurrentOffset))) {
            JSType unionOption;
            int commaOffset = ',' != this.myTypeString.charAt(this.myCurrentOffset) ? -1 : this.myCurrentOffset;
            ++this.myCurrentOffset;
            if (addedUnionOptions == null) {
                addedUnionOptions = new ArrayList<JSType>();
            }
            if ((unionOption = this.parseTypeFromComposite(isUnion)) == null) continue;
            this.advanceSpaces();
            if (commaOffset >= 0 && unionOption instanceof JSTypeImpl && "optional".equals(unionOption.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                this.myCurrentOffset = commaOffset;
                break;
            }
            addedUnionOptions.add(unionOption);
        }
        if (addedUnionOptions != null && !addedUnionOptions.isEmpty()) {
            if (type != null) {
                addedUnionOptions.add(0, type);
            }
            type = isUnion ? new JSCompositeTypeImpl(this.mySource, (List<JSType>)addedUnionOptions) : new JSIntersectionTypeImpl(this.mySource, (Collection<JSType>)addedUnionOptions);
        }
        return type;
    }

    private JSType parseTypeFromComposite(boolean isUnion) {
        if (isUnion) {
            return this.parseComposite(false, "&", false);
        }
        return this.parseType();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSType parseType() {
        void var1_16;
        boolean decorationsAdded;
        this.advanceSpaces();
        if (this.myCurrentOffset >= this.myTypeString.length()) {
            return null;
        }
        char c = this.myTypeString.charAt(this.myCurrentOffset);
        if (c == '{') {
            JSRecordTypeImpl jSRecordTypeImpl = this.parseRecordType();
            if (jSRecordTypeImpl == null) {
                return null;
            }
        } else if (c == '(') {
            ++this.myCurrentOffset;
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.myTypeString.startsWith(")", this.myCurrentOffset)) return null;
            ++this.myCurrentOffset;
        } else if (c == '[') {
            ++this.myCurrentOffset;
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.myTypeString.startsWith("]", this.myCurrentOffset)) return null;
            ++this.myCurrentOffset;
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(jSType, this.mySource);
        } else if (c == 'f' && this.myTypeString.startsWith("function", this.myCurrentOffset)) {
            int funcStartOffset = this.myCurrentOffset;
            this.myCurrentOffset += 8;
            this.advanceSpaces();
            if (this.myTypeString.startsWith(":", this.myCurrentOffset) || this.myTypeString.startsWith("(", this.myCurrentOffset)) {
                JSFunctionTypeImpl jSFunctionTypeImpl = this.parseFunctionAfterKeyword();
            } else {
                this.myCurrentOffset = funcStartOffset;
                JSType jSType = this.parseSingleType(false);
            }
        } else if (c == '\"' || c == '\'') {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this.parseLiteralType();
        } else if (this.myTypeString.startsWith(TYPEOF_IDENTIFIER, this.myCurrentOffset)) {
            JSTypeofTypeImpl jSTypeofTypeImpl = this.parseTypeofType();
        } else if (this.myTypeString.startsWith(COMPONENT_OF_ITERABLE_IDENTIFIER, this.myCurrentOffset)) {
            JSIterableComponentTypeImpl jSIterableComponentTypeImpl = this.parseIterableComponentType();
        } else if (this.myTypeString.startsWith(CALL_EXPRESSION_PREFIX, this.myCurrentOffset)) {
            JSCallExpressionType jSCallExpressionType = this.parseCallExpressionType();
        } else if (this.myTypeString.startsWith(TYPE_PREDICATE_PREFIX, this.myCurrentOffset)) {
            JSType jSType = this.parseTypePredicate();
        } else if (c == '%') {
            int genericParamStartOffset = ++this.myCurrentOffset;
            while (this.myCurrentOffset < this.myTypeString.length() && (c = this.myTypeString.charAt(this.myCurrentOffset)) != '\u0000' && (StringUtil.isJavaIdentifierPart((char)c) || c == '.' || c == '#')) {
                ++this.myCurrentOffset;
            }
            JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.myTypeString.substring(genericParamStartOffset, this.myCurrentOffset), this.mySource);
            if (!this.myTypeString.startsWith(String.valueOf('%'), this.myCurrentOffset)) {
                return null;
            }
            ++this.myCurrentOffset;
        } else {
            JSType jSType = this.parseSingleType(false);
        }
        do {
            this.advanceSpaces();
            decorationsAdded = true;
            if (this.myTypeString.startsWith("[]", this.myCurrentOffset)) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl((JSType)var1_16, this.mySource);
                this.myCurrentOffset += 2;
                continue;
            }
            if (this.myTypeString.startsWith("!", this.myCurrentOffset)) {
                JSType jSType = this.addTypeDecoration((JSType)var1_16, JSDecoratedTypeImpl.TypeDecoration.NOTNULL);
                ++this.myCurrentOffset;
                continue;
            }
            if (this.myTypeString.startsWith("<", this.myCurrentOffset)) {
                ++this.myCurrentOffset;
                while (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) != '>') {
                    int typeStart = this.myCurrentOffset;
                    JSType jSType = this.addGenericArgument((JSType)var1_16, this.parseComposite(false));
                    this.advanceSpaces();
                    if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ',') {
                        ++this.myCurrentOffset;
                        this.advanceSpaces();
                    }
                    if (typeStart != this.myCurrentOffset) continue;
                    return null;
                }
                if (this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != '>') {
                    return null;
                }
                ++this.myCurrentOffset;
                continue;
            }
            if (this.myTypeString.startsWith(".", this.myCurrentOffset)) {
                ++this.myCurrentOffset;
                continue;
            }
            if (this.myTypeString.startsWith(MIXIN_DELIMITER, this.myCurrentOffset)) {
                ++this.myCurrentOffset;
                JSType mixed = this.parseType();
                if (var1_16 == null || mixed == null) continue;
                JSMixinTypeImpl jSMixinTypeImpl = new JSMixinTypeImpl((JSType)var1_16, mixed, this.mySource);
                continue;
            }
            decorationsAdded = false;
        } while (decorationsAdded);
        return var1_16;
    }

    private JSTypeofTypeImpl parseTypeofType() {
        char c;
        char c2;
        assert (this.myTypeString.startsWith(TYPEOF_IDENTIFIER, this.myCurrentOffset));
        this.myCurrentOffset += TYPEOF_IDENTIFIER.length();
        ++this.myCurrentOffset;
        int startOffset = 0;
        while (this.myCurrentOffset < this.myTypeString.length() && Character.isDigit(c2 = this.myTypeString.charAt(this.myCurrentOffset))) {
            startOffset = startOffset * 10 + c2 - 48;
            ++this.myCurrentOffset;
        }
        ++this.myCurrentOffset;
        int endOffset = 0;
        while (this.myCurrentOffset < this.myTypeString.length() && Character.isDigit(c = this.myTypeString.charAt(this.myCurrentOffset))) {
            endOffset = endOffset * 10 + c - 48;
            ++this.myCurrentOffset;
        }
        if (this.myCurrentOffset >= this.myTypeString.length()) {
            return null;
        }
        ++this.myCurrentOffset;
        PsiFile file = this.mySource.getScope();
        return file != null ? new JSTypeofTypeImpl(new TextRange(startOffset, endOffset), file, this.mySource) : null;
    }

    private JSIterableComponentTypeImpl parseIterableComponentType() {
        assert (this.myTypeString.startsWith(COMPONENT_OF_ITERABLE_IDENTIFIER, this.myCurrentOffset));
        this.myCurrentOffset += TYPEOF_IDENTIFIER.length();
        ++this.myCurrentOffset;
        JSType type = this.parseComposite(false);
        if (this.hasSymbol() && this.getSymbol() == ')') {
            ++this.myCurrentOffset;
        }
        if (type == null) {
            type = JSAnyType.get(this.mySource.getSourceElement(), true);
        }
        return new JSIterableComponentTypeImpl(type, this.mySource);
    }

    private JSCallExpressionType parseCallExpressionType() {
        assert (this.myTypeString.startsWith(CALL_EXPRESSION_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += CALL_EXPRESSION_PREFIX.length();
        return new JSCallExpressionType(this.readIdentifier(), this.mySource);
    }

    @NotNull
    private String readIdentifier() {
        assert (this.hasSymbol());
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && Character.isJavaIdentifierPart(this.myTypeString.charAt(this.myCurrentOffset))) {
            ++this.myCurrentOffset;
        }
        String string = this.myTypeString.substring(start, this.myCurrentOffset);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeParser", "readIdentifier"));
        }
        return string;
    }

    private int readPositiveNumber() {
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && Character.isDigit(this.myTypeString.charAt(this.myCurrentOffset))) {
            ++this.myCurrentOffset;
        }
        try {
            if (this.myCurrentOffset > start) {
                return Integer.parseInt(this.myTypeString.substring(start, this.myCurrentOffset));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    @NotNull
    private JSType parseTypePredicate() {
        assert (this.myTypeString.startsWith(TYPE_PREDICATE_PREFIX, this.myCurrentOffset));
        this.myCurrentOffset += TYPE_PREDICATE_PREFIX.length();
        this.advanceSpaces();
        String parameterName = null;
        if (this.myTypeString.charAt(this.myCurrentOffset) != '?') {
            parameterName = this.readIdentifier();
        } else {
            ++this.myCurrentOffset;
        }
        this.advanceSpaces();
        boolean isNegative = false;
        if (this.hasSymbol() && this.getSymbol() == '-') {
            isNegative = true;
            ++this.myCurrentOffset;
        }
        int parameterIndex = this.readPositiveNumber();
        JSType type = this.parseType();
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(type, this.mySource, parameterName, isNegative ? -1 : parameterIndex);
        if (typeScriptTypePredicateTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeParser", "parseTypePredicate"));
        }
        return typeScriptTypePredicateTypeImpl;
    }

    private JSRecordTypeImpl parseRecordType() {
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        ++this.myCurrentOffset;
        this.advanceSpaces();
        while (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) != '}') {
            int labelStart = this.myCurrentOffset;
            if (this.myTypeString.startsWith("(", this.myCurrentOffset)) {
                JSFunctionTypeImpl callSignature = this.parseFunctionAfterKeyword();
                if (callSignature != null) {
                    typeMembers.add(new JSRecordTypeImpl.CallSignature(false, callSignature));
                }
            } else {
                boolean optional = false;
                if (this.myTypeString.startsWith("[", this.myCurrentOffset)) {
                    optional = true;
                    ++this.myCurrentOffset;
                    this.advanceSpaces();
                }
                labelStart = this.myCurrentOffset;
                while (this.myCurrentOffset < this.myTypeString.length() && (StringUtil.isJavaIdentifierPart((char)this.getSymbol()) || '.' == this.getSymbol())) {
                    ++this.myCurrentOffset;
                }
                String recordLabel = this.myTypeString.substring(labelStart, this.myCurrentOffset);
                this.advanceSpaces();
                if (optional && this.myTypeString.startsWith("]", this.myCurrentOffset)) {
                    ++this.myCurrentOffset;
                    this.advanceSpaces();
                }
                if (!optional && "new".equals(recordLabel) && this.myTypeString.startsWith("(", this.myCurrentOffset)) {
                    JSFunctionTypeImpl callSignature = this.parseFunctionAfterKeyword();
                    if (callSignature != null) {
                        typeMembers.add(new JSRecordTypeImpl.CallSignature(true, callSignature));
                    }
                } else {
                    JSParameterTypeDecorator recordPropertyType = null;
                    if (this.myTypeString.startsWith("?", this.myCurrentOffset)) {
                        optional = true;
                        ++this.myCurrentOffset;
                        this.advanceSpaces();
                    }
                    if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ':') {
                        ++this.myCurrentOffset;
                        this.advanceSpaces();
                        recordPropertyType = this.parseInnerParameterType(false);
                        this.advanceSpaces();
                    }
                    JSType type = recordPropertyType != null ? recordPropertyType.getType() : null;
                    typeMembers.add(new JSRecordTypeImpl.PropertySignature(recordLabel, type, optional |= recordPropertyType != null && recordPropertyType.isOptional()));
                    if (this.myVisitor != null) {
                        this.myVisitor.visitRecordProperty(labelStart, recordLabel, type != null ? type.getTypeText() : null);
                    }
                }
            }
            if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ',') {
                ++this.myCurrentOffset;
                this.advanceSpaces();
            }
            if (labelStart != this.myCurrentOffset) continue;
            break;
        }
        if (this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != '}') {
            return null;
        }
        ++this.myCurrentOffset;
        return new JSRecordTypeImpl(this.mySource, typeMembers);
    }

    @Nullable
    private JSStringLiteralTypeImpl parseLiteralType() {
        char quote = this.myTypeString.charAt(this.myCurrentOffset);
        ++this.myCurrentOffset;
        int literalStart = this.myCurrentOffset;
        boolean screened = false;
        while (this.myCurrentOffset < this.myTypeString.length()) {
            char c = this.myTypeString.charAt(this.myCurrentOffset);
            if (c == '\\') {
                screened = !screened;
            } else if (!screened && c == quote) {
                ++this.myCurrentOffset;
                String literalValue = this.myTypeString.substring(literalStart, this.myCurrentOffset - 1);
                boolean isStrict = false;
                if (this.hasSymbol() && this.getSymbol() == '!') {
                    ++this.myCurrentOffset;
                    isStrict = true;
                }
                return new JSStringLiteralTypeImpl(literalValue, isStrict, this.mySource);
            }
            ++this.myCurrentOffset;
        }
        return null;
    }

    @Nullable
    private JSType addTypeDecoration(@Nullable JSType type, JSDecoratedTypeImpl.TypeDecoration decoration) {
        JSDecoratedTypeImpl decoratedType;
        if (type == null) {
            return null;
        }
        if (type instanceof JSDecoratedTypeImpl) {
            EnumSet<JSDecoratedTypeImpl.TypeDecoration> decorations = EnumSet.copyOf(((JSDecoratedTypeImpl)type).getDecorations());
            decorations.add(decoration);
            decoratedType = new JSDecoratedTypeImpl(this.mySource, ((JSDecoratedTypeImpl)type).getType(), decorations);
        } else {
            decoratedType = new JSDecoratedTypeImpl(this.mySource, type, EnumSet.of(decoration));
        }
        return decoratedType;
    }

    @Nullable
    private JSType addGenericArgument(JSType type, JSType genericArgument) {
        if (type == null || genericArgument == null) {
            return null;
        }
        if (type instanceof JSGenericTypeImpl) {
            ((JSGenericTypeImpl)type).addGenericArgument(genericArgument);
            return type;
        }
        return new JSGenericTypeImpl(this.mySource, type, genericArgument);
    }

    @Nullable
    private JSFunctionTypeImpl parseFunctionAfterKeyword() {
        SmartList decorators = new SmartList();
        JSType newType = null;
        JSType thisType = null;
        this.myParsingFunction = true;
        if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == '(') {
            ++this.myCurrentOffset;
            this.advanceSpaces();
            while (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) != ')') {
                JSType paramType;
                int paramStart = this.myCurrentOffset;
                while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isJavaIdentifierPart((char)this.myTypeString.charAt(this.myCurrentOffset))) {
                    ++this.myCurrentOffset;
                }
                int identifierEnd = this.myCurrentOffset;
                this.advanceSpaces();
                String recordLabel = null;
                if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ':') {
                    ++this.myCurrentOffset;
                    recordLabel = this.myTypeString.substring(paramStart, identifierEnd);
                } else {
                    this.myCurrentOffset = paramStart;
                }
                JSParameterTypeDecorator paramTypeDecorator = this.parseInnerParameterType(false);
                JSType jSType = paramType = paramTypeDecorator != null ? paramTypeDecorator.getType() : null;
                if ("this".equals(recordLabel)) {
                    thisType = paramType;
                } else if ("new".equals(recordLabel)) {
                    newType = paramType;
                } else {
                    boolean optional = paramTypeDecorator != null && paramTypeDecorator.isOptional();
                    boolean rest = paramTypeDecorator != null && paramTypeDecorator.isRest();
                    JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(paramType, optional, rest, true);
                    decorators.add(decorator);
                }
                this.advanceSpaces();
                if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ',') {
                    ++this.myCurrentOffset;
                    this.advanceSpaces();
                }
                if (this.myCurrentOffset != paramStart) continue;
                return null;
            }
            if (this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != ')') {
                return null;
            }
            ++this.myCurrentOffset;
        }
        this.advanceSpaces();
        JSType returnType = null;
        if (this.myCurrentOffset < this.myTypeString.length() && this.myTypeString.charAt(this.myCurrentOffset) == ':') {
            ++this.myCurrentOffset;
            returnType = this.parseType();
        }
        return new JSFunctionTypeImpl(this.mySource, (List<JSParameterTypeDecorator>)decorators, returnType, thisType, newType);
    }

    @Nullable
    private JSType parseSingleType(boolean isModule) {
        JSType type;
        char c;
        this.advanceSpaces();
        char c2 = c = this.myCurrentOffset < this.myTypeString.length() ? this.myTypeString.charAt(this.myCurrentOffset) : (char)'\u0000';
        if (c == '?') {
            ++this.myCurrentOffset;
            this.advanceSpaces();
            int afterQuestOffset = this.myCurrentOffset;
            type = this.parseType();
            type = type == null && afterQuestOffset == this.myCurrentOffset ? JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared()) : this.addTypeDecoration(type, JSDecoratedTypeImpl.TypeDecoration.NULLABLE);
        } else if (c == '!') {
            ++this.myCurrentOffset;
            type = this.parseType();
            type = this.addTypeDecoration(type, JSDecoratedTypeImpl.TypeDecoration.NOTNULL);
        } else if (c == '*') {
            ++this.myCurrentOffset;
            type = JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared());
        } else {
            int identifierStartOffset = this.myCurrentOffset;
            JSContext jsContext = JSContext.INSTANCE;
            if (c == 't' && this.myTypeString.startsWith("typeof ", this.myCurrentOffset)) {
                this.myCurrentOffset += "typeof".length();
                this.advanceSpaces();
                if (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isJavaIdentifierPart((char)this.myTypeString.charAt(this.myCurrentOffset))) {
                    jsContext = JSContext.STATIC;
                    identifierStartOffset = this.myCurrentOffset;
                } else {
                    this.myCurrentOffset = identifierStartOffset;
                }
            }
            int identifierEndOffset = identifierStartOffset;
            while (this.myCurrentOffset < this.myTypeString.length() && (c = this.myTypeString.charAt(this.myCurrentOffset)) != '\u0000' && (StringUtil.isJavaIdentifierPart((char)c) || c == '.' || c == '#' || c == '~' || isModule && c == '/' || c == '^')) {
                if (c == 'm' && this.myTypeString.startsWith(MODULE_PREFIX, this.myCurrentOffset)) {
                    this.myCurrentOffset += MODULE_PREFIX.length();
                    isModule = true;
                    continue;
                }
                if (c == 'e' && this.myTypeString.startsWith(EVENT_PREFIX, this.myCurrentOffset)) {
                    this.myCurrentOffset += EVENT_PREFIX.length();
                    continue;
                }
                if (c == 'e' && this.myTypeString.startsWith("external:", this.myCurrentOffset)) {
                    this.myCurrentOffset += "external:".length();
                    continue;
                }
                ++this.myCurrentOffset;
                if (c != '.' && c != '#' && c != '~') {
                    identifierEndOffset = this.myCurrentOffset;
                }
                if (c != '^' || this.myCurrentOffset >= this.myTypeString.length() || this.myTypeString.charAt(this.myCurrentOffset) != 'q') continue;
                ++this.myCurrentOffset;
                while (true) {
                    if (this.myCurrentOffset + 1 >= this.myTypeString.length()) {
                        return null;
                    }
                    if (this.myTypeString.charAt(this.myCurrentOffset) == '^' && this.myTypeString.charAt(this.myCurrentOffset + 1) == 'q') break;
                    ++this.myCurrentOffset;
                }
                this.myCurrentOffset += 2;
            }
            if (identifierEndOffset > identifierStartOffset) {
                String name = this.myTypeString.substring(identifierStartOffset, identifierEndOffset);
                if (c == '.') {
                    jsContext = JSContext.STATIC;
                }
                JSType jSType = type = this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS && "any".equals(name) ? JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isExplicitlyDeclared()) : JSNamedType.createType(name, this.mySource, jsContext);
                if (this.myVisitor != null) {
                    this.myVisitor.visitSingleType(identifierStartOffset, name);
                }
            } else {
                return null;
            }
        }
        return type;
    }

    private char getSymbol() {
        return this.myTypeString.charAt(this.myCurrentOffset);
    }

    private boolean hasSymbol() {
        return this.myCurrentOffset < this.myTypeString.length();
    }

    private void advanceSpaces() {
        while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isWhiteSpace((char)this.myTypeString.charAt(this.myCurrentOffset))) {
            ++this.myCurrentOffset;
        }
    }
}

