/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNumberType
extends JSPrimitiveType {
    public JSNumberType(boolean primitive, JSTypeSource source, JSTypeContext staticOrInstance) {
        super(primitive, source, staticOrInstance);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = this.isPrimitive() && !this.isEcma() && format != JSType.TypeTextFormat.RESOLVED ? "number" : "Number";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNumberType", "getTypeText"));
        }
        return string;
    }

    @Override
    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeImpl elementImpl;
        if (elementType instanceof JSTypeImpl && (elementImpl = (JSTypeImpl)elementType).isEnum()) {
            return true;
        }
        return elementType instanceof JSIntType || elementType instanceof JSUintType || elementType instanceof JSNumberType || super.isDirectlyAssignableType(elementType, processingContext);
    }
}

