/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public abstract class JSPrimitiveType
extends JSSpecialNamedTypeImpl {
    private final boolean primitive;

    public JSPrimitiveType(boolean primitive, @Nullable JSTypeSource source, JSTypeContext staticOrInstance) {
        super(source, staticOrInstance);
        this.primitive = primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public boolean isEquivalentTo(JSType jsType, ProcessingContext processingContext) {
        return jsType != null && jsType.getClass() == this.getClass() && (((JSPrimitiveType)jsType).isPrimitive() == this.isPrimitive() || this.isTypeScript()) || JSTypeCastUtil.isEquivalentCommon(this, jsType, processingContext);
    }

    @Override
    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        return !this.isPrimitive() && elementType instanceof JSNullType || super.isDirectlyAssignableType(elementType, processingContext);
    }
}

