/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSUndefinedType
extends JSSimpleTypeBaseImpl {
    public JSUndefinedType(JSTypeSource source) {
        super(source);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if ("undefined" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSUndefinedType", "getTypeText"));
        }
        return "undefined";
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (this.isJavaScript() && elementType instanceof JSSpecialNamedTypeImpl) {
            return false;
        }
        if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return true;
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return type instanceof JSUndefinedType || JSTypeCastUtil.isEquivalentCommon(this, type, processingContext);
    }

    @NotNull
    public JSUndefinedType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/primitives/JSUndefinedType", "copyWithNewSource"));
        }
        JSUndefinedType jSUndefinedType = new JSUndefinedType(source);
        if (jSUndefinedType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSUndefinedType", "copyWithNewSource"));
        }
        return jSUndefinedType;
    }
}

