/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubBasedPsiTreeUtil {
    private static final TokenSet DECLARATIONS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.VAR_STATEMENT, JSStubElementTypes.FUNCTION_DECLARATION, JSStubElementTypes.CLASS, JSStubElementTypes.TYPESCRIPT_CLASS, JSStubElementTypes.TYPESCRIPT_MODULE, ES6ElementTypes.CLASS, JSStubElementTypes.DEFINITION_EXPRESSION});
    private static final TokenSet FUNCTIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS});
    private static final TokenSet RESOLVE_STOP_AT_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{FUNCTIONS_TOKEN_SET, TokenSet.andNot((TokenSet)JSElementTypes.EXPRESSIONS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.ASSIGNMENT_EXPRESSION}))});
    private static final TokenSet RETURN_STATEMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.RETURN_STATEMENT});

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocally"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocally"));
        }
        if (name.contains(".")) {
            return null;
        }
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)context, JSExecutionScope.class, (boolean)false);
        if (scope instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)scope).getStub() == null) {
            JSTreeUtil.JSScopeDeclarationsAndAssignments definitions = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, scope.getNode());
            if (context.getNode() == null) {
                context = context.getParent();
            }
            ASTNode node = context.getNode();
            return definitions != null && node != null ? definitions.findNearestDefinition(node).getPsi() : null;
        }
        while (scope != null) {
            ArrayList declarations = new ArrayList();
            Ref declarationsBeforeContextRef = Ref.create((Object)0);
            JSStubBasedPsiTreeUtil.addDescendantsRecursively((PsiElement)scope, DECLARATIONS_TOKEN_SET, RESOLVE_STOP_AT_TOKEN_SET, context, (Ref<Integer>)declarationsBeforeContextRef, declarations);
            int declarationsBeforeContext = (Integer)declarationsBeforeContextRef.get();
            for (int i = 0; i < declarations.size(); ++i) {
                JSDefinitionExpression definitionExpression;
                PsiElement declaration = (PsiElement)declarations.get(i < declarationsBeforeContext ? declarationsBeforeContext - i - 1 : i);
                if (declaration instanceof JSVarStatement) {
                    for (JSVariable variable : ((JSVarStatement)declaration).getVariables()) {
                        if (!name.equals(variable.getName())) continue;
                        return variable;
                    }
                    continue;
                }
                if (!(declaration instanceof JSFunction || declaration instanceof JSClass || declaration instanceof TypeScriptModule ? name.equals(((JSNamedElement)declaration).getName()) : declaration instanceof JSDefinitionExpression && (definitionExpression = (JSDefinitionExpression)declaration).getNamespace() == null && name.equals(definitionExpression.getName()))) continue;
                return declaration;
            }
            if (!(scope instanceof JSFunction) && !(scope instanceof TypeScriptModule)) break;
            context = scope;
            scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class);
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull IStubElementType<?, T> elementType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, TokenSet.create((IElementType[])new IElementType[]{elementType}));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, elements, TokenSet.EMPTY);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements, @NotNull TokenSet stopAt) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        ArrayList result = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(element, elements, stopAt, null, null, result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        return arrayList;
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull PsiElement container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable PsiElement context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        StubElement stub;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (targetElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (!(container instanceof PsiFileImpl || container instanceof StubBasedPsiElementBase || container instanceof LazyParseablePsiElement)) {
            return;
        }
        Object object = container instanceof PsiFileImpl ? ((PsiFileImpl)container).getStub() : (stub = container instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)container).getStub() : null);
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement child : stubs) {
                IStubElementType type;
                PsiElement psi = child.getPsi();
                if (psi == context && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set((Object)out.size());
                }
                if (targetElements.contains((IElementType)(type = child.getStubType()))) {
                    out.add(psi);
                }
                if (stopAt.contains((IElementType)type)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(psi, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
            }
        } else {
            for (PsiElement child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
                IElementType type;
                if (child == context && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set((Object)out.size());
                }
                if (targetElements.contains(type = child.getNode().getElementType())) {
                    out.add(child);
                }
                if (stopAt.contains(type)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(child, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
            }
        }
    }

    @Nullable
    public static JSDocComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDocComment"));
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element);
            if (docComment instanceof JSDocComment) {
                candidate = (JSDocComment)docComment;
            }
        } else if (element instanceof JSDefinitionExpression) {
            PsiElement prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(element = element.getParent());
            if (prevSibling instanceof JSDocComment) {
                candidate = (JSDocComment)prevSibling;
            }
        } else {
            candidate = (JSDocComment)((StubBasedPsiElementBase)element).getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getPrevSibling"));
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getPrevSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getPrevSibling();
    }

    @NotNull
    public static <T extends JSExpression> Collection<T> findReturnedExpressions(@NotNull JSFunction function, final Class<? extends T> ... classes) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findReturnedExpressions"));
        }
        SmartList result = new SmartList();
        if (function.getStub() != null) {
            Collection<JSReturnStatement> returnStatements = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)function, RETURN_STATEMENT_TOKEN_SET, FUNCTIONS_TOKEN_SET);
            for (JSReturnStatement statement : returnStatements) {
                JSReturnStatementStub returnStub = (JSReturnStatementStub)statement.getStub();
                if (returnStub == null) continue;
                List childrenStubs = returnStub.getChildrenStubs();
                for (StubElement childrenStub : childrenStubs) {
                    PsiElement psi = childrenStub.getPsi();
                    if (!PsiTreeUtil.instanceOf((Object)psi, (Class[])classes)) continue;
                    result.add((JSExpression)psi);
                }
            }
        } else {
            function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor((List)result){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                }

                public void visitJSReturnStatement(JSReturnStatement node) {
                    JSExpression expression = node.getExpression();
                    if (PsiTreeUtil.instanceOf((Object)expression, (Class[])classes)) {
                        this.val$result.add(expression);
                    }
                }
            });
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findReturnedExpressions"));
        }
        return smartList;
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase element, @NotNull TokenSet filter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getStubOrPsiChild"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getStubOrPsiChild"));
        }
        StubElement stub = element.getStub();
        if (stub != null) {
            List childrenStubs = stub.getChildrenStubs();
            for (StubElement childStub : childrenStubs) {
                if (!filter.contains((IElementType)childStub.getStubType())) continue;
                return childStub.getPsi();
            }
            return null;
        }
        ASTNode child = element.getNode().findChildByType(filter);
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression) {
        JSDefinitionExpression definitionExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getInitializedElement"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSProperty || parent instanceof JSVariable) {
            return (JSQualifiedNamedElement)parent;
        }
        if (parent instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)parent).getDefinitionExpression()) != expression) {
            return definitionExpression;
        }
        return null;
    }

    public static PsiElement[] getChildrenByType(JSElement element, TokenSet type) {
        if (element instanceof JSFileImpl || element instanceof JSStubElementImpl) {
            StubElement stub;
            StubElement stubElement = stub = element instanceof JSFileImpl ? ((JSFileImpl)element).getStub() : ((JSStubElementImpl)element).getStub();
            if (stub != null) {
                return stub.getChildrenByType(type, JSElement.ARRAY_FACTORY);
            }
        }
        ASTNode[] children = element.getNode().getChildren(type);
        PsiElement[] result = new PsiElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result[i] = children[i].getPsi();
        }
        return result;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        String initializerReference = null;
        PsiElement referencedElement = null;
        if (resolveResult instanceof JSVariable) {
            String initializerText;
            JSExpression initializer = ((JSVariable)resolveResult).getInitializerOrStub();
            if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                Collection<JSFile> files;
                String referencePath;
                JSLiteralExpression argument = JSStubBasedPsiTreeUtil.findRequireCallArgument((JSCallExpression)initializer);
                String string = referencePath = argument != null ? argument.getSignificantValue() : null;
                if (referencePath != null && (files = CommonJSUtil.resolveReferencedElements((PsiElement)argument, StringUtil.unquoteString((String)referencePath))).size() == 1) {
                    JSFile file = files.iterator().next();
                    referencedElement = JSResolveUtil.getExportedElement(file);
                }
            }
            if ((initializerText = ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText()) != null && JSSymbolUtil.isValidPropertyName(initializerText)) {
                initializerReference = initializerText;
            }
        } else if (resolveResult instanceof JSProperty) {
            initializerReference = ((JSProperty)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof JSDefinitionExpression) {
            initializerReference = ((JSDefinitionExpression)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            Collection referencedElements = ((TypeScriptImportStatement)resolveResult).findReferencedElements();
            if (referencedElements.size() == 1) {
                referencedElement = (PsiElement)referencedElements.iterator().next();
            }
        } else if (resolveResult instanceof ES6ImportExportSpecifierAlias) {
            referencedElement = ((ES6ImportExportSpecifierAlias)resolveResult).findAliasedElement();
        } else if (resolveResult instanceof ES6ImportedBinding) {
            Collection elements = ((ES6ImportedBinding)resolveResult).findReferencedElements();
            referencedElement = (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
        } else if (resolveResult instanceof ES6ExportDefaultAssignment) {
            initializerReference = ((ES6ExportDefaultAssignment)resolveResult).getInitializerReference();
            if (initializerReference == null) {
                referencedElement = ((ES6ExportDefaultAssignment)resolveResult).getStubSafeExpression();
            }
        } else if (resolveResult instanceof JSExportAssignment) {
            referencedElement = ((JSExportAssignment)resolveResult).getExpression();
        }
        if (initializerReference != null) {
            referencedElement = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult);
        }
        if (referencedElement != null) {
            if (visited == null) {
                visited = new THashSet();
            }
            if (visited.add((PsiElement)resolveResult)) {
                referencedElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(referencedElement, (Set<PsiElement>)visited);
            }
            PsiElement psiElement = referencedElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = resolveResult;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        return psiElement;
    }

    @Nullable
    public static JSLiteralExpression findRequireCallArgument(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findRequireCallArgument"));
        }
        Collection<JSLiteralExpression> expressions = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)callExpression, JSStubElementTypes.LITERAL_EXPRESSION);
        return expressions.size() == 1 ? expressions.iterator().next() : null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull JSDocComment psiComment) {
        JSVariable[] variables;
        if (psiComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiComment", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findAssociatedElement"));
        }
        PsiElement parent = psiComment.getParent();
        PsiElement next = null;
        if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement && (variables = ((JSVarStatement)parent).getVariables()).length > 0) {
            next = variables[0];
        }
        return next;
    }
}

