/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.util.JSClassMemberReferencesVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.refactoring.classMembers.MemberInfoBase;

public class JSClassMembersRefactoringSupport
implements ClassMembersRefactoringSupport {
    public DependentMembersCollectorBase createDependentMembersCollector(Object clazz, Object superClass) {
        return new JSDependentMembersCollector((JSClass)clazz, (JSClass)superClass);
    }

    public boolean isProperMember(MemberInfoBase member) {
        return true;
    }

    private static class JSDependentMembersCollector
    extends DependentMembersCollectorBase<JSElement, JSClass> {
        public JSDependentMembersCollector(JSClass clazz, JSClass superClass) {
            super((Object)clazz, (Object)superClass);
        }

        public void collect(JSElement member) {
            JSFunction setter;
            JSClassMemberReferencesVisitor visitor = new JSClassMemberReferencesVisitor((JSClass)this.getClazz()){

                @Override
                protected void visitMemberReference(JSAttributeListOwner member, JSReferenceExpression reference) {
                    if (!JSDependentMembersCollector.this.existsInSuperClass((JSElement)member)) {
                        JSDependentMembersCollector.this.myCollection.add(member);
                    }
                }
            };
            member.accept((PsiElementVisitor)visitor);
            if (member instanceof JSFunction && ((JSFunction)member).isGetProperty() && (setter = ((JSClass)this.getClazz()).findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER)) != null) {
                setter.accept((PsiElementVisitor)visitor);
            }
        }

        private boolean existsInSuperClass(JSElement member) {
            if (this.getSuperClass() == null) {
                return false;
            }
            if (!(member instanceof JSFunction)) {
                return false;
            }
            return ((JSClass)this.getSuperClass()).findFunctionByName(member.getName()) != null;
        }
    }
}

