/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import java.util.Collections;
import java.util.Set;

public class JSSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result) {
        ASTNode nameIdentifier;
        if (element instanceof JSVariable && (nameIdentifier = ((JSVariable)element).findNameIdentifier()) != null) {
            PsiElement nameElement = nameIdentifier.getPsi();
            if (nameElement instanceof JSExpression) {
                boolean transformToFieldName = JSResolveUtil.findParent(element) instanceof JSClass;
                Project project = element.getProject();
                for (String s : BasicIntroducedEntityInfoProvider.getNameCandidates((JSExpression)nameElement, nameSuggestionContext, Collections.<String>emptyList(), null)) {
                    if (transformToFieldName) {
                        s = JSRefactoringUtil.transformAccessorNameToPropertyName(s, project);
                    }
                    result.add(s);
                }
            } else {
                JSType type = ((JSVariable)element).getType();
                if (type != null) {
                    PsiElement typeElement = ((JSVariable)element).getTypeElement();
                    if (typeElement instanceof JSReferenceExpression) {
                        result.addAll(BasicIntroducedEntityInfoProvider.getNameCandidates((JSExpression)typeElement, nameSuggestionContext, result, null));
                    } else {
                        new BasicIntroducedEntityInfoProvider.NameVariantsEvaluator(false, result, nameSuggestionContext, Collections.<String>emptyList()).process(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                    }
                }
            }
        }
        return null;
    }
}

