/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSCallerChooser;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModel;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModelItem;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureDialog
extends ChangeSignatureDialogBase<JSParameterInfo, JSFunction, String, JSMethodDescriptor, JSParameterTableModelItem, JSParameterTableModel> {
    private JLabel myWarningLabel;

    public JSChangeSignatureDialog(JSFunction method, boolean forceConstructor, PsiElement defaultValueContext) {
        this(JSMethodDescriptorFactory.create(method, forceConstructor), defaultValueContext);
        this.setWarningText(method.isReferencesArguments() ? JSBundle.message((String)"change.signature.method.references.arguments", (Object[])new Object[0]) : null);
    }

    public JSChangeSignatureDialog(JSMethodDescriptor descriptor, PsiElement defaultValueContext) {
        super(defaultValueContext.getProject(), (MethodDescriptor)descriptor, false, defaultValueContext);
        this.setTitle(JSBundle.message((String)"change.signature.dialog.title", (Object[])new Object[]{JSFormatUtil.formatMethod(descriptor.getMethod(), 4353, 0, 0, null)}));
    }

    protected LanguageFileType getFileType() {
        return JavaScriptSupportLoader.JAVASCRIPT;
    }

    protected JSParameterTableModel createParametersInfoModel(JSMethodDescriptor method) {
        return new JSParameterTableModel((PsiElement)method.getMethod().getParameterList(), this.myDefaultValueContext, this.getDefaultValueColumnTitle(), this.isShowTypeColumn(), this.isShowInitializerColumn(), this.isShowOptionalColumn());
    }

    private boolean isShowOptionalColumn() {
        return ((JSMethodDescriptor)this.myMethod).canHaveOptional();
    }

    private boolean isShowTypeColumn() {
        return ((JSMethodDescriptor)this.myMethod).canHaveType();
    }

    private boolean isShowInitializerColumn() {
        return ((JSMethodDescriptor)this.myMethod).canHaveInitializers();
    }

    @Nullable
    protected String getDefaultValueColumnTitle() {
        PsiElement parent;
        if (((JSMethodDescriptor)this.myMethod).getMethod() instanceof JSFunctionExpression && !((parent = ((JSMethodDescriptor)this.myMethod).getMethod().getParent()) instanceof JSVariable) && !(parent instanceof JSAssignmentExpression) && !(parent instanceof JSProperty)) {
            return null;
        }
        return ((JSMethodDescriptor)this.myMethod).isActionScript() || ((JSMethodDescriptor)this.myMethod).isEcmaScript6() ? RefactoringBundle.message((String)"column.name.default.value") : JSBundle.message((String)"change.signature.value.column.title", (Object[])new Object[0]);
    }

    protected JSChangeSignatureProcessor createRefactoringProcessor() {
        List parameters = this.getParameters();
        return new JSChangeSignatureProcessor(((JSMethodDescriptor)this.myMethod).getMethod(), JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility())), this.getMethodName(), this.myReturnTypeCodeFragment != null ? this.myReturnTypeCodeFragment.getText() : "", parameters.toArray(new JSParameterInfo[parameters.size()]), this.myMethodsToPropagateParameters != null ? this.myMethodsToPropagateParameters : Collections.emptySet());
    }

    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return JSChangeSignatureDialog.createReturnTypeCodeFragment(((JSMethodDescriptor)this.myMethod).getReturnType(), (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), ((JSMethodDescriptor)this.myMethod).getFileLanguage());
    }

    public static JSExpressionCodeFragment createReturnTypeCodeFragment(String type, PsiElement context, @Nullable JSLanguageDialect lang) {
        return JSElementFactory.createExpressionCodeFragment(context.getProject(), type, context, lang, ProjectScope.getAllScope((Project)context.getProject()), JSElementFactory.TopLevelCompletion.YES, JavaScriptParserBase.ForceContext.Type);
    }

    protected EditorTextField createReturnTypeTextField(Document document) {
        return new JSEditorTextField(this.myProject, document);
    }

    protected CallerChooserBase<JSFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
        return new JSCallerChooser(((JSMethodDescriptor)this.myMethod).getMethod(), this.myProject, title, treeToReuse, callback);
    }

    protected String validateAndCommitData() {
        String returnTypeText;
        String name = this.getMethodName();
        if (!(((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(((JSMethodDescriptor)this.myMethod).getMethod().getContainingFile().getLanguage())).isIdentifier(name, this.myProject) || StringUtil.isEmpty((String)name) && ((JSMethodDescriptor)this.myMethod).getMethod() instanceof JSFunctionExpression)) {
            return JSBundle.message((String)"invalid.identifier.value.0", (Object[])new Object[]{name});
        }
        if (((JSMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && (returnTypeText = this.myReturnTypeCodeFragment.getText()).length() > 0 && JSRefactoringUtil.createTypeElement(this.myProject, returnTypeText, ((JSMethodDescriptor)this.myMethod).getFileLanguage()) == null) {
            return JSBundle.message((String)"invalid.return.type.expression", (Object[])new Object[]{returnTypeText});
        }
        List items = ((JSParameterTableModel)this.myParametersTableModel).getItems();
        if (items.size() != 1 && ((JSMethodDescriptor)this.myMethod).getMethod().isSetProperty()) {
            return JSBundle.message((String)"javascript.validation.message.set.method.should.have.one.parameter", (Object[])new Object[0]);
        }
        if (((JSMethodDescriptor)this.myMethod).getMethod().isGetProperty() && "void".equals(this.myReturnTypeField.getText())) {
            return JSBundle.message((String)"javascript.validation.message.get.method.should.be.valid.type", (Object[])new Object[]{"void"});
        }
        boolean initializerFound = false;
        boolean initializerUsed = false;
        HashSet<String> paramsNames = new HashSet<String>();
        for (ParameterTableModelItemBase item : items) {
            if (paramsNames.add(((JSParameterInfo)item.parameter).getName())) continue;
            return JSBundle.message((String)"duplicate.parameter.name", (Object[])new Object[]{((JSParameterInfo)item.parameter).getName()});
        }
        for (int i = 0; i < items.size(); ++i) {
            String typeText;
            ParameterTableModelItemBase item;
            item = (JSParameterTableModelItem)((Object)items.get(i));
            if (!((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(((JSMethodDescriptor)this.myMethod).getMethod().getContainingFile().getLanguage())).isIdentifier(((JSParameterInfo)item.parameter).getName(), this.myProject)) {
                return JSBundle.message((String)"invalid.identifier.value.0", (Object[])new Object[]{((JSParameterInfo)item.parameter).getName()});
            }
            if (item.isEllipsisType() && i != items.size() - 1) {
                return JSBundle.message((String)"changeSignature.vararg.not.last", (Object[])new Object[0]);
            }
            String initializer = item.initializerCodeFragment.getText();
            if (((JSParameterInfo)item.parameter).getOldIndex() < 0) {
                String defaultValueText = item.defaultValueCodeFragment.getText().trim();
                if (!item.isEllipsisType()) {
                    if (StringUtil.isEmpty((String)defaultValueText)) {
                        if (this.getDefaultValueColumnTitle() != null && StringUtil.isEmpty((String)initializer)) {
                            return JSBundle.message((String)"changeSignature.no.default.value", (Object[])new Object[]{((JSParameterInfo)item.parameter).getName()});
                        }
                        initializerUsed = true;
                    } else {
                        if (initializerUsed) {
                            return JSBundle.message((String)"changeSignature.default.value.not.allowed", (Object[])new Object[]{((JSParameterInfo)item.parameter).getName()});
                        }
                        try {
                            JSChangeUtil.createJSTreeFromText(this.myProject, defaultValueText, JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                        }
                        catch (IncorrectOperationException e) {
                            return e.getMessage();
                        }
                    }
                }
                ((JSParameterInfo)item.parameter).setDefaultValue(defaultValueText);
            }
            if (StringUtil.isNotEmpty((String)initializer)) {
                initializerFound = true;
            } else if (initializerFound && !item.isEllipsisType()) {
                return JSBundle.message((String)"required.parameters.are.not.permitted.after.optional.parameters", (Object[])new Object[0]);
            }
            if (!item.isEllipsisType() && (typeText = item.typeCodeFragment.getText()).length() > 0 && JSRefactoringUtil.createTypeElement(this.myProject, typeText, ((JSMethodDescriptor)this.myMethod).getFileLanguage()) == null) {
                return JSBundle.message((String)"invalid.parameter.type.expression", (Object[])new Object[]{typeText});
            }
            ((JSParameterInfo)item.parameter).setInitializer(initializer);
        }
        if (((JSMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            String returnTypeText2 = this.myReturnTypeCodeFragment.getText();
            if (((JSMethodDescriptor)this.myMethod).resolveTypes() && !JSRefactoringUtil.isResolvableType(returnTypeText2, (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), true, false) && Messages.showYesNoDialog((Project)this.myProject, (String)JSBundle.message((String)"return.type.is.not.resolved", (Object[])new Object[]{returnTypeText2}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon()) != 0) {
                return "";
            }
        }
        if (this.isShowTypeColumn()) {
            for (ParameterTableModelItemBase item : items) {
                String typeText = item.typeCodeFragment.getText();
                if (StringUtil.isEmpty((String)typeText) ? Messages.showYesNoDialog((Project)this.myProject, (String)JSBundle.message((String)"parameter.type.is.not.specified", (Object[])new Object[]{((JSParameterInfo)item.parameter).getName()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon()) != 0 : ((JSMethodDescriptor)this.myMethod).resolveTypes() && !JSRefactoringUtil.isResolvableType(typeText, (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), false, true) && Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.parameter.type", (Object[])new Object[]{typeText, ((JSParameterInfo)item.parameter).getName()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon()) != 0) {
                    return "";
                }
                ((JSParameterInfo)item.parameter).setTypeText(((JSParameterTableModelItem)item).typeCodeFragment.getText());
            }
        }
        return null;
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        List<JSAttributeList.AccessType> visibility = ((JSMethodDescriptor)this.myMethod).getPossibleVisibility();
        Object[] names = new String[visibility.size()];
        String[] titles = new String[visibility.size()];
        for (int i = 0; i < visibility.size(); ++i) {
            JSAttributeList.AccessType accessType = visibility.get(i);
            names[i] = accessType.name();
            titles[i] = JSVisibilityUtil.getVisibilityKeyword(accessType);
        }
        return new ComboBoxVisibilityPanel(names, titles);
    }

    protected String calculateSignature() {
        IElementType arrow;
        List items = ((JSParameterTableModel)this.myParametersTableModel).getItems();
        for (JSParameterTableModelItem item : items) {
            ((JSParameterInfo)item.parameter).setTypeText(item.typeCodeFragment.getText());
            ((JSParameterInfo)item.parameter).setInitializer(item.initializerCodeFragment.getText());
        }
        if (((JSMethodDescriptor)this.myMethod).isEcmaScript6() && (arrow = JSPsiImplUtils.isArrowFunction(((JSMethodDescriptor)this.myMethod).getMethod())) != null) {
            return this.calculateArrowFunctionSignature(arrow);
        }
        String modifiers = this.calculateModifiers();
        StringBuilder buffer = new StringBuilder();
        buffer.append(modifiers);
        if (!(modifiers.length() <= 0 || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\n') || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\r') || StringUtil.endsWithChar((CharSequence)modifiers, (char)' '))) {
            buffer.append(" ");
        }
        buffer.append(((JSMethodDescriptor)this.myMethod).getFunctionNameWithKeyword(this.getMethodName()));
        JSChangeSignatureDialog.buildParameterListText(this.getParameters(), buffer, true, ((JSMethodDescriptor)this.myMethod).dialect());
        if (this.myReturnTypeCodeFragment != null && this.myReturnTypeCodeFragment.getText().length() > 0) {
            buffer.append(": ");
            buffer.append(this.myReturnTypeCodeFragment.getText());
        }
        return buffer.toString();
    }

    private String calculateArrowFunctionSignature(IElementType arrow) {
        String methodName;
        PsiElement grandParent;
        StringBuilder buffer = new StringBuilder();
        PsiElement parent = ((JSMethodDescriptor)this.myMethod).getMethod().getParent();
        if (parent instanceof JSVariable && (grandParent = parent.getParent()) instanceof JSVarStatement) {
            buffer.append(grandParent.getFirstChild().getText());
        }
        if (StringUtil.isNotEmpty((String)(methodName = this.getMethodName()))) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(methodName);
        }
        buffer.append(" = ");
        JSChangeSignatureDialog.buildParameterListText(this.getParameters(), buffer, true, ((JSMethodDescriptor)this.myMethod).dialect());
        buffer.append(arrow == JSTokenTypes.EQGT ? " =" : " -").append("> ");
        return buffer.toString();
    }

    protected String calculateModifiers() {
        JSAttributeList modifierList = ((JSMethodDescriptor)this.myMethod).getMethod().getAttributeList();
        String modifiers = modifierList != null ? modifierList.getText() : "";
        String oldModifier = modifierList != null ? JSVisibilityUtil.getVisibilityKeyword(modifierList.getAccessType()) : "";
        JSAttributeList.AccessType newAccessType = JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility()));
        String newModifier = newAccessType == JSAttributeList.AccessType.PACKAGE_LOCAL && ((JSMethodDescriptor)this.myMethod).isConstructor() || !((JSMethodDescriptor)this.myMethod).canChangeVisibility() ? "" : JSVisibilityUtil.getVisibilityKeyword(newAccessType);
        if (!newModifier.equals(oldModifier)) {
            int index = modifiers.indexOf(oldModifier);
            if (index >= 0) {
                StringBuilder buf = new StringBuilder(modifiers);
                buf.replace(index, index + oldModifier.length() + (newModifier.isEmpty() ? 1 : 0), newModifier);
                modifiers = buf.toString();
            } else {
                if (!newModifier.isEmpty()) {
                    newModifier = newModifier + " ";
                }
                modifiers = newModifier + modifiers;
            }
        }
        return modifiers;
    }

    public static void buildParameterListText(@NotNull List<JSParameterInfo> items, @NotNull StringBuilder buffer, boolean addTypes, @Nullable DialectOptionHolder holder) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureDialog", "buildParameterListText"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureDialog", "buildParameterListText"));
        }
        buffer.append("(");
        for (int i = 0; i < items.size(); ++i) {
            String initializer;
            String type;
            JSParameterInfo item = items.get(i);
            if (i > 0) {
                buffer.append(",");
            }
            if (JSRefactoringUtil.isEllipsisType(type = item.getTypeText())) {
                buffer.append(type);
                buffer.append(item.getName());
                continue;
            }
            buffer.append(item.getName());
            if (holder != null && holder.isTypeScript && item.isOptional() && StringUtil.isEmpty((String)item.getInitializer())) {
                buffer.append("?");
            }
            if (addTypes && StringUtil.isNotEmpty((String)type)) {
                buffer.append(": ");
                buffer.append(type);
            }
            if (!StringUtil.isNotEmpty((String)(initializer = item.getInitializer()))) continue;
            buffer.append("=").append(initializer);
        }
        buffer.append(")");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JComponent centerPanel = super.createCenterPanel();
        assert (centerPanel != null);
        panel.add((Component)centerPanel, "Center");
        this.myWarningLabel = new JLabel();
        this.myWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myWarningLabel.setVisible(false);
        panel.add((Component)this.myWarningLabel, "South");
        this.myPropagateParamChangesButton.setVisible(true);
        return panel;
    }

    private void setWarningText(String text) {
        if (text != null) {
            this.myWarningLabel.setText(text);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    protected String getHelpId() {
        return ((JSMethodDescriptor)this.myMethod).isActionScript() ? "Change_Signature_Dialog_for_ActionScript" : "reference.refactoring.change.signature.javascript";
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        return new MethodSignatureComponent(this.calculateSignature(), this.getProject(), (FileType)JavaScriptSupportLoader.JAVASCRIPT){

            protected String getFileName() {
                JSLanguageDialect language = ((JSMethodDescriptor)JSChangeSignatureDialog.this.myMethod).getFileLanguage();
                String extension = language == null ? ".js" : language.getFileExtension();
                return "dummy." + extension;
            }
        };
    }
}

