/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModelItem;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class JSParameterTableModel
extends ParameterTableModelBase<JSParameterInfo, JSParameterTableModelItem> {
    private final Project myProject;

    public JSParameterTableModel(PsiElement typeContext, PsiElement defaultValueContext, @Nullable String defaultValueColumnTitle, boolean showTypeColumn, boolean showInitializerColumn, boolean showOptionalColumn) {
        super(typeContext, defaultValueContext, JSParameterTableModel.getColumns(typeContext.getProject(), defaultValueColumnTitle, showTypeColumn, showInitializerColumn, showOptionalColumn));
        this.myProject = typeContext.getProject();
    }

    private static ColumnInfo[] getColumns(Project project, @Nullable String defaultValueColumnTitle, boolean showTypeColumn, boolean showInitializerColumn, boolean showOptionalColumn) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (showTypeColumn) {
            result.add((Object)new JSTypeColumn(project));
        }
        result.add((Object)new JSNameColumn(project));
        if (showInitializerColumn) {
            result.add((Object)new InitializerColumn(project));
        }
        if (defaultValueColumnTitle != null) {
            result.add(new ParameterTableModelBase.DefaultValueColumn(project, (FileType)JavaScriptSupportLoader.JAVASCRIPT, defaultValueColumnTitle));
        }
        if (showOptionalColumn) {
            result.add((Object)new OptionalFlagColumn());
        }
        return result.toArray(new ColumnInfo[result.size()]);
    }

    protected JSParameterTableModelItem createRowItem(@Nullable JSParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new JSParameterInfo("", "", "", "", -1);
        }
        JSExpressionCodeFragment paramTypeCodeFragment = JSParameterTableModel.createParameterTypeCellFragment(parameterInfo.getTypeText(), this.myProject);
        JSExpressionCodeFragment defaultValueCodeFragment = JSParameterTableModel.createDefaultValueCellFragment(parameterInfo.getDefaultValue(), this.myDefaultValueContext);
        JSExpressionCodeFragment initializerCodeFragment = JSParameterTableModel.createInitializerCellFragment(StringUtil.notNullize((String)parameterInfo.getInitializer()), this.myDefaultValueContext);
        return new JSParameterTableModelItem(parameterInfo, paramTypeCodeFragment, defaultValueCodeFragment, initializerCodeFragment);
    }

    public static JSExpressionCodeFragment createParameterTypeCellFragment(String text, Project project) {
        return JSElementFactory.createExpressionCodeFragment(project, StringUtil.notNullize((String)text), null, JavaScriptSupportLoader.ECMA_SCRIPT_L4, ProjectScope.getAllScope((Project)project), JSElementFactory.TopLevelCompletion.YES, JavaScriptParserBase.ForceContext.Parameter);
    }

    public static JSExpressionCodeFragment createDefaultValueCellFragment(String text, PsiElement context) {
        return JSElementFactory.createExpressionCodeFragment(context.getProject(), StringUtil.notNullize((String)text), context, JavaScriptSupportLoader.ECMA_SCRIPT_L4, ProjectScope.getProjectScope((Project)context.getProject()), JSElementFactory.TopLevelCompletion.LITERAL_VALUES, null);
    }

    public static JSExpressionCodeFragment createInitializerCellFragment(String text, PsiElement context) {
        return JSElementFactory.createExpressionCodeFragment(context.getProject(), text, context, JavaScriptSupportLoader.ECMA_SCRIPT_L4, ProjectScope.getProjectScope((Project)context.getProject()), JSElementFactory.TopLevelCompletion.LITERAL_VALUES, null);
    }

    private static class OptionalFlagColumn
    extends ColumnInfo<ParameterTableModelItemBase<JSParameterInfo>, Boolean> {
        public OptionalFlagColumn() {
            super(JSBundle.message((String)"change.signature.column.name.optional.flag", (Object[])new Object[0]));
        }

        public boolean isCellEditable(ParameterTableModelItemBase<JSParameterInfo> item) {
            return !item.isEllipsisType() && ((JSParameterInfo)item.parameter).getOldIndex() == -1;
        }

        public Boolean valueOf(ParameterTableModelItemBase<JSParameterInfo> item) {
            return ((JSParameterInfo)((JSParameterTableModelItem)item).parameter).isOptional();
        }

        public void setValue(ParameterTableModelItemBase<JSParameterInfo> item, Boolean value) {
            ((JSParameterInfo)((JSParameterTableModelItem)item).parameter).setOptional(value);
        }

        public TableCellRenderer getRenderer(ParameterTableModelItemBase<JSParameterInfo> jsParameterInfoParameterTableModelItemBase) {
            return new BooleanTableCellRenderer();
        }

        public TableCellEditor getEditor(ParameterTableModelItemBase<JSParameterInfo> o) {
            return new BooleanTableCellEditor(false);
        }

        public int getWidth(JTable table) {
            return 55;
        }
    }

    private static class InitializerColumn
    extends ParameterTableModelBase.ColumnInfoBase<JSParameterInfo, JSParameterTableModelItem, PsiCodeFragment> {
        private final Project myProject;

        public InitializerColumn(Project project) {
            super(JSBundle.message((String)"change.signature.column.name.initializer", (Object[])new Object[0]));
            this.myProject = project;
        }

        public boolean isCellEditable(JSParameterTableModelItem item) {
            return !item.isEllipsisType();
        }

        public PsiCodeFragment valueOf(JSParameterTableModelItem item) {
            return item.initializerCodeFragment;
        }

        public TableCellRenderer doCreateRenderer(JSParameterTableModelItem item) {
            return new CodeFragmentTableCellRenderer(this.myProject, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem item) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)JavaScriptSupportLoader.JAVASCRIPT){

                protected EditorTextField createEditorField(Document document) {
                    return new JSEditorTextField(InitializerColumn.this.myProject, document, false, null);
                }
            };
        }
    }

    private static class JSNameColumn
    extends ParameterTableModelBase.NameColumn<JSParameterInfo, JSParameterTableModelItem> {
        private final Project myProject;

        public JSNameColumn(Project project) {
            super(project, JSBundle.message((String)"change.signature.column.name", (Object[])new Object[0]));
            this.myProject = project;
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem o) {
            return new StringTableCellEditor(this.myProject){};
        }
    }

    private static class JSTypeColumn
    extends ParameterTableModelBase.TypeColumn<JSParameterInfo, JSParameterTableModelItem> {
        public JSTypeColumn(Project project) {
            super(project, (FileType)JavaScriptSupportLoader.JAVASCRIPT, JSBundle.message((String)"change.signature.column.type", (Object[])new Object[0]));
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem o) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)JavaScriptSupportLoader.JAVASCRIPT){

                protected EditorTextField createEditorField(Document document) {
                    return new JSEditorTextField(JSTypeColumn.this.myProject, document, false, null);
                }
            };
        }
    }
}

