/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFunctionSignatureGenerator
extends JSFunctionSignatureGenerator {
    @Override
    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info, StringBuilder result) {
        if (info.getScope() != JSFunctionSignatureInfo.Scope.CLASS) {
            super.appendFunctionNameWithModifiers(info, result);
            return;
        }
        JSAttributeList.AccessType type = info.getAccessType();
        if (type != JSAttributeList.AccessType.PUBLIC) {
            result.append(JSVisibilityUtil.accessTypeToKeyword(type, DialectOptionHolder.TS)).append(" ");
        }
        if (info.isStatic()) {
            result.append("static ");
        }
        result.append(info.getFunctionName());
        if (info.getMyTypeParameterList() != null) {
            result.append(info.getMyTypeParameterList());
        }
    }

    @Override
    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        if (parameterWithType.second == "$varArgs$") {
            String string = "... " + (String)parameterWithType.first;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/TypeScriptFunctionSignatureGenerator", "getFunctionParameter"));
            }
            return string;
        }
        String type = (String)parameterWithType.second;
        String string = (String)parameterWithType.first + (!StringUtil.isEmpty((String)type) ? ":" + type : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/TypeScriptFunctionSignatureGenerator", "getFunctionParameter"));
        }
        return string;
    }

    @Override
    protected void appendFunctionEnding(JSFunctionSignatureInfo info, StringBuilder result) {
        if (StringUtil.isNotEmpty((String)info.getReturnType())) {
            result.append(": ");
            result.append(info.getReturnType());
        }
    }
}

