/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceField;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldDialog;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;

public class JSIntroduceFieldHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceFieldSettings, JSIntroduceFieldDialog> {
    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.field.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.field.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.field.error.expression.has.void.type";
    }

    @Override
    protected JSIntroduceFieldDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceFieldDialog(project, occurrences, expression, scope);
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, boolean replaceAllOccurences) {
        return JSIntroduceFieldHandler.findClassAnchor((PsiElement)context.expressionDescriptor.first);
    }

    @Override
    protected JSVariable addStatementBefore(JSElement anchorStatement, JSVarStatement declaration) throws IncorrectOperationException {
        return JSIntroduceFieldHandler.addToClassAnchor(anchorStatement, declaration);
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> baseIntroduceContext, JSElement anchor) {
        String baseDeclText = super.getDeclText(baseIntroduceContext, anchor);
        return JSIntroduceFieldHandler.prependAccessModifier(baseIntroduceContext, baseDeclText);
    }

    @Override
    protected Pair<JSExpression, TextRange> findIntroducedExpression(PsiFile file, int start, int end, Editor editor, DataContext dataContext) {
        if (!BaseJSRefactoringHandler.checkEcma((PsiElement)file, editor, this.getRefactoringName())) {
            return null;
        }
        PsiElement elementAt = file.findElementAt(start);
        if (JSResolveUtil.getClassOfContext(elementAt) == null) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)JSBundle.message((String)"javascript.introduce.field.error.no.enclosing.class", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
            return null;
        }
        if (elementAt != null) {
            PsiElement parent = elementAt.getParent();
            if (parent instanceof JSVariable) {
                ASTNode elementAtNode = elementAt.getNode();
                if (elementAtNode != null && elementAtNode.getElementType() == JSTokenTypes.COLON) {
                    elementAt = elementAt.getPrevSibling();
                }
                if (elementAt instanceof PsiWhiteSpace) {
                    elementAt = elementAt.getPrevSibling();
                }
                if (elementAt instanceof JSReferenceExpression) {
                    parent = elementAt;
                }
            }
            if (JSIntroduceFieldHandler.introduceOverVariableNameRef(parent)) {
                return new Pair((Object)((JSReferenceExpression)parent), null);
            }
        }
        return super.findIntroducedExpression(file, start, end, editor, dataContext);
    }

    @Override
    protected InplaceSettings<JSIntroduceFieldSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, OccurrencesChooser.ReplaceChoice choice) {
        return null;
    }

    @Override
    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        if (JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)expressionDescriptor.first)) {
            return ((JSVariable)((JSExpression)expressionDescriptor.first).getParent()).getInitializer();
        }
        return super.getReplacementExpression(expressionDescriptor);
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, Project project, JSLanguageDialect languageDialect, JSElement anchorStatement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        JSExpression initializer;
        JSIntroduceFieldSettings.InitializationPlace place = ((JSIntroduceFieldSettings)context.settings).getInitializationPlace();
        if (place == JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration) {
            return super.prepareDeclaration(varDeclText, context, project, languageDialect, anchorStatement, editor, null);
        }
        boolean replacedOriginal = false;
        String introducedExpressionText = JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)context.expressionDescriptor.first) ? ((initializer = this.getReplacementExpression(context.expressionDescriptor)) != null ? initializer.getText() : null) : this.getIntroducedExpressionText(context.expressionDescriptor);
        String assignmentText = ((JSIntroduceFieldSettings)context.settings).getVariableName() + (introducedExpressionText != null ? "=" + introducedExpressionText : "") + JSCodeStyleSettings.getSemicolon(anchorStatement.getContainingFile());
        PsiElement psiToInsert = JSChangeUtil.createStatementFromText(project, assignmentText, languageDialect).getPsi();
        if (place == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            PsiElement addedElement;
            Object element = super.findAnchor(context, ((JSIntroduceFieldSettings)context.settings).isReplaceAllOccurrences());
            PsiElement parent = element.getParent();
            if (JSIntroduceFieldHandler.isExprStatementWithUnneededRef((JSIntroduceFieldSettings)context.settings, element, context.expressionDescriptor)) {
                addedElement = element.replace(psiToInsert);
                replacedOriginal = true;
                parent = addedElement.getParent();
            } else if (JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)context.expressionDescriptor.first)) {
                JSVariable[] variables = ((JSVarStatement)element).getVariables();
                if (variables.length == 1) {
                    addedElement = element.replace(psiToInsert);
                } else {
                    addedElement = element.getParent().addBefore(psiToInsert, element);
                    ((JSExpression)context.expressionDescriptor.first).getParent().delete();
                }
                replacedOriginal = true;
                parent = addedElement.getParent();
            } else {
                addedElement = parent.addBefore(psiToInsert, element);
            }
            CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(parent.getNode(), addedElement.getNode());
        } else {
            JSSourceElement body;
            JSStatement statement;
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)context.expressionDescriptor.first), (Class[])new Class[]{JSClass.class, JSFile.class});
            if (parent instanceof JSFile) {
                PsiFile containingFile = parent.getContext().getContainingFile();
                assert (containingFile instanceof XmlFile);
                parent = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
            }
            assert (parent instanceof JSClass);
            JSClass clazz = (JSClass)parent;
            JSFunction fun = clazz.findFunctionByName(clazz.getName());
            if (fun == null) {
                String constr = "function " + clazz.getName() + "() {}";
                if (clazz.getAttributeList() != null && clazz.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC) {
                    constr = "public " + constr;
                }
                fun = (JSFunction)clazz.add(JSChangeUtil.createJSTreeFromText(project, constr, languageDialect).getPsi());
            }
            if ((statement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)(body = fun.getBody()[0]), JSStatement.class)) != null) {
                JSStatement jsStatement = statement.addStatementBefore((JSStatement)psiToInsert);
                JSIntroduceFieldHandler.fixFormat(project, (PsiElement)jsStatement);
            } else {
                body.add(psiToInsert);
            }
        }
        Pair result = Pair.create((Object)((JSVarStatement)JSChangeUtil.createStatementFromText(project, varDeclText + JSCodeStyleSettings.getSemicolon(anchorStatement.getContainingFile()), languageDialect).getPsi()), (Object)(replacedOriginal ? Boolean.TRUE : Boolean.FALSE));
        if (replacedOriginal) {
            JSVariable jsStatement = this.addStatementBefore(anchorStatement, (JSVarStatement)result.first);
            JSIntroduceFieldHandler.fixFormat(project, (PsiElement)jsStatement);
        }
        return result;
    }

    private static boolean isExprStatementWithUnneededRef(JSIntroduceFieldSettings settings, JSElement introduceContext, Pair<JSExpression, TextRange> expressionDescriptor) {
        if (settings.getInitializationPlace() == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            return introduceContext instanceof JSExpressionStatement && expressionDescriptor.second == null && ((JSExpression)expressionDescriptor.first).getParent() instanceof JSExpressionStatement;
        }
        return false;
    }

    @Override
    protected JSBaseInplaceIntroducer createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences) {
        return null;
    }
}

