/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterDialog;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSParameterInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSIntroduceParameterHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceParameterSettings, JSIntroduceParameterDialog> {
    protected JSParameterInserter parameterInserter;
    private JSIntroduceParameterSettings mySettings;
    public static final String SCOPE = "scope";
    private List<UsageInfo> myUsages;
    public static boolean ourLastOptionalParam = true;
    public static boolean ourLastAddJsDoc = false;
    private SmartPsiElementPointer<PsiElement> myInitializerPointer;

    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.parameter.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.parameter.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.parameter.error.expression.has.void.type";
    }

    @Override
    protected JSElement findIntroducedScope(Pair<JSExpression, TextRange> expressionDescriptor, DataContext dataContext) {
        Object data = dataContext.getData(SCOPE);
        if (data instanceof JSFunction) {
            return (JSElement)data;
        }
        return super.findIntroducedScope(expressionDescriptor, dataContext);
    }

    @Override
    protected Pair<JSExpression, TextRange> findIntroducedExpression(final PsiFile file, int start, int end, final Editor editor, DataContext dataContext) {
        Object data;
        Pair<JSExpression, TextRange> expression = super.findIntroducedExpression(file, start, end, editor, dataContext);
        if (expression != null && (data = dataContext.getData(SCOPE)) == null) {
            SmartList functions = new SmartList();
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression.first), JSFunction.class);
            while (fun != null) {
                functions.add(fun);
                fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
            }
            if (functions.size() == 0) {
                return null;
            }
            if (functions.size() > 1) {
                Pass<JSFunction> callback = new Pass<JSFunction>(){

                    public void pass(JSFunction function) {
                        THashMap map = new THashMap();
                        map.put(JSIntroduceParameterHandler.SCOPE, function);
                        JSIntroduceParameterHandler.this.invoke(editor.getProject(), editor, file, SimpleDataContext.getSimpleContext((Map)map, (DataContext)DataManager.getInstance().getDataContext()));
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    Object chooser = dataContext.getData("sync.test.chooser");
                    JSFunction chosen = (JSFunction)functions.get(functions.size() - 1);
                    if (chooser instanceof Function) {
                        chosen = (JSFunction)((Function)chooser).fun((Object)functions.toArray(new JSFunction[functions.size()]));
                    }
                    callback.pass((Object)chosen);
                    return null;
                }
                IntroduceTargetChooser.showChooser((Editor)editor, (List)functions, (Pass)callback, (Function)new Function<JSFunction, String>(){

                    public String fun(JSFunction jsExpression) {
                        ItemPresentation presentation = jsExpression.getPresentation();
                        String locationString = presentation.getLocationString();
                        return presentation.getPresentableText() + (locationString != null ? " " + locationString : "");
                    }
                }, (String)"Target Function");
                return null;
            }
        }
        return expression;
    }

    @Override
    protected JSBaseInplaceIntroducer<JSIntroduceParameterSettings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences) {
        return new JSParameterInplaceIntroducer(editor, project, occurences, this, context);
    }

    @Override
    protected InplaceSettings<JSIntroduceParameterSettings> getInplaceSettings(final Pair<JSExpression, TextRange> exprDescriptor, JSExpression[] occurrences, final PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)exprDescriptor.first, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newParam";
        return new InplaceSettings<JSIntroduceParameterSettings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public JSIntroduceParameterSettings getSettings() {
                return new JSIntroduceParameterSettings.Base(exprDescriptor){

                    @Override
                    public boolean addOptionalParameter() {
                        return ourLastOptionalParam;
                    }

                    @Override
                    public boolean addJsDoc() {
                        return ourLastAddJsDoc;
                    }

                    @Override
                    public String getInitialValue() {
                        return JSIntroduceParameterHandler.access$001(JSIntroduceParameterHandler.this, exprDescriptor).getText();
                    }

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public JSFunction functionForIntroduceParameter() {
                        if (scope instanceof JSFunction) {
                            return (JSFunction)scope;
                        }
                        return super.functionForIntroduceParameter();
                    }
                };
            }
        };
    }

    @Override
    protected void doPreprocess(Project project, JSIntroduceParameterSettings settings) {
        final JSFunction fun = settings.functionForIntroduceParameter();
        assert (fun != null);
        this.myUsages = new ArrayList<UsageInfo>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ReferencesSearch.search((PsiElement)fun).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference psiReference) {
                        JSIntroduceParameterHandler.this.myUsages.add(new UsageInfo(psiReference));
                        return true;
                    }
                });
            }
        }, JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), false, project);
    }

    @Override
    protected boolean visitInnerFunctions() {
        return true;
    }

    @Override
    protected JSIntroduceParameterDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceParameterDialog(project, occurrences, expression, expression.getText(), scope instanceof JSFunction ? (JSFunction)scope : (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class));
    }

    @Override
    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        PsiFile file;
        String initialValue = this.mySettings == null ? super.getReplacementExpression(expressionDescriptor).getText() : this.mySettings.getInitialValue();
        Project project = this.mySettings == null ? ((JSExpression)expressionDescriptor.first).getProject() : this.mySettings.functionForIntroduceParameter().getProject();
        PsiFile psiFile = file = this.mySettings == null ? ((JSExpression)expressionDescriptor.first).getContainingFile() : this.mySettings.functionForIntroduceParameter().getContainingFile();
        if (initialValue.length() == 0) {
            initialValue = "null";
        }
        boolean doUnwrapParenthesized = false;
        if (expressionDescriptor.first instanceof JSFunctionExpression || expressionDescriptor.first instanceof JSObjectLiteralExpression || expressionDescriptor.first instanceof JSArrayLiteralExpression) {
            initialValue = "(" + initialValue + ")";
            doUnwrapParenthesized = true;
        }
        JSExpression psi = (JSExpression)JSChangeUtil.createExpressionFromText(project, initialValue, JSUtils.getDialect(file)).getPsi();
        if (doUnwrapParenthesized) {
            psi = ((JSParenthesizedExpression)psi).getInnerExpression();
        }
        return psi;
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> settingsBaseIntroduceContext, boolean replaceAllOccurences) {
        this.mySettings = (JSIntroduceParameterSettings)settingsBaseIntroduceContext.settings;
        this.parameterInserter = JSParameterInserter.build((PsiElement)((JSIntroduceParameterSettings)settingsBaseIntroduceContext.settings).functionForIntroduceParameter());
        return super.findAnchor(settingsBaseIntroduceContext, replaceAllOccurences);
    }

    protected JSParameter addStatementBefore(JSElement anchorStatement, JSVarStatement declaration) throws IncorrectOperationException {
        JSVariable var = declaration.getVariables()[0];
        JSType type = var.getType();
        String paramText = var.getName() + (type != null ? ":" + type.getTypeText(JSType.TypeTextFormat.CODE) : "");
        JSLanguageDialect dialect = JSUtils.getDialect(declaration.getContainingFile());
        if (this.mySettings.addOptionalParameter() && dialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            paramText = var.getText();
        }
        JSExpression initializer = var.getInitializer();
        return this.parameterInserter.doInsert(paramText, this.mySettings.addOptionalParameter(), initializer != null ? initializer.getText() : null);
    }

    @Override
    protected void doPostprocess(JSVarStatement declaration, JSIntroduceParameterSettings settings, Editor editor) {
        JSFunction fun = settings.functionForIntroduceParameter();
        assert (fun != null);
        JSLanguageDialect dialect = JSUtils.getDialect(fun.getContainingFile());
        JSVariable variable = declaration.getVariables()[0];
        Document document = fun.getContainingFile().getViewProvider().getDocument();
        PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)fun.getProject());
        assert (document != null);
        boolean documentChanged = false;
        if (dialect != JavaScriptSupportLoader.ECMA_SCRIPT_L4 && settings.addOptionalParameter()) {
            this.myInitializerPointer = this.addOptionalParameterInitializer(fun, dialect, variable, editor);
            documentChanged = true;
        }
        if (settings.addJsDoc()) {
            ArrayList<String> create = new ArrayList<String>();
            JSExpression expression = (JSExpression)this.myReplacer.myExpressionDescriptor.first;
            StringBuilder paramTag = new StringBuilder("param ");
            JSType type = JSResolveUtil.getExpressionJSType(expression);
            if (type != null && (!(type instanceof JSAnyType) || type.getSource().isExplicitlyDeclared())) {
                paramTag.append("{").append(type.getTypeText(JSType.TypeTextFormat.CODE)).append("} ");
            }
            paramTag.append(variable.getName());
            create.add(paramTag.toString());
            instance.doPostponedOperationsAndUnblockDocument(document);
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)fun, create, null, null);
            documentChanged = true;
        }
        if (documentChanged) {
            instance.commitDocument(document);
        }
    }

    @Override
    public void performIntroduce(@NotNull JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> introduceContext) {
        PsiElement grandParent;
        if (introduceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introduceContext", "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterHandler", "performIntroduce"));
        }
        JSFunction fun = ((JSIntroduceParameterSettings)introduceContext.settings).functionForIntroduceParameter();
        assert (fun != null);
        for (UsageInfo u : this.myUsages) {
            PsiElement parent;
            PsiElement element = u.getElement();
            if (element == null || !((parent = element.getParent()) instanceof JSCallExpression)) continue;
            this.parameterInserter.fixCall((JSCallExpression)parent);
        }
        if (fun instanceof JSFunctionExpression && fun.getParent() instanceof JSParenthesizedExpression && (grandParent = fun.getParent().getParent()) instanceof JSCallExpression) {
            this.parameterInserter.fixCall((JSCallExpression)grandParent);
        }
    }

    protected SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(JSFunction function, JSLanguageDialect dialect, JSVariable var, Editor editor) {
        JSExpression initializer = var.getInitializer();
        return JSIntroduceParameterHandler.addOptionalParameterInitializer(function, dialect, var.getName(), initializer != null ? initializer.getText() : null, editor);
    }

    public static SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(JSFunction function, JSLanguageDialect dialect, String variableName, String defaultValue, Editor editor) {
        return JSIntroduceParameterHandler.addOptionalParameterInitializer(function, dialect, variableName, defaultValue, false, true, editor);
    }

    public static SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(JSFunction function, JSLanguageDialect dialect, String variableName, String defaultValue, boolean addBeforeFirstElement, boolean addSemicolon, Editor editor) {
        JSSourceElement[] functionBody = function.getBody();
        if (functionBody.length == 0) {
            return null;
        }
        JSSourceElement body = functionBody[0];
        Project project = function.getProject();
        String text = variableName + "=" + variableName + "||" + defaultValue;
        if (addSemicolon) {
            text = text + JSCodeStyleSettings.getSemicolon(function.getContainingFile());
        }
        PsiElement initializeStatement = JSChangeUtil.createStatementFromText(project, text, dialect).getPsi();
        PsiElement element = addBeforeFirstElement ? body.addBefore(initializeStatement, body.getFirstChild()) : body.addAfter(initializeStatement, body.getFirstChild());
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        JSIntroduceParameterHandler.fixFormat(project, pointer.getElement());
        return pointer;
    }

    public void removeOptionalParameterInitializer() {
        PsiElement element;
        PsiElement psiElement = element = this.myInitializerPointer != null ? this.myInitializerPointer.getElement() : null;
        if (element != null) {
            element.getParent().deleteChildRange(element, element.getNextSibling());
        }
    }

    public JSAssignmentExpression getOptionalInitializer() {
        JSExpression expression;
        PsiElement element;
        PsiElement psiElement = element = this.myInitializerPointer != null ? this.myInitializerPointer.getElement() : null;
        if (element instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)element).getExpression()) instanceof JSAssignmentExpression) {
            return (JSAssignmentExpression)expression;
        }
        return null;
    }

    static /* synthetic */ JSExpression access$001(JSIntroduceParameterHandler x0, Pair x1) {
        return super.getReplacementExpression((Pair<JSExpression, TextRange>)x1);
    }
}

