/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.ASVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;

public class JSIntroduceVariableHandler
extends JSBaseIntroduceHandler<JSStatement, Settings, JSIntroduceVariableDialog> {
    private static final String LAST_INTRODUCE = "js.last.introduce.type";

    public static Settings.IntroducedVarType getLastIntroduceType(Project project) {
        String value = PropertiesComponent.getInstance((Project)project).getValue(LAST_INTRODUCE, Settings.IntroducedVarType.VAR.name());
        return Settings.IntroducedVarType.valueOf(value);
    }

    public static void setLastIntroduceType(Project project, Settings.IntroducedVarType value) {
        PropertiesComponent.getInstance((Project)project).setValue(LAST_INTRODUCE, value.name());
    }

    @Override
    protected String getProductivityFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.variable.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.variable.error.expression.has.void.type";
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.variable.error.no.expression.selected";
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> baseIntroduceContext, JSStatement anchor) {
        return this.calcDeclText(baseIntroduceContext, ((Settings)baseIntroduceContext.settings).getIntroducedVarType().toString().toLowerCase(), anchor);
    }

    @Override
    protected JSBaseInplaceIntroducer<Settings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences) {
        JSExpression first = (JSExpression)context.expressionDescriptor.first;
        if (first.getParent() instanceof JSExpressionStatement) {
            for (int i = 0; i < occurences.length; ++i) {
                if (occurences[i] != first) continue;
                occurences = (JSExpression[])ArrayUtil.remove((Object[])occurences, (int)i);
                break;
            }
        }
        return DialectDetector.isActionScript((PsiElement)scope) ? new ASVariableInplaceIntroducer(project, editor, occurences, this, context) : new JSVariableInplaceIntroducer(project, editor, occurences, this, context);
    }

    @Override
    protected JSIntroduceVariableDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceVariableDialog(project, occurrences, expression, scope);
    }

    @Override
    protected InplaceSettings<Settings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, final PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)expr.first, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newVar";
        return new InplaceSettings<Settings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public Settings getSettings() {
                return new Settings(){

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public Settings.IntroducedVarType getIntroducedVarType() {
                        return JSIntroduceVariableHandler.getLastIntroduceType(scope.getProject());
                    }
                };
            }
        };
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<Settings> introduceContext, Project project, JSLanguageDialect languageDialect, JSStatement anchorStatement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        Pair<JSVarStatement, Boolean> preparedDeclarationStatus = super.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, anchorStatement, editor, introducedExpression);
        JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
        if (anchorStatement == introducedExpression.getParent() && anchorStatement instanceof JSExpressionStatement && !JSIntroduceVariableHandler.isIntroducingPartOfExpression(introduceContext.expressionDescriptor)) {
            declaration = (JSVarStatement)anchorStatement.replace((JSStatement)declaration);
            editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
            return Pair.create((Object)declaration, (Object)Boolean.TRUE);
        }
        return preparedDeclarationStatus;
    }
}

