/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHandler;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.ui.JSClassCellRenderer;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfoStorage;
import com.intellij.lang.javascript.refactoring.util.JSUsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.usageView.UsageViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JSPullUpDialog
extends DialogWrapper {
    private final Callback myCallback;
    private JSMemberSelectionPanel myMemberSelectionPanel;
    private MyJSMemberInfoModel myMemberInfoModel;
    private final JSClass myClass;
    private final List<JSClass> mySuperClasses;
    private final JSMemberInfoStorage myMemberInfoStorage;
    private List<JSMemberInfo> myMemberInfos;
    private DocCommentPanel myJavaDocPanel;
    private JComboBox myClassCombo;
    private final JSInterfaceContainmentVerifier myInterfaceContainmentVerifier = new JSInterfaceContainmentVerifier(){

        @Override
        public boolean checkedInterfacesContain(JSFunction psiMethod) {
            return JSPullUpHelper.checkedInterfacesContain(JSPullUpDialog.this.myMemberInfos, psiMethod);
        }
    };

    public JSPullUpDialog(Project project, JSClass aClass, List<JSClass> superClasses, JSMemberInfoStorage memberInfoStorage, Callback callback) {
        super(project, true);
        this.myClass = aClass;
        this.mySuperClasses = superClasses;
        this.myMemberInfoStorage = memberInfoStorage;
        this.myMemberInfos = new ArrayList<JSMemberInfo>(this.myMemberInfoStorage.getClassMemberInfos((PsiElement)aClass));
        JSMemberInfo.sortByOffset(this.myMemberInfos);
        this.myCallback = callback;
        this.setTitle(JSPullUpHandler.REFACTORING_NAME);
        this.init();
    }

    public JSClass getSuperClass() {
        if (this.myClassCombo != null) {
            return (JSClass)this.myClassCombo.getSelectedItem();
        }
        return null;
    }

    public int getJavaDocPolicy() {
        return this.myJavaDocPanel.getPolicy();
    }

    public JSMemberInfo[] getSelectedMemberInfos() {
        return JSMemberInfo.getSelected(this.myMemberInfos, this.myClass, new Condition<JSMemberInfo>(){

            public boolean value(JSMemberInfo jsMemberInfo) {
                return JSPullUpDialog.this.myMemberInfoModel.isMemberEnabled(jsMemberInfo);
            }
        });
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    JSInterfaceContainmentVerifier getContainmentVerifier() {
        return this.myInterfaceContainmentVerifier;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new JComboBox<Object>(this.mySuperClasses.toArray());
        this.myClassCombo.setRenderer(new JSClassCellRenderer());
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)this.myClass)}));
        classComboLabel.setLabelFor(this.myClassCombo);
        JSClass nearestBase = JSInheritanceUtil.findNearestBaseClass(this.myClass, false);
        int indexToSelect = 0;
        if (nearestBase != null) {
            indexToSelect = this.mySuperClasses.indexOf(nearestBase);
        }
        this.myClassCombo.setSelectedIndex(indexToSelect);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JSPullUpDialog.this.updateJSMemberInfo();
                    if (JSPullUpDialog.this.myMemberSelectionPanel != null) {
                        JSPullUpDialog.this.myMemberInfoModel.setSuperClass(JSPullUpDialog.this.getSuperClass());
                        JSPullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(JSPullUpDialog.this.myMemberInfos);
                        JSPullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                }
            }
        });
        ++gbConstraints.gridy;
        panel.add((Component)this.myClassCombo, gbConstraints);
        return panel;
    }

    private void updateJSMemberInfo() {
        JSClass targetClass = (JSClass)this.myClassCombo.getSelectedItem();
        this.myMemberInfos = new ArrayList<JSMemberInfo>(this.myMemberInfoStorage.getIntermediateMemberInfosList((PsiElement)targetClass));
        JSMemberInfo.sortByOffset(this.myMemberInfos);
    }

    protected void doOKAction() {
        if (!this.myCallback.checkConflicts(this)) {
            return;
        }
        this.close(0);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new JSMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pulled.up"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        this.myMemberInfoModel = new MyJSMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel.add((Component)this.myMemberSelectionPanel, "Center");
        this.myJavaDocPanel = new DocCommentPanel(JSBundle.message((String)"javascript.refactoring.asdoc.for.abstracts", (Object[])new Object[0]));
        panel.add((Component)this.myJavaDocPanel, "East");
        return panel;
    }

    private class MyJSMemberInfoModel
    extends JSUsesAndInterfacesDependencyMemberInfoModel {
        private JSClass mySuperClass;

        public MyJSMemberInfoModel() {
            super(JSPullUpDialog.this.myClass, JSPullUpDialog.this.getSuperClass(), false, JSPullUpDialog.this.myInterfaceContainmentVerifier);
        }

        public boolean isMemberEnabled(JSMemberInfo member) {
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return true;
            }
            if (JSPullUpDialog.this.myMemberInfoStorage.getDuplicatedMemberInfos((PsiElement)currentSuperClass).contains((Object)member)) {
                return false;
            }
            if (JSPullUpDialog.this.myMemberInfoStorage.getExtending((PsiElement)currentSuperClass).contains(member.getMember())) {
                return false;
            }
            if (!currentSuperClass.isInterface()) {
                return true;
            }
            PsiElement element = member.getMember();
            if (element instanceof JSClass && ((JSClass)element).isInterface()) {
                return true;
            }
            if (element instanceof JSVariable) {
                return false;
            }
            if (element instanceof JSFunction) {
                return !((JSAttributeListOwner)element).getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
            }
            return true;
        }

        public boolean isAbstractEnabled(JSMemberInfo member) {
            return false;
        }

        public boolean isAbstractWhenDisabled(JSMemberInfo member) {
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            return currentSuperClass != null && currentSuperClass.isInterface();
        }

        public int checkForProblems(@NotNull JSMemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog$MyJSMemberInfoModel", "checkForProblems"));
            }
            if (member.isChecked()) {
                return 0;
            }
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            if (currentSuperClass != null && currentSuperClass.isInterface()) {
                PsiElement element = member.getMember();
                if (element instanceof JSAttributeListOwner && ((JSAttributeListOwner)element).getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    return super.checkForProblems((MemberInfoBase)member);
                }
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        public Boolean isFixedAbstract(JSMemberInfo member) {
            return Boolean.TRUE;
        }

        @Override
        public void setSuperClass(JSClass superClass) {
            this.mySuperClass = superClass;
        }
    }

    public static interface Callback {
        public boolean checkConflicts(JSPullUpDialog var1);
    }
}

