/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.moveMembers;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMemberInfoModel;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMoveMembersHandler;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMoveMembersOptions;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMoveMembersProcessor;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionTable;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ThreeState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMoveMembersDialog
extends RefactoringDialog
implements JSMoveMembersOptions {
    @NonNls
    private static final String RECENTS_KEY = "JSMoveMembersDialog.RECENTS_KEY";
    private final Project myProject;
    private final JSClass mySourceClass;
    private final String mySourceClassName;
    private final List<JSMemberInfo> myMemberInfos = new ArrayList<JSMemberInfo>();
    private final JSReferenceEditor myTfTargetClassName;
    private JSMemberSelectionTable myTable;
    private final MoveCallback myMoveCallback;
    JSVisibilityPanel myVisibilityPanel;
    private JSMemberInfoModel myMemberInfoModel;

    public JSMoveMembersDialog(Project project, JSClass sourceClass, JSClass initialTargetClass, Set<JSElement> preselectMembers, MoveCallback moveCallback) {
        super(project, true);
        this.myProject = project;
        this.mySourceClass = sourceClass;
        this.myMoveCallback = moveCallback;
        this.setTitle(JSBundle.message((String)"move.members.dialog.title", (Object[])new Object[0]));
        this.mySourceClassName = this.mySourceClass.getQualifiedName();
        JSMemberInfo.extractStaticMembers(sourceClass, this.myMemberInfos, (MemberInfoBase.Filter<JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
        for (JSMemberInfo memberInfo : this.myMemberInfos) {
            memberInfo.setChecked(preselectMembers);
        }
        JSMemberInfo.sortByOffset(this.myMemberInfos);
        String fqName = initialTargetClass != null && !sourceClass.equals(initialTargetClass) ? initialTargetClass.getQualifiedName() : "";
        this.myTfTargetClassName = JSMoveMembersDialog.createTargetClassField(project, fqName, this.getScope(), (PsiElement)this.mySourceClass.getContainingFile());
        this.init();
    }

    public static JSReferenceEditor createTargetClassField(Project project, String text, GlobalSearchScope scope, PsiElement context) {
        return JSReferenceEditor.forClassName(text, project, RECENTS_KEY, scope, null, null, RefactoringBundle.message((String)"choose.destination.class"), context);
    }

    private GlobalSearchScope getScope() {
        return JSMoveMembersDialog.getScope(this.myProject);
    }

    public static GlobalSearchScope getScope(Project project) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        return new ScopeAllowingFileLocalSymbols(scope);
    }

    private void updateTargetClass() {
        this.myMemberInfoModel.setTargetClassName(this.getTargetClassName());
        this.myTable.fireExternalDataChange();
    }

    @Override
    @Nullable
    public String getMemberVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.lang.javascript.refactoring.movemethod.JSMoveMembersDialog";
    }

    private JTable createTable() {
        this.myMemberInfoModel = new JSMemberInfoModel(this.mySourceClass, null, false);
        this.myTable = new JSMemberSelectionTable(this.myMemberInfos, null, null);
        this.myTable.setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.myTable.addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        return this.myTable;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        JTextField sourceClassField = new JTextField();
        sourceClassField.setText(this.mySourceClassName);
        sourceClassField.setEditable(false);
        _panel.add((Component)new JLabel(RefactoringBundle.message((String)"move.members.move.members.from.label")), "North");
        _panel.add((Component)sourceClassField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        _panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(RefactoringBundle.message((String)"move.members.to.fully.qualified.name.label"));
        label.setLabelFor((Component)((Object)this.myTfTargetClassName));
        _panel.add((Component)label, "North");
        _panel.add((Component)((Object)this.myTfTargetClassName), "Center");
        box.add(_panel);
        this.myTfTargetClassName.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                JSMoveMembersDialog.this.updateTargetClass();
                JSMoveMembersDialog.this.validateButtons();
            }
        });
        panel.add((Component)box, "Center");
        panel.add(Box.createVerticalStrut(10), "South");
        this.validateButtons();
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table = this.createTable();
        if (table.getRowCount() > 0) {
            table.getSelectionModel().addSelectionInterval(0, 0);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)table);
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"move.members.members.to.be.moved.border.title"), (boolean)false);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, emptyBorder);
        scrollPane.setBorder(border);
        panel.add((Component)scrollPane, "Center");
        this.myVisibilityPanel = new JSVisibilityPanel(true, true, true, true);
        this.myVisibilityPanel.setVisibility(null);
        panel.add((Component)((Object)this.myVisibilityPanel), "East");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTfTargetClassName.getChildComponent();
    }

    @Override
    public JSAttributeListOwner[] getSelectedMembers() {
        JSMemberInfo[] infos = JSMemberInfo.getSelected(this.myTable.getSelectedMemberInfos(), this.mySourceClass, (Condition<JSMemberInfo>)Conditions.alwaysTrue());
        JSAttributeListOwner[] result = new JSAttributeListOwner[infos.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (JSAttributeListOwner)infos[i].getMember();
        }
        return result;
    }

    @Override
    public String getTargetClassName() {
        return this.myTfTargetClassName.getText();
    }

    protected void doAction() {
        String message = this.validateInputData();
        if (message != null) {
            if (message.length() != 0) {
                CommonRefactoringUtil.showErrorMessage((String)StringUtil.capitalizeWords((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (boolean)true), (String)message, null, (Project)this.myProject);
            }
            return;
        }
        this.myTfTargetClassName.updateRecents();
        this.invokeRefactoring(new JSMoveMembersProcessor(this.getProject(), this.myMoveCallback, this.mySourceClass, this.getScope(), new JSMoveMembersOptions(){

            @Override
            public String getMemberVisibility() {
                return JSMoveMembersDialog.this.getMemberVisibility();
            }

            @Override
            public JSAttributeListOwner[] getSelectedMembers() {
                return JSMoveMembersDialog.this.getSelectedMembers();
            }

            @Override
            public String getTargetClassName() {
                return JSMoveMembersDialog.this.getTargetClassName();
            }
        }));
    }

    protected void canRun() throws ConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.getTargetClassName())) {
            throw new ConfigurationException(RefactoringBundle.message((String)"no.destination.class.specified"));
        }
    }

    @Nullable
    private String validateInputData() {
        String fqName = this.getTargetClassName();
        if ("".equals(fqName)) {
            return RefactoringBundle.message((String)"no.destination.class.specified");
        }
        if (!JSUtils.isValidClassName(fqName, true)) {
            return RefactoringBundle.message((String)"0.is.not.a.legal.fq.name", (Object[])new Object[]{fqName});
        }
        JSClass targetClass = this.findOrCreateTargetClass(fqName);
        if (targetClass == null) {
            return "";
        }
        if (this.mySourceClass.equals(targetClass)) {
            return RefactoringBundle.message((String)"source.and.destination.classes.should.be.different");
        }
        if (!this.mySourceClass.getLanguage().equals(targetClass.getLanguage())) {
            return RefactoringBundle.message((String)"move.to.different.language", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)this.mySourceClass), this.mySourceClass.getQualifiedName(), targetClass.getQualifiedName()});
        }
        return !targetClass.isWritable() && !JSRefactoringUtil.checkReadOnlyStatus((PsiElement)targetClass, null, JSMoveMembersHandler.REFACTORING_NAME) ? "" : null;
    }

    @Nullable
    private JSClass findOrCreateTargetClass(final String fqName) {
        PsiDirectory baseDir;
        final String className = StringUtil.getShortName((String)fqName);
        final String packageName = StringUtil.getPackageName((String)fqName);
        final GlobalSearchScope scope = this.getScope();
        final JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
        PsiElement aClass = resolver.findClassByQName(fqName, scope);
        if (aClass instanceof JSClass) {
            return (JSClass)aClass;
        }
        if (aClass != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)JSBundle.message((String)"class.0.cannot.be.created", (Object[])new Object[]{fqName}), (String)StringUtil.capitalizeWords((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (boolean)true));
            return null;
        }
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"class.0.does.not.exist", (Object[])new Object[]{fqName}), (String)StringUtil.capitalizeWords((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (boolean)true), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.mySourceClass);
        final PsiDirectory targetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass(this.myProject, module, scope, packageName, className, baseDir = PlatformPackageUtil.getDirectory((PsiElement)this.mySourceClass), ThreeState.UNSURE);
        if (targetDirectory == null) {
            return null;
        }
        final Ref error = new Ref();
        final Ref newClass = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    AccessToken accessToken = WriteAction.start();
                    try {
                        CreateClassOrInterfaceFix.createClass(className, packageName, targetDirectory, false);
                        newClass.set((Object)((JSClass)resolver.findClassByQName(fqName, scope)));
                    }
                    catch (Exception e) {
                        error.set((Object)e);
                    }
                    finally {
                        accessToken.finish();
                    }
                }
                catch (Exception e) {
                    CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (String)e.getMessage(), null, (Project)JSMoveMembersDialog.this.myProject);
                }
            }
        }, RefactoringBundle.message((String)"create.class.command", (Object[])new Object[]{fqName}), null);
        if (!error.isNull()) {
            CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (String)((Exception)error.get()).getMessage(), null, (Project)this.myProject);
            return null;
        }
        return (JSClass)newClass.get();
    }

    private static class ScopeAllowingFileLocalSymbols
    extends DelegatingGlobalSearchScope
    implements JSResolveUtil.AllowFileLocalSymbols {
        public ScopeAllowingFileLocalSymbols(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/lang/javascript/refactoring/moveMembers/JSMoveMembersDialog$ScopeAllowingFileLocalSymbols", "<init>"));
            }
            super(baseScope);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/refactoring/moveMembers/JSMoveMembersDialog$ScopeAllowingFileLocalSymbols", "contains"));
            }
            return super.contains(file);
        }
    }
}

