/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSRefactoringDescriptionLocation;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRefactoringConflictsUtil {
    public static void analyzeModuleConflicts(Project project, Collection<? extends PsiElement> scope, UsageInfo[] usages, PsiElement target, MultiMap<PsiElement, String> conflicts) {
        if (scope == null) {
            return;
        }
        VirtualFile vFile = PsiUtilBase.getVirtualFile((PsiElement)target);
        if (vFile == null) {
            return;
        }
        JSRefactoringConflictsUtil.analyzeModuleConflicts(project, scope, usages, vFile, conflicts);
    }

    private static void analyzeModuleConflicts(Project project, final Collection<? extends PsiElement> scopes, UsageInfo[] usages, VirtualFile vFile, final MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        final Module targetModule = ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null) {
            return;
        }
        final GlobalSearchScope resolveScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        for (PsiElement psiElement : scopes) {
            psiElement.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitJSReferenceExpression(JSReferenceExpression reference) {
                    super.visitJSReferenceExpression(reference);
                    PsiElement resolved = reference.resolve();
                    if (!(resolved == null || reported.contains((Object)resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || JSResolveUtil.isFromPredefinedFile(resolved.getContainingFile()) || PsiSearchScopeUtil.isInScope((GlobalSearchScope)resolveScope, (PsiElement)resolved))) {
                        String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation((PsiElement)reference), (boolean)true);
                        String message = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)resolved, (boolean)true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                        conflicts.putValue((Object)resolved, (Object)message);
                        reported.add((Object)resolved);
                    }
                }
            });
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile);
        block1: for (UsageInfo usage : usages) {
            Module module;
            PsiFile container;
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsageInfo = (MoveRenameUsageInfo)usage;
            PsiElement element = usage.getElement();
            if (element == null || PsiTreeUtil.getParentOfType((PsiElement)element, JSImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
                continue block1;
            }
            GlobalSearchScope resolveScope1 = element.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element.getContainingFile();
            if (psiFile instanceof JSFile) {
                container = JSRefactoringConflictsUtil.getContainerMember(element);
                if (container == null) {
                    container = psiFile;
                }
            } else {
                container = psiFile;
            }
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            PsiElement referencedElement = moveRenameUsageInfo.getReferencedElement();
            String message = module == targetModule && isInTestSources ? RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())}) : RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            conflicts.putValue((Object)referencedElement, (Object)message);
        }
    }

    @Nullable
    private static PsiElement getContainerMember(PsiElement place) {
        PsiElement parent = place;
        while (!JSUtils.isMember(parent)) {
            if (parent instanceof PsiFile) {
                return null;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    public static void checkIncomingReferencesAccessibility(UsageInfo[] usages, JSClass targetClass, @Nullable String newVisibility, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkIncomingReferencesAccessibility"));
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof JSMemberUsageInfo)) continue;
            JSMemberUsageInfo usageInfo = (JSMemberUsageInfo)usage;
            PsiElement element = usage.getElement();
            if (!(element instanceof JSReferenceExpression)) continue;
            JSRefactoringConflictsUtil.checkAccessibility(usageInfo.member, targetClass, newVisibility, element, conflicts, false, options);
        }
    }

    public static void checkAccessibility(JSAttributeListOwner member, @Nullable JSClass targetClass, @Nullable String newVisibility, PsiElement usage, MultiMap<PsiElement, String> conflicts, boolean showTargetClass, @NotNull JSVisibilityUtil.Options options) {
        JSAttributeList.AccessType accessType;
        boolean accessible;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkAccessibility"));
        }
        if (newVisibility == null) {
            accessible = JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, targetClass, usage, options);
            accessType = member.getAttributeList().getAccessType();
        } else {
            accessType = "escalate".equals(newVisibility) ? JSAttributeList.AccessType.PUBLIC : JSAttributeList.AccessType.valueOf((String)newVisibility);
            accessible = JSVisibilityUtil.isAccessible((PsiElement)member, accessType, targetClass, usage, options);
        }
        if (!accessible) {
            if (accessType == JSAttributeList.AccessType.PUBLIC) {
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)targetClass, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT), JSFormatUtil.formatVisibility(targetClass.getAttributeList().getAccessType()), ElementDescriptionUtil.getElementDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation(usage), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)member, (Object)message);
            } else {
                String message = JSBundle.message((String)(showTargetClass ? "0.with.1.visibility.is.not.accessible.from.2" : "0.with.1.visibility.in.the.target.class.is.not.accessible.from.2"), (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)member, (ElementDescriptionLocation)(showTargetClass ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT)), JSFormatUtil.formatVisibility(accessType), ElementDescriptionUtil.getElementDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation(usage), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)member, (Object)message);
            }
        }
    }

    public static PsiElement getUsageLocation(PsiElement usage) {
        XmlBackedJSClass xmlBackedClass;
        Object result = usage.getParent() instanceof JSReferenceList && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)usage.getContainingFile()) ? usage.getContainingFile() : PsiTreeUtil.getParentOfType((PsiElement)usage, JSFunction.class);
        if (result == null) {
            result = PsiTreeUtil.getParentOfType((PsiElement)usage, (Class[])new Class[]{JSVariable.class, JSClass.class, JSFile.class});
        }
        if (result instanceof JSFile && (xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)result)) != null) {
            return xmlBackedClass;
        }
        return result;
    }

    public static void checkMembersAlreadyExist(JSMemberInfo[] infos, JSClass targetClass, MultiMap<PsiElement, String> conflicts) {
        for (JSMemberInfo info : infos) {
            JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)info.getMember(), targetClass, conflicts);
        }
    }

    public static void checkMembersAlreadyExist(Collection<JSAttributeListOwner> members, JSClass targetClass, MultiMap<PsiElement, String> conflicts) {
        for (JSAttributeListOwner member : members) {
            JSRefactoringConflictsUtil.checkMemberExist(member, targetClass, conflicts);
        }
    }

    public static void checkMemberExist(JSAttributeListOwner member, JSClass targetClass, MultiMap<PsiElement, String> conflicts) {
        boolean exists = false;
        if (member instanceof JSVariable && !targetClass.isInterface()) {
            exists = targetClass.findFieldByName(member.getName()) != null;
        } else if (member instanceof JSFunction) {
            boolean bl = exists = JSInheritanceUtil.findMethodInClass((JSFunction)member, targetClass, targetClass.isInterface()) != null;
        }
        if (exists) {
            String message = CommonRefactoringUtil.capitalize((String)RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)}));
            conflicts.putValue((Object)member, (Object)message);
        }
    }

    public static void checkOutgoingReferencesAccessibility(PsiElement memberToMove, @NotNull Collection<? extends PsiElement> membersToMove, @Nullable PsiElement target, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, Condition<PsiElement> acceptor, @NotNull JSVisibilityUtil.Options options) {
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkOutgoingReferencesAccessibility"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkOutgoingReferencesAccessibility"));
        }
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility(memberToMove, memberToMove, membersToMove, target, moveNotInline, conflicts, acceptor, (Collection<PsiElement>)new HashSet(), options);
    }

    public static void checkOutgoingReferencesInSignatureAccessibility(JSFunction memberToMove, @NotNull PsiElement target, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkOutgoingReferencesInSignatureAccessibility"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkOutgoingReferencesInSignatureAccessibility"));
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.addAll(Arrays.asList(memberToMove.getParameterList().getParameters()));
        if (memberToMove.getReturnTypeElement() != null) {
            elements.add(memberToMove.getReturnTypeElement());
        }
        HashSet reported = new HashSet();
        for (PsiElement psiElement : elements) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)memberToMove, psiElement, Collections.emptyList(), target, moveNotInline, conflicts, (Condition<PsiElement>)Conditions.alwaysTrue(), (Collection<PsiElement>)reported, options);
        }
    }

    public static void checkOutgoingReferencesAccessibility(PsiElement member, PsiElement current, @NotNull Collection<? extends PsiElement> membersToMove, @Nullable PsiElement target, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, Condition<PsiElement> acceptor, Collection<PsiElement> reported, @NotNull JSVisibilityUtil.Options options) {
        JSReferenceExpression refExpr;
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkOutgoingReferencesAccessibility"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "checkOutgoingReferencesAccessibility"));
        }
        if (current instanceof JSReferenceExpression && (refExpr = (JSReferenceExpression)current).getQualifier() == null) {
            String qName;
            JSNamespaceDeclaration namespaceDecl;
            boolean ignore;
            JSReferenceExpression top = (JSReferenceExpression)JSResolveUtil.getTopReferenceExpression((PsiElement)refExpr);
            PsiElement resolved = top.resolve();
            if (resolved != null && acceptor.value((Object)resolved) && !(ignore = moveNotInline ? JSRefactoringUtil.isOrWillBeInTargetClass(resolved, membersToMove, (JSClass)target, false) : PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)resolved, (boolean)false)) && !JSVisibilityUtil.isAccessible(resolved, (JSAttributeList)null, null, (PsiElement)(target != null ? target : refExpr), options)) {
                JSRefactoringConflictsUtil.reportInaccessibleElement(resolved, null, moveNotInline ? JSRefactoringConflictsUtil.getUsageLocation(current) : target, moveNotInline, conflicts, reported);
            }
            if (!(resolved == null || (namespaceDecl = JSRefactoringUtil.getNamespace(resolved)) == null || reported.contains(namespaceDecl) || "AS3".equals(qName = namespaceDecl.getQualifiedName()) || JSVisibilityUtil.isAccessible((PsiElement)namespaceDecl, (JSAttributeList)null, null, (PsiElement)(target != null ? target : refExpr), options))) {
                JSRefactoringConflictsUtil.reportInaccessibleElement((PsiElement)namespaceDecl, null, moveNotInline ? member : target, moveNotInline, conflicts, reported);
            }
        }
        for (PsiElement child : current.getChildren()) {
            if (child instanceof PsiWhiteSpace) continue;
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility(member, child, membersToMove, target, moveNotInline, conflicts, acceptor, reported, options);
        }
    }

    private static PsiElement getInaccessibleElement(PsiElement element) {
        JSClass clazz;
        if (!(element instanceof JSAttributeListOwner)) {
            return element;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
        if ((attributeList.getNamespace() != null || attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC) && (clazz = JSUtils.getMemberContainingClass(element)) != null) {
            return clazz;
        }
        return element;
    }

    public static void reportInaccessibleElement(PsiElement subject, @Nullable JSClass subjectClassOverride, PsiElement from, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, Collection<PsiElement> reported) {
        if (!reported.add(subject = JSRefactoringConflictsUtil.getInaccessibleElement(subject))) {
            return;
        }
        boolean reportVisibility = JSUtils.getMemberContainingClass(subject) != null || !JSResolveUtil.isFileLocalSymbol(subject);
        String subjectDescription = ElementDescriptionUtil.getElementDescription((PsiElement)subject, (ElementDescriptionLocation)JSRefactoringDescriptionLocation.overrideParentClass(subjectClassOverride));
        String fromDescription = ElementDescriptionUtil.getElementDescription((PsiElement)from, (ElementDescriptionLocation)(moveNotInline ? RefactoringDescriptionLocation.WITHOUT_PARENT : RefactoringDescriptionLocation.WITH_PARENT));
        String message = reportVisibility ? RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{subjectDescription, JSFormatUtil.formatVisibility(subject), fromDescription}) : JSBundle.message((String)"0.is.not.accessible.from.1", (Object[])new Object[]{subjectDescription, fromDescription});
        message = StringUtil.capitalize((String)message);
        conflicts.putValue((Object)subject, (Object)message);
    }

    public static MultiMap<PsiElement, String> calcAccessibilityConflicts(PsiReference reference, JSAttributeListOwner referenced, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil", "calcAccessibilityConflicts"));
        }
        if (PsiTreeUtil.isAncestor((PsiElement)referenced, (PsiElement)reference.getElement(), (boolean)true)) {
            return null;
        }
        PsiElement target = PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), JSFunction.class);
        if (target == null) {
            target = JSResolveUtil.getClassOfContext(reference.getElement());
        }
        if (target == null) {
            target = reference.getElement().getContainingFile();
        }
        MultiMap conflicts = new MultiMap();
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)referenced, Collections.singletonList(referenced), target, false, (MultiMap<PsiElement, String>)conflicts, (Condition<PsiElement>)Conditions.alwaysTrue(), options);
        return conflicts;
    }
}

