/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

class JSDefinitionsSearchExecutor
implements QueryExecutor<PsiElement, PsiElement> {
    JSDefinitionsSearchExecutor() {
    }

    public boolean execute(final @NotNull PsiElement _sourceElement, final @NotNull Processor<PsiElement> consumer) {
        if (_sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_sourceElement", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "execute"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return JSDefinitionsSearchExecutor.doExecute(_sourceElement, (Processor<PsiElement>)consumer);
            }
        });
    }

    private static boolean doExecute(PsiElement _sourceElement, final Processor<PsiElement> consumer) {
        if (_sourceElement.getLanguage().isKindOf(Language.findInstance(JavascriptLanguage.class))) {
            JSAttributeList attrList;
            if (_sourceElement instanceof PsiNamedElement) {
                final PsiElement sourceElement = JSResolveUtil.unwrapProxy(_sourceElement);
                final GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)sourceElement.getProject());
                GlobalSearchScope projectScope2 = new GlobalSearchScope(){

                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor$2", "contains"));
                        }
                        FileType java = FileTypeRegistry.getInstance().findFileTypeByName("JAVA");
                        return searchScope.contains(file) && file.getFileType() != java;
                    }

                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        if (file1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor$2", "compare"));
                        }
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor$2", "compare"));
                        }
                        return searchScope.compare(file1, file2);
                    }

                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor$2", "isSearchInModuleContent"));
                        }
                        return searchScope.isSearchInModuleContent(aModule);
                    }

                    public boolean isSearchInLibraries() {
                        return searchScope.isSearchInLibraries();
                    }
                };
                ReferencesSearch.search((PsiElement)sourceElement, (SearchScope)projectScope2).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference t) {
                        if (t instanceof JSReferenceExpression) {
                            ResolveResult[] resolveResults;
                            PsiElement parent = ((JSReferenceExpression)t).getParent();
                            for (ResolveResult r : resolveResults = ((JSReferenceExpression)t).multiResolve(true)) {
                                PsiElement psiElement = JSResolveUtil.unwrapProxy(r.getElement());
                                if (psiElement == null || JSResolveUtil.isFromPredefinedFile(psiElement.getContainingFile()) || sourceElement == psiElement) continue;
                                if (psiElement instanceof JSFunction && sourceElement instanceof JSFunction) {
                                    JSFunction fun = (JSFunction)psiElement;
                                    JSFunction sourceFun = (JSFunction)sourceElement;
                                    if (sourceFun.isGetProperty() && fun.isSetProperty() || sourceFun.isSetProperty() && fun.isGetProperty()) {
                                        return true;
                                    }
                                }
                                if (psiElement == sourceElement && psiElement instanceof JSClass || consumer.process((Object)psiElement)) continue;
                                return false;
                            }
                            if (!(parent instanceof JSDefinitionExpression)) {
                                return false;
                            }
                        }
                        return true;
                    }
                });
                if (sourceElement instanceof JSClass) {
                    JSClass clazz = (JSClass)sourceElement;
                    Processor<JSClass> delegatingProcessor = new Processor<JSClass>(){

                        public boolean process(JSClass jsClass) {
                            JSClass e = jsClass instanceof XmlBackedJSClass ? jsClass : jsClass.getNavigationElement();
                            return consumer.process((Object)e);
                        }
                    };
                    JSClassSearch.searchClassInheritors(clazz, true).forEach((Processor)delegatingProcessor);
                    if (clazz.isInterface()) {
                        JSClassSearch.searchInterfaceImplementations(clazz, true).forEach((Processor)delegatingProcessor);
                    }
                } else if (sourceElement instanceof JSFunction && JSInheritanceUtil.canBeSuperMethod((JSFunction)sourceElement)) {
                    JSFunction baseFunction = (JSFunction)sourceElement;
                    Processor<JSFunction> delegatingProcessor = new Processor<JSFunction>(){

                        public boolean process(JSFunction jsFunction) {
                            return consumer.process((Object)jsFunction.getNavigationElement());
                        }
                    };
                    JSFunctionsSearch.searchOverridingFunctions(baseFunction, true).forEach((Processor)delegatingProcessor);
                    PsiElement parent = baseFunction.getParent();
                    if (parent instanceof JSClass && ((JSClass)parent).isInterface()) {
                        JSFunctionsSearch.searchImplementingFunctions(baseFunction, true).forEach((Processor)delegatingProcessor);
                    }
                } else if ((!(sourceElement instanceof JSFunction) || ((JSFunction)sourceElement).isConstructor()) && sourceElement instanceof JSPsiElementBase) {
                    JSResolveUtil.doFindOverridenFunctionStatic((JSPsiElementBase)sourceElement).forEach((Processor)new Processor<JSPsiElementBase>(){

                        public boolean process(JSPsiElementBase jsNamedElement) {
                            return consumer.process((Object)jsNamedElement);
                        }
                    });
                }
            }
            if (_sourceElement instanceof JSVariable && (attrList = ((JSVariable)_sourceElement).getAttributeList()) != null && attrList.hasModifier(JSAttributeList.ModifierType.STATIC) && ((JSVariable)_sourceElement).hasInitializer()) {
                ReferencesSearch.search((PsiElement)_sourceElement).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference psiReference) {
                        JSExpression[] arguments;
                        JSExpression methodExpression;
                        PsiElement grandParent;
                        PsiElement elt = psiReference.getElement();
                        PsiElement parent = elt.getParent();
                        if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && "addEventListener".equals(((JSReferenceExpression)methodExpression).getReferencedName()) && (arguments = ((JSArgumentList)parent).getArguments())[0] == elt && arguments.length > 1) {
                            PsiElement resolve;
                            JSExpression argument = arguments[1];
                            if (argument instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)argument).resolve()) instanceof JSFunction) {
                                argument = resolve;
                            }
                            if (argument instanceof JSFunction) {
                                return consumer.process((Object)argument);
                            }
                        }
                        return true;
                    }
                });
            }
        }
        return true;
    }
}

