/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class JSLanguageVersionModel
extends AbstractListModel
implements ComboBoxModel {
    @NotNull
    private JSLanguageLevel myLanguageLevel = JSLanguageLevel.DEFAULT;
    @NotNull
    private JSLanguageLevel[] myLevels = JSLanguageVersionModel.getAvailableLevels();

    JSLanguageVersionModel() {
    }

    @NotNull
    public static JSLanguageLevel[] getAvailableLevels() {
        JSLanguageLevel[] values = JSLanguageLevel.values();
        if (PlatformUtils.isIntelliJ()) {
            if (values == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSLanguageVersionModel", "getAvailableLevels"));
            }
            return values;
        }
        JSLanguageLevel[] result = new JSLanguageLevel[values.length - 1];
        int i = 0;
        for (JSLanguageLevel value : values) {
            if (value == JSLanguageLevel.NASHORN) continue;
            result[i++] = value;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSLanguageVersionModel", "getAvailableLevels"));
        }
        return result;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!this.myLanguageLevel.equals(anItem) && ArrayUtil.contains((Object)anItem, (Object[])this.myLevels)) {
            this.myLanguageLevel = (JSLanguageLevel)((Object)anItem);
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.myLanguageLevel;
    }

    @Override
    public int getSize() {
        return this.myLevels.length;
    }

    @Override
    public Object getElementAt(int index) {
        return this.myLevels[index];
    }
}

