/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="JavaScriptSettings", storages={@Storage(file="$PROJECT_FILE$")})
public class JSRootConfigurationBase
extends JSRootConfiguration
implements PersistentStateComponent<State> {
    public static final String JS_LANGUAGE_LEVEL_PROPERTY_NAME = "JavaScriptLanguageLevel";
    public static final String JS_PREFER_STRICT_PROPERTY_NAME = "JavaScriptPreferStrict";
    public static final String JS_WEAKER_COMPLETION_TYPE_GUESS_PROPERTY_NAME = "JavaScriptWeakerCompletionTypeGuess";
    private static final boolean JS_PREFER_STRICT_DEFAULT = false;
    private static final boolean JS_ONLY_TYPE_BASED_COMPLETION_DEFAULT = false;
    protected final Project myProject;
    protected final PropertiesComponent myPropertiesComponent;
    private State myState;

    public JSRootConfigurationBase(Project project) {
        this.myProject = project;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project);
    }

    public void storeLanguageLevel(@Nullable JSLanguageLevel languageLevel) {
        if (this.myState == null) {
            this.myState = new State();
        }
        this.myState.myLanguageLevel = languageLevel;
        if (languageLevel == null) {
            return;
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.myProject);
        if (languageLevel.isES5Compatible()) {
            mappings.associate(null, "HTML5 / ECMAScript 5", true);
        } else {
            mappings.disassociate(null, "HTML5 / ECMAScript 5");
        }
        if (languageLevel.isES6Compatible()) {
            mappings.associate(null, "ECMAScript 6", true);
        } else {
            mappings.disassociate(null, "ECMAScript 6");
        }
        if (languageLevel.isXmlEnabled()) {
            mappings.associate(null, "HTML", true);
        }
        if (languageLevel == JSLanguageLevel.NASHORN) {
            mappings.associate(null, "Nashorn", true);
        } else {
            mappings.disassociate(null, "Nashorn");
        }
    }

    @Override
    public void storeLanguageLevelAndUpdateCaches(@Nullable JSLanguageLevel languageLevel) {
        this.storeLanguageLevel(languageLevel);
    }

    public static boolean requiresReparse(JSLanguageLevel oldLanguageLevel, JSLanguageLevel languageLevel) {
        EnumSet<JSLanguageLevel> JS15Set = EnumSet.of(JSLanguageLevel.JS_1_5, JSLanguageLevel.ES5);
        EnumSet<JSLanguageLevel> JS16Set = EnumSet.of(JSLanguageLevel.JS_1_6, JSLanguageLevel.JS_1_7, JSLanguageLevel.JS_1_8, JSLanguageLevel.JS_1_8_5);
        return !(oldLanguageLevel == languageLevel || JS15Set.contains((Object)oldLanguageLevel) && JS15Set.contains((Object)languageLevel) || JS16Set.contains((Object)oldLanguageLevel) && JS16Set.contains((Object)languageLevel));
    }

    @Override
    @NotNull
    public JSLanguageLevel getLanguageLevel() {
        JSLanguageLevel storedLanguageLevel = this.getStoredLanguageLevel();
        JSLanguageLevel jSLanguageLevel = storedLanguageLevel != null ? storedLanguageLevel : JSLanguageLevel.DEFAULT;
        if (jSLanguageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurationBase", "getLanguageLevel"));
        }
        return jSLanguageLevel;
    }

    @Override
    @Nullable
    public JSLanguageLevel getStoredLanguageLevel() {
        return this.myState != null && this.myState.myLanguageLevel != null ? this.myState.myLanguageLevel : (this.myPropertiesComponent != null ? JSLanguageLevel.ofId(this.myPropertiesComponent.getValue(JS_LANGUAGE_LEVEL_PROPERTY_NAME)) : null);
    }

    @Override
    public void storePreferStrict(boolean preferStrict) {
        this.myPropertiesComponent.setValue(JS_PREFER_STRICT_PROPERTY_NAME, Boolean.toString(preferStrict));
    }

    @Override
    public boolean getPreferStrict() {
        if (this.myPropertiesComponent == null) {
            return false;
        }
        String storedValue = this.myPropertiesComponent.getValue(JS_PREFER_STRICT_PROPERTY_NAME);
        return storedValue == null ? false : Boolean.valueOf(storedValue);
    }

    @Override
    public void storeOnlyTypeBasedCompletion(boolean onlyTypeBasedCompletion) {
        this.myPropertiesComponent.setValue(JS_WEAKER_COMPLETION_TYPE_GUESS_PROPERTY_NAME, Boolean.toString(!onlyTypeBasedCompletion));
    }

    @Override
    public boolean isOnlyTypeBasedCompletion() {
        if (this.myPropertiesComponent == null) {
            return false;
        }
        String storedValue = this.myPropertiesComponent.getValue(JS_WEAKER_COMPLETION_TYPE_GUESS_PROPERTY_NAME);
        return storedValue == null ? false : Boolean.valueOf(storedValue) == false;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    static class State {
        private JSLanguageLevel myLanguageLevel;

        State() {
        }

        public String getLanguageLevel() {
            return this.myLanguageLevel != null ? this.myLanguageLevel.getId() : null;
        }

        public void setLanguageLevel(String languageLevel) {
            if (languageLevel != null) {
                this.myLanguageLevel = JSLanguageLevel.ofId(languageLevel);
            }
        }
    }
}

