/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.lang.javascript.structureView.JSSuperGroup;
import com.intellij.psi.PsiElement;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class JSSuperGrouper
implements Grouper {
    @NonNls
    private static final String SHOW_CLASSES = "SHOW_CLASSES";

    JSSuperGrouper() {
    }

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode parent, @NotNull Collection<TreeElement> children) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/structureView/JSSuperGrouper", "group"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/structureView/JSSuperGrouper", "group"));
        }
        if (JSSuperGrouper.isParentGrouped(parent)) {
            List<Group> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSSuperGrouper", "group"));
            }
            return list;
        }
        THashMap groups = new THashMap();
        for (TreeElement _child : children) {
            JSQualifiedName ns;
            if (!(_child instanceof JSStructureViewElement)) continue;
            JSStructureViewElement child = (JSStructureViewElement)_child;
            PsiElement value = child.getValue();
            if (value instanceof JSVariable) {
                if (!child.isInherited()) continue;
                PsiElement parentElement = value.getParent();
                if (parentElement instanceof JSVarStatement) {
                    parentElement = parentElement.getParent();
                }
                if (parentElement instanceof JSClass) {
                    JSSuperGrouper.addGroup((Map<String, Group>)groups, _child, ((JSClass)parentElement).getQualifiedName());
                    continue;
                }
            }
            if (!(value instanceof JSElementBase) || value instanceof JSFunctionItem && JSSuperGrouper.processFunction((JSStructureViewElement)parent.getValue(), (Map<String, Group>)groups, _child, value) || !child.isInherited() || (ns = ((JSElementBase)value).getNamespace()) == null) continue;
            JSSuperGrouper.addGroup((Map<String, Group>)groups, _child, ns.getQualifiedName());
        }
        Collection<Group> collection = groups.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSSuperGrouper", "group"));
        }
        return collection;
    }

    private static boolean processFunction(JSStructureViewElement parentElement, Map<String, Group> groups, TreeElement _child, PsiElement value) {
        JSClass declaringClass;
        JSClass parentClass;
        PsiElement element = JSStructureViewElement.getPsiElement(parentElement);
        if (element instanceof JSClass && (parentClass = (JSClass)element) != (declaringClass = JSInheritanceUtil.findSomeDeclaringClass((JSFunction)value))) {
            JSSuperGrouper.addGroup(groups, _child, declaringClass.getQualifiedName());
            return true;
        }
        return false;
    }

    private static void addGroup(Map<String, Group> groups, TreeElement _child, String qName) {
        JSSuperGroup group = (JSSuperGroup)groups.get(qName);
        if (group == null) {
            group = new JSSuperGroup(qName);
            groups.put(qName, group);
        }
        group.addChild(_child);
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.group.methods.by.defining.type", (Object[])new Object[0]), null, AllIcons.General.ImplementingMethod);
        if (actionPresentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSSuperGrouper", "getPresentation"));
        }
        return actionPresentationData;
    }

    @NotNull
    public String getName() {
        if (SHOW_CLASSES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSSuperGrouper", "getName"));
        }
        return SHOW_CLASSES;
    }

    private static boolean isParentGrouped(AbstractTreeNode parent) {
        while (parent != null) {
            if (parent.getValue() instanceof JSSuperGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

