/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSWithTryCatchFinallySurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.try.catch.finally", (Object[])new Object[0]);
    }

    @Override
    @NonNls
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "try { } catch(e" + JSWithTryCatchFinallySurrounder.getExceptionVarTypeBasedOnContext(context) + ") { } finally { }";
    }

    protected static String getExceptionVarTypeBasedOnContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/surroundWith/JSWithTryCatchFinallySurrounder", "getExceptionVarTypeBasedOnContext"));
        }
        if (context.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return ":Error";
        }
        return "";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSTryStatement stmt = (JSTryStatement)statementNode.getPsi();
        return stmt.getStatement().getLastChild().getNode();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSTryStatement stmt = (JSTryStatement)statementNode.getPsi();
        JSCatchBlock catchBlock = stmt.getCatchBlock();
        if (catchBlock != null) {
            int offset = catchBlock.getStatement().getFirstChild().getNode().getStartOffset() + 1;
            return new TextRange(offset, offset);
        }
        JSStatement finallyStmt = stmt.getFinallyStatement();
        if (finallyStmt != null) {
            int offset = finallyStmt.getFirstChild().getNode().getStartOffset() + 1;
            return new TextRange(offset, offset);
        }
        return null;
    }
}

