/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.surroundWith.JSWithIfSurrounder;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.BoolUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPostfixTemplateUtils {
    public static Condition<PsiElement> DEFAULT_FILTER = new Condition<PsiElement>(){
        private Class[] FILTER_TYPES = new Class[]{TypeScriptImportStatement.class, ES6ImportDeclaration.class, TypeScriptEntityName.class, JSReferenceList.class, ES6ExportDeclaration.class};
        private Class[] STOP_TYPES = (Class[])ArrayUtil.append((Object[])this.FILTER_TYPES, JSStatement.class);

        public boolean value(PsiElement element) {
            PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])this.STOP_TYPES);
            if (parent == null) {
                return true;
            }
            for (Class aClass : this.FILTER_TYPES) {
                if (!aClass.isInstance(parent)) continue;
                return false;
            }
            return true;
        }
    };
    @NotNull
    public static final PostfixTemplatePsiInfo JS_PSI_INFO = new PostfixTemplatePsiInfo(){

        @NotNull
        public PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4", "createExpression"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4", "createExpression"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4", "createExpression"));
            }
            PsiElement psiElement = JSPostfixTemplateUtils.createExpression(context, prefix, suffix);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4", "createExpression"));
            }
            return psiElement;
        }

        @NotNull
        public PsiElement getNegatedExpression(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4", "getNegatedExpression"));
            }
            String negatedExpressionText = BoolUtils.getNegatedExpressionText((JSExpression)element);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)element.getProject());
            PsiElement psiElement = codeStyleManager.reformat(JSChangeUtil.createExpressionFromText(element.getProject(), negatedExpressionText, JSPostfixTemplateUtils.getDialect(element)).getPsi());
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4", "getNegatedExpression"));
            }
            return psiElement;
        }
    };

    public static String endTemplate(PsiElement element) {
        return JSCodeStyleSettings.getSemicolon(element.getContainingFile()) + "$END$";
    }

    public static PostfixTemplateExpressionSelector selectorTopmost() {
        return JSPostfixTemplateUtils.selectorTopmost(DEFAULT_FILTER);
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset() {
        return JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset(DEFAULT_FILTER);
    }

    public static PostfixTemplateExpressionSelector selectorTopmost(Condition<PsiElement> additionalFilter) {
        return new PostfixTemplateExpressionSelectorBase(additionalFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$2", "getNonFilteredExpressions"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$2", "getNonFilteredExpressions"));
                }
                JSExpressionStatement exprStatement = (JSExpressionStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSExpressionStatement.class});
                JSExpression statement = exprStatement != null ? (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)exprStatement, JSExpression.class) : null;
                return ContainerUtil.createMaybeSingletonList((Object)statement);
            }
        };
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset(Condition<PsiElement> additionalFilter) {
        return new PostfixTemplateExpressionSelectorBase(additionalFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int newOffset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$3", "getNonFilteredExpressions"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$3", "getNonFilteredExpressions"));
                }
                if (!DEFAULT_FILTER.value((Object)context)) {
                    return ContainerUtil.emptyList();
                }
                List<Pair<JSExpression, TextRange>> expressionsInRange = JSBaseIntroduceHandler.findExpressionsInRange(context.getContainingFile(), newOffset, newOffset);
                ArrayList result = ContainerUtil.newArrayList();
                if (expressionsInRange == null) {
                    return result;
                }
                for (Pair<JSExpression, TextRange> pair : expressionsInRange) {
                    result.add(pair.getFirst());
                }
                return result;
            }
        };
    }

    @NotNull
    public static Surrounder createIfSurrounder() {
        JSWithIfSurrounder jSWithIfSurrounder = new JSWithIfSurrounder(){

            @Override
            protected boolean willWrapExpression() {
                return false;
            }
        };
        if (jSWithIfSurrounder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils", "createIfSurrounder"));
        }
        return jSWithIfSurrounder;
    }

    @NotNull
    public static PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils", "createExpression"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils", "createExpression"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils", "createExpression"));
        }
        PsiElement psiElement = JSChangeUtil.createExpressionFromText(context.getProject(), prefix + context.getText() + suffix, JSPostfixTemplateUtils.getDialect(context)).getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils", "createExpression"));
        }
        return psiElement;
    }

    @Nullable
    private static JSLanguageDialect getDialect(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils", "getDialect"));
        }
        return DialectDetector.languageDialectOfElement(element);
    }
}

