/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.inspections.JSDuplicatedDeclarationInspection;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class DuplicatesCheckUtil {
    public static void checkDuplicates(JSNamedElement node, JSAnnotatorProblemReporter reporter) {
        String name = node.getName();
        if (name == null) {
            return;
        }
        ASTNode nameIdentifier = node.findNameIdentifier();
        DuplicatesCheckUtil.checkForDuplicateDeclaration(name, (PsiElement)node, nameIdentifier, reporter);
    }

    private static void checkForDuplicateDeclaration(@NotNull String name, final PsiElement decl, ASTNode nameIdentifier, JSAnnotatorProblemReporter reporter) {
        PsiElement result;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/validation/DuplicatesCheckUtil", "checkForDuplicateDeclaration"));
        }
        if (DialectDetector.isTypeScript(decl)) {
            return;
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)decl, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class, JSPackageStatement.class, PsiFile.class, TypeScriptType.class});
        if (scope instanceof JSPackageStatement) {
            return;
        }
        PsiElement originalScope = scope;
        if (scope instanceof JSFile && scope.getContext() != null) {
            scope = scope.getContext().getContainingFile();
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, scope, new ResolveResultSink(scope, name)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$1", "execute"));
                }
                if (element == decl) {
                    return true;
                }
                if (decl instanceof JSParameter && decl.getParent() != element.getParent()) {
                    return false;
                }
                if (element instanceof JSFunction && decl instanceof JSFunction) {
                    JSFunction declFunction = (JSFunction)decl;
                    JSFunction elementFunction = (JSFunction)element;
                    if (declFunction.isGetProperty() && elementFunction.isSetProperty() || declFunction.isSetProperty() && elementFunction.isGetProperty()) {
                        return true;
                    }
                } else if (element instanceof JSProperty && decl instanceof JSProperty) {
                    JSProperty elementProperty = (JSProperty)element;
                    JSProperty declProperty = (JSProperty)decl;
                    if (declProperty.isGetProperty() && elementProperty.isSetProperty() || declProperty.isSetProperty() && elementProperty.isGetProperty()) {
                        return true;
                    }
                }
                if (element instanceof JSFunction && decl instanceof JSClass && element.getParent() == decl) {
                    return true;
                }
                if (this.isScopeNamedElement(element) && this.isScopeNamedElement(decl)) {
                    boolean notStatic;
                    JSAttributeList attrList2;
                    JSAttributeList attrList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
                    JSAttributeList jSAttributeList = attrList2 = decl instanceof JSAttributeListOwner ? ((JSAttributeListOwner)decl).getAttributeList() : null;
                    if (attrList != null && attrList2 != null) {
                        String ns = JSResolveUtil.getNamespaceValue(attrList);
                        String ns2 = JSResolveUtil.getNamespaceValue(attrList2);
                        if (ns != null && !ns.equals(ns2) || ns2 != null && !ns2.equals(ns)) {
                            return true;
                        }
                        JSConditionalCompileVariableReference conditionalCompileVar = attrList.getConditionalCompileVariableReference();
                        JSConditionalCompileVariableReference conditionalCompileVar2 = attrList2.getConditionalCompileVariableReference();
                        if (conditionalCompileVar != null && conditionalCompileVar2 != null) {
                            JSReferenceExpression expression = conditionalCompileVar.getExpression();
                            JSReferenceExpression expression2 = conditionalCompileVar2.getExpression();
                            if (expression != null && expression2 != null && !expression.getText().equals(expression2.getText())) {
                                return true;
                            }
                        }
                    } else if (attrList != null && attrList.getNamespace() != null || attrList2 != null && attrList2.getNamespace() != null) {
                        return true;
                    }
                    boolean notStatic2 = attrList2 == null || !attrList2.hasModifier(JSAttributeList.ModifierType.STATIC);
                    boolean bl = notStatic = attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.STATIC);
                    if (notStatic2 && !notStatic || notStatic && !notStatic2) {
                        return true;
                    }
                }
                if (element instanceof ImplicitJSVariableImpl || element instanceof JSImplicitElement) {
                    return true;
                }
                if (element instanceof JSDefinitionExpression) {
                    return true;
                }
                return super.execute(element, state);
            }

            private boolean isScopeNamedElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$1", "isScopeNamedElement"));
                }
                return element instanceof JSAttributeListOwner || element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportedBinding;
            }

            @Override
            public void addPossibleCandidateResult(PsiElement element, String s) {
            }
        };
        processor.setSkipImplicitDeclarations(true);
        PsiElement parent = JSResolveUtil.findParent(decl);
        if (parent instanceof JSClass) {
            processor.configureClassScope((JSClass)parent);
        }
        PsiElement startFrom = decl;
        PsiElement lastParent = null;
        boolean eligibleForConflictingDeclarationCheck = false;
        if (decl instanceof JSFunction || decl instanceof JSVariable || decl instanceof JSNamespaceDeclaration) {
            JSAttributeList attrList = ((JSAttributeListOwner)decl).getAttributeList();
            processor.setProcessStatics(attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.STATIC));
            if (!(parent instanceof XmlBackedJSClass)) {
                lastParent = parent instanceof JSClass ? parent : parent.getFirstChild();
                startFrom = parent;
            }
            eligibleForConflictingDeclarationCheck = attrList != null && !attrList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && !attrList.hasModifier(JSAttributeList.ModifierType.STATIC);
        }
        processor.setLocalResolve(true);
        if (eligibleForConflictingDeclarationCheck) {
            JSClass clazzOfContext = JSResolveUtil.getClassOfContext(decl);
            if (clazzOfContext != null) {
                if (parent != clazzOfContext) {
                    processor.configureClassScope(clazzOfContext);
                }
                processor.setToProcessHierarchy(true);
            } else {
                eligibleForConflictingDeclarationCheck = false;
            }
        }
        if (!(decl instanceof JSFunctionExpression)) {
            JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, startFrom, scope);
        }
        if ((result = processor.getResult()) != null && result != scope && result.isValid()) {
            PsiElement resultParent = JSResolveUtil.findParent(result);
            boolean problemWithinScope = !eligibleForConflictingDeclarationCheck || scope == null || scope instanceof XmlFile && resultParent == JSResolveUtil.findParent(decl) || PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)scope.getFirstChild()) == scope;
            String message = "";
            if (!problemWithinScope) {
                String namespace = DuplicatesCheckUtil.getNs(result);
                if (decl instanceof JSFunction && result instanceof JSFunction && DuplicatesCheckUtil.getNs(decl).equals(DuplicatesCheckUtil.getNs(result))) {
                    message = null;
                } else if (resultParent instanceof JSClass) {
                    String qualifiedName = ((JSClass)resultParent).getQualifiedName();
                    message = !"Object".equals(qualifiedName) ? JSBundle.message((String)"javascript.validation.message.conflicting.definition.was.found.with.the.same.name", (Object[])new Object[]{qualifiedName + "." + name, namespace}) : null;
                }
            }
            if (message == "") {
                message = JSBundle.message((String)"javascript.validation.message.duplicate.declaration", (Object[])new Object[0]);
            }
            if (message != null) {
                reporter.registerProblem(nameIdentifier.getPsi(), message, DuplicatesCheckUtil.getHighlightTypeWhenDuplicateFound(originalScope, result, decl), JSDuplicatedDeclarationInspection.SHORT_NAME, new LocalQuickFix[0]);
            }
        }
    }

    private static String getNs(PsiElement result) {
        JSAttributeList attributeList;
        String namespace = "internal";
        if (result instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)result).getAttributeList()) != null) {
            String ns;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PUBLIC) {
                namespace = "public";
            } else if (accessType == JSAttributeList.AccessType.PROTECTED) {
                namespace = "protected";
            } else if (accessType == JSAttributeList.AccessType.PRIVATE) {
                namespace = "protected";
            } else if (accessType == JSAttributeList.AccessType.PACKAGE_LOCAL && (ns = JSResolveUtil.getNamespaceValue(attributeList)) != null) {
                namespace = ns;
            }
        }
        return namespace;
    }

    private static ProblemHighlightType getHighlightTypeWhenDuplicateFound(PsiElement originalScope, PsiElement result, PsiElement decl) {
        boolean unconditionalError;
        boolean bl = unconditionalError = originalScope.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (unconditionalError) {
            PsiElement declParent = JSResolveUtil.findParent(decl);
            PsiElement resultParent = JSResolveUtil.findParent(result);
            if (result instanceof JSParameter && !(decl instanceof JSParameter)) {
                unconditionalError = false;
            } else if (decl instanceof JSVariable && !(decl instanceof JSParameter) && result instanceof JSVariable && DuplicatesCheckUtil.isLocalVar(declParent) && DuplicatesCheckUtil.isLocalVar(resultParent)) {
                unconditionalError = false;
            }
        } else if ((result instanceof JSParameter && decl instanceof JSParameter || result instanceof JSProperty && decl instanceof JSProperty) && JSResolveUtil.isEcmaScript5(decl)) {
            unconditionalError = true;
        }
        return unconditionalError ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    private static boolean isLocalVar(PsiElement declParent) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)declParent, (Class[])new Class[]{JSFunction.class}) != null;
    }

    public static void checkDuplicatesForVariable(JSVariable var, JSAnnotatorProblemReporter reporter) {
        String name;
        ASTNode nameIdentifier = var.findNameIdentifier();
        ASTNode next = nameIdentifier != null ? nameIdentifier.getTreeNext() : null;
        String string = name = nameIdentifier != null ? nameIdentifier.getText() : null;
        if (name != null && (next == null || next.getElementType() instanceof JSElementType || next.getPsi() instanceof PsiWhiteSpace)) {
            DuplicatesCheckUtil.checkForDuplicateDeclaration(name, (PsiElement)var, nameIdentifier, reporter);
        }
    }
}

