/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.inspections.JSFileReferencesInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedFunctionInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedVariableInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayComprehension;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLetStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.ES7Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.AnalysisUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.lang.javascript.validation.fixes.ReplacePsiElementFix;
import com.intellij.lang.javascript.validation.fixes.SetElementVisibilityFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSAnnotatingVisitor
extends JSElementVisitor
implements Annotator {
    private static final String OCTAL_SEQUENCE_START = "\\0";
    private static final String EVAL_FUNCTION_NAME = "eval";
    public static final String VOID_TYPE_NAME = "void";
    @NotNull
    protected AnnotationHolder myHolder;
    @NotNull
    protected JSHighlighter myHighlighter;
    @NotNull
    protected JSFunctionSignatureChecker myFunctionSignatureChecker;
    @NotNull
    protected JSTypeChecker<Annotation> myTypeChecker;
    @NotNull
    protected JSAnnotatorProblemReporter myProblemReporter;

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "annotate"));
        }
        try {
            assert (this.myHolder == null);
            this.myHolder = holder;
            this.myHighlighter = this.getHighlighter(psiElement);
            assert (this.myHighlighter != null);
            this.initTypeCheckers(psiElement);
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
            this.myHighlighter = null;
        }
    }

    protected JSHighlighter getHighlighter(PsiElement psiElement) {
        Language dialect = DialectDetector.languageOfElement(psiElement);
        return dialect instanceof JSLanguageDialect ? (JSHighlighter)SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null) : new JSHighlighter(JavascriptLanguage.DIALECT_OPTION_HOLDER);
    }

    protected void initTypeCheckers(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "initTypeCheckers"));
        }
        this.myProblemReporter = new JSAnnotatorProblemReporter(this.myHolder);
        this.myTypeChecker = new JSTypeChecker<Annotation>(){

            @Override
            public Annotation registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                return JSAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, highlightType, this.getValidateTypesInspectionId(), fixes);
            }
        };
        this.myFunctionSignatureChecker = new JSFunctionSignatureChecker(this.myTypeChecker){

            @Override
            protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
                PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
                JSAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JSCheckFunctionSignaturesInspection.SHORT_NAME, fixes);
            }
        };
    }

    public void visitComment(PsiComment comment) {
        if (comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && DialectDetector.isTypeScript(comment.getParent())) {
            this.checkReferences((PsiElement)comment, this.getImportCheckInspectionId());
            JSFixFactory.getInstance().typeScriptReferencePathValidator().checkReferences(comment, this.myHolder);
        }
        super.visitComment(comment);
    }

    public void visitJSLiteralExpression(JSLiteralExpression node) {
        block8: {
            String text;
            block6: {
                block9: {
                    block7: {
                        this.checkReferences((PsiElement)node);
                        if (!node.isOctalLiteral()) break block6;
                        if (!DialectDetector.isES6((PsiElement)node)) break block7;
                        String nodeText = node.getText();
                        if (!StringUtil.isEmpty((String)nodeText) && !JSLiteralExpressionImpl.textHasOctalES6Prefix(nodeText)) {
                            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.octal.literals.are.not.allowed.es6.message", (Object[])new Object[0]));
                        }
                        break block8;
                    }
                    if (!DialectDetector.isJavaScript((PsiElement)node)) break block8;
                    String nodeText = node.getText();
                    if (StringUtil.isEmpty((String)nodeText) || !JSLiteralExpressionImpl.textHasOctalES6Prefix(nodeText)) break block9;
                    this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
                    break block8;
                }
                if (!JSResolveUtil.isEcmaScript5((PsiElement)node)) break block8;
                this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.octal.literals.are.not.allowed.in.strict.mode", (Object[])new Object[0]));
                break block8;
            }
            if (node.isBinaryLiteral()) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
            } else if (node.isQuotedLiteral() && node.textContains('0') && JSResolveUtil.isEcmaScript5((PsiElement)node) && (text = node.getText()).contains(OCTAL_SEQUENCE_START)) {
                IElementType tokenType;
                StringLiteralLexer literalLexer = new StringLiteralLexer(text.charAt(0), node.getNode().getFirstChildNode().getElementType(), true, "/v", true, true);
                literalLexer.start((CharSequence)text);
                int literalStart = node.getTextOffset();
                while ((tokenType = literalLexer.getTokenType()) != null) {
                    int end;
                    int start;
                    if ((tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) && CharArrayUtil.indexOf((CharSequence)text, (CharSequence)OCTAL_SEQUENCE_START, (int)(start = literalLexer.getTokenStart()), (int)(end = literalLexer.getTokenEnd())) == start && end - start > 2) {
                        TextRange errorRange = new TextRange(literalStart + start, literalStart + end);
                        this.myHolder.createErrorAnnotation(errorRange, JSBundle.message((String)"javascript.octal.sequences.are.not.allowed.message", (Object[])new Object[0]));
                    }
                    literalLexer.advance();
                }
            }
        }
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSType type;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getUnresolvedReferenceHighlightType"));
        }
        JSExpression qualifier = node.getQualifier();
        if (qualifier == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        if (qualifier != null && (type = JSResolveUtil.getExpressionJSType(qualifier)) != null && JSTypeUtils.isMapType(type)) {
            return null;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getHighlightTypeForTypeOrSignatureProblem"));
        }
        return ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem(node);
    }

    protected boolean checkReferences(PsiElement element) {
        return this.checkReferences(element, null);
    }

    private boolean checkReferences(PsiElement element, @Nullable String inspectionId) {
        if (element instanceof JSXmlLiteralExpressionImpl) {
            return true;
        }
        boolean ok = true;
        for (PsiReference ref : element.getReferences()) {
            if (ref.isSoft() || ref instanceof FileReference && JSFileReferencesInspection.acceptsReference((FileReference)ref)) continue;
            if (ref instanceof PsiPolyVariantReference) {
                ResolveResult result;
                ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
                if (results.length == 0) {
                    ok = false;
                    this.registerProblemForReference(ref, inspectionId, null);
                } else if (results.length == 1 && !(result = results[0]).isValidResult()) {
                    String key;
                    ok = false;
                    String message = null;
                    if (result instanceof JSResolveResult && (key = ((JSResolveResult)result).getResolveProblemKey()) != null) {
                        message = JSBundle.message((String)key, (Object[])new Object[0]);
                    }
                    this.registerProblemForReference(ref, inspectionId, message);
                }
            } else if (ref.resolve() == null) {
                ok = false;
                this.registerProblemForReference(ref, inspectionId, null);
            }
            if (DialectDetector.isTypeScript(element) && !ok) break;
        }
        return ok;
    }

    protected void registerProblemForReference(@NotNull PsiReference ref, String inspectionId, @Nullable String unresolvedMessage) {
        LocalQuickFix[] fixes;
        String message;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "registerProblemForReference"));
        }
        TextRange range = JSAnnotatingVisitor.calcRangeForReferences(ref);
        String string = message = unresolvedMessage != null ? unresolvedMessage : XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
        if (inspectionId != null) {
            LocalQuickFix[] fixes2 = ref instanceof LocalQuickFixProvider ? ((LocalQuickFixProvider)ref).getQuickFixes() : null;
            this.myProblemReporter.registerProblem(ref.getElement(), range, message, ProblemHighlightType.WEAK_WARNING, inspectionId, fixes2, IntentionAction.EMPTY_ARRAY);
            return;
        }
        HighlightSeverity severity = ref instanceof HighlightSeverityHolder ? ((HighlightSeverityHolder)ref).getUnresolvedReferenceSeverity() : HighlightSeverity.ERROR;
        Annotation annotation = this.myHolder.createAnnotation(severity, range, message);
        if (ref instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)ref).getQuickFixes()) != null) {
            for (LocalQuickFix fix : fixes) {
                if (!(fix instanceof IntentionAction)) continue;
                annotation.registerFix((IntentionAction)fix, TextRange.create((Segment)annotation));
            }
        }
    }

    protected static TextRange calcRangeForReferences(PsiReference ref) {
        TextRange elementRange = ref.getElement().getTextRange();
        TextRange textRange = ref.getRangeInElement();
        return new TextRange(elementRange.getStartOffset() + textRange.getStartOffset(), elementRange.getStartOffset() + textRange.getEndOffset());
    }

    public void visitJSCallExpression(JSCallExpression node) {
        PsiElement arrayInitializingType;
        JSExpression methodExpression = node.getMethodExpression();
        boolean inNewExpression = node instanceof JSNewExpression;
        if (methodExpression instanceof JSParenthesizedExpression) {
            methodExpression = JSUtils.unparenthesize(methodExpression);
        }
        if (methodExpression instanceof JSLiteralExpression) {
            this.myHolder.createErrorAnnotation((PsiElement)methodExpression, JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
        } else if (methodExpression instanceof JSReferenceExpression) {
            PsiElement element;
            this.checkCallReferences(node, (JSReferenceExpression)methodExpression);
            JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
            ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
            boolean hasValidResolveResult = false;
            boolean hasCallableElement = false;
            for (ResolveResult r : resolveResults) {
                JSType jsType;
                if (!r.isValidResult()) continue;
                hasValidResolveResult = true;
                PsiElement element2 = r.getElement();
                if (!this.processMethodExpressionResolveResult(node, referenceExpression, element2, jsType = JSTypeUtils.getTypeOfElement(element2))) {
                    return;
                }
                if (jsType != null && jsType.getSource().isExplicitlyDeclared() && !this.myFunctionSignatureChecker.isCallableType(inNewExpression, jsType) && (element2 == null || JSPsiImplUtils.calculatePossibleFunction(element2) == null)) continue;
                hasCallableElement = true;
                break;
            }
            if (hasValidResolveResult && !hasCallableElement) {
                PsiElement function;
                boolean isProperty;
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                JSArgumentList argumentList = node.getArgumentList();
                boolean bl = isProperty = resolveResults.length == 1 && (function = resolveResults[0].getElement()) instanceof JSFunction && ((JSFunction)function).isGetProperty();
                if (argumentList != null && isProperty) {
                    fixes = new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.term.does.not.evaluate.to.function2.fix", argumentList.getNode())};
                }
                this.myTypeChecker.registerProblem(referenceExpression.getReferenceNameElement(), JSBundle.message((String)(isProperty ? "javascript.term.does.not.evaluate.to.function2" : "javascript.term.does.not.evaluate.to.function"), (Object[])new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), fixes);
                return;
            }
            if (resolveResults.length == 1 && hasValidResolveResult && (element = resolveResults[0].getElement()) != null) {
                this.myFunctionSignatureChecker.checkFunction(node, element);
            }
        } else if (methodExpression instanceof JSNewExpression) {
            this.checkNewExpressionInsideCallReferences(methodExpression);
        } else if (methodExpression instanceof JSSuperExpression) {
            PsiElement element;
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
            if (fun == null || !fun.isConstructor()) {
                this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.super.constructor.call.should.be.in.constructor", (Object[])new Object[0]));
                return;
            }
            PsiReference psiReference = methodExpression.getReference();
            PsiElement psiElement = element = psiReference != null ? psiReference.resolve() : null;
            if (element != null) {
                this.myFunctionSignatureChecker.checkFunction(node, element);
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            this.myFunctionSignatureChecker.checkFunction(node, (PsiElement)methodExpression);
        } else if (methodExpression instanceof JSArrayLiteralExpression && inNewExpression && (arrayInitializingType = ((JSNewExpression)node).getArrayInitializingType()) != null) {
            String typeName = JSImportHandlingUtil.resolveTypeName(arrayInitializingType.getText(), (PsiElement)node);
            for (JSExpression expr : ((JSArrayLiteralExpression)methodExpression).getExpressions()) {
                if (expr == null) continue;
                this.myTypeChecker.checkExpressionIsAssignableToType(expr, typeName, "javascript.vector.literal.element.type.mismatch", null);
            }
        }
    }

    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return true;
    }

    private void checkNewExpressionInsideCallReferences(JSExpression methodExpression) {
        PsiElement elt;
        ResolveResult[] results;
        JSExpression methodExpr = ((JSNewExpression)methodExpression).getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression && (results = ((JSReferenceExpression)methodExpr).multiResolve(false)).length > 0 && ((elt = results[0].getElement()) instanceof JSFunction && ((JSFunction)elt).isConstructor() || elt instanceof JSClass)) {
            this.reportUnresolvedFunctionError((PsiElement)methodExpression, this.getUnresolvedReferenceHighlightType((JSReferenceExpression)methodExpr), JSBundle.message((String)"javascript.term.does.not.evaluate.to.function", (Object[])new Object[0]), null);
        }
    }

    protected void checkCallReferences(JSCallExpression node, JSReferenceExpression referenceExpression) {
        JSElement expression;
        ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
        boolean noCompleteResolve = true;
        boolean inNewExpression = node instanceof JSNewExpression;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            noCompleteResolve = false;
            if (this.processExpressionResolveResult((JSExpression)referenceExpression, r.getElement())) break;
        }
        if (resolveResults.length == 0 || noCompleteResolve) {
            PsiElement refElementName;
            boolean canCreateFromUsage;
            JSExpression qualifier = referenceExpression.getQualifier();
            LinkedList<LocalQuickFix> quickFixes = new LinkedList<LocalQuickFix>();
            String refName = referenceExpression.getReferencedName();
            DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
            boolean simpleJs = dialect != null && dialect.isJavaScript();
            ProblemHighlightType unresolvedRefHighlightType = this.getUnresolvedReferenceHighlightType(referenceExpression);
            boolean reportProblem = unresolvedRefHighlightType != null && (dialect == null || !dialect.isECMA4 || unresolvedRefHighlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            boolean bl = canCreateFromUsage = JSAnnotatingVisitor.canHaveCreateFromUsage(qualifier) && (simpleJs || JSAnnotatingVisitor.findInsufficientVisibilityResult(resolveResults) == null);
            if (reportProblem && canCreateFromUsage && referenceExpression.getParent() instanceof JSCallExpression) {
                this.addCreateFromUsageFixesForCall(node, referenceExpression, resolveResults, quickFixes);
            }
            if (reportProblem && (refElementName = referenceExpression.getReferenceNameElement()) != null) {
                String message = null;
                boolean jsSymbolNotAccessible = false;
                if (resolveResults.length > 0 && resolveResults[0] instanceof JSResolveResult) {
                    JSAnnotatingVisitor.addEscalateVisibilityFix(resolveResults, referenceExpression, quickFixes);
                    String resolveProblemKey = ((JSResolveResult)resolveResults[0]).getResolveProblemKey();
                    jsSymbolNotAccessible = resolveProblemKey == "javascript.jsdoc.private.member.is.not.accessible.message" || resolveProblemKey == "javascript.jsdoc.protected.member.is.not.accessible.message";
                    message = resolveProblemKey != null ? JSBundle.message((String)resolveProblemKey, (Object[])new Object[0]) : null;
                    PsiElement element = resolveResults[0].getElement();
                    if (jsSymbolNotAccessible && element instanceof JSQualifiedNamedElement) {
                        JSAttributeList.AccessType newVisibility = JSVisibilityUtil.getEscalatedJSDocVisibility((JSQualifiedNamedElement)element, (PsiElement)referenceExpression);
                        quickFixes.add((LocalQuickFix)new JSAccessibilityCheckInspection.SetJSDocElementVisibilityFix(element, newVisibility));
                    }
                    if (resolveProblemKey == "javascript.element.need.to.be.included.to.config") {
                        quickFixes.addAll(JSFixFactory.getInstance().typeScriptConfigFixes(referenceExpression, element));
                    }
                }
                if (message == null) {
                    message = JSBundle.message((String)(inNewExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.function.name.message"), (Object[])new Object[]{refName});
                }
                if (jsSymbolNotAccessible) {
                    this.reportAccessibilityError(refElementName, null, message, quickFixes);
                } else {
                    this.reportUnresolvedFunctionError(refElementName, unresolvedRefHighlightType, message, quickFixes);
                }
            }
        } else if (resolveResults.length == 1 && resolveResults[0].getElement() instanceof JSVariable && referenceExpression.getQualifier() == null && ((expression = JSSymbolUtil.calcRefExprValue(referenceExpression)) instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression)) {
            this.reportUnresolvedFunctionError(referenceExpression.getReferenceNameElement(), ProblemHighlightType.ERROR, JSBundle.message((String)"javascript.invalid.invokation.target", (Object[])new Object[0]), null);
        }
    }

    protected void addCreateFromUsageFixesForCall(JSCallExpression node, JSReferenceExpression referenceExpression, ResolveResult[] resolveResults, List<LocalQuickFix> quickFixes) {
        boolean inNewExpression = node instanceof JSNewExpression;
        String refName = referenceExpression.getReferencedName();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
        boolean simpleJs = dialect != null && dialect.isJavaScript();
        JSExpression qualifier = referenceExpression.getQualifier();
        if (!inNewExpression || dialect != null && !dialect.isECMA4 && !dialect.isTypeScript) {
            quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true));
        }
        if (qualifier == null) {
            if (simpleJs) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false));
            } else if (inNewExpression) {
                quickFixes.add(this.createClassOrInterfaceFix(referenceExpression, false, node.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node)));
            }
        } else if (inNewExpression && AnalysisUtils.isLHSExpression(qualifier)) {
            quickFixes.add(this.createClassOrInterfaceFix(referenceExpression, false, node.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node)));
        }
        quickFixes.add(this.renameReferenceFix());
    }

    private LocalQuickFix createClassOrInterfaceFix(JSReferenceExpression referenceExpression, boolean isInterface, JSArgumentList argumentList, JSType expectedType) {
        return JSFixFactory.getInstance().createClassOrInterfaceFix(referenceExpression, isInterface, argumentList, expectedType);
    }

    private LocalQuickFix renameReferenceFix() {
        return JSFixFactory.getInstance().renameReferenceFix();
    }

    protected Annotation reportUnresolvedRefProblem(@Nullable ProblemHighlightType unresolveReferenceHighlightType, @Nullable List<LocalQuickFix> quickFixes, @NotNull PsiElement referenceNameElement, @NotNull String message, @Nullable String inspectionId) {
        if (referenceNameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceNameElement", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        return this.myProblemReporter.registerProblem(referenceNameElement, message, unresolveReferenceHighlightType, inspectionId, quickFixes != null && !quickFixes.isEmpty() ? quickFixes.toArray(new LocalQuickFix[quickFixes.size()]) : null);
    }

    public void visitJSArrayComprehension(JSArrayComprehension arrayComprehension) {
        this.checkElementInCurrentLanguageLevel((PsiElement)arrayComprehension, JSLanguageFeature.ARRAY_COMPREHENSIONS);
    }

    public void visitJSYieldExpression(JSYieldExpression expression) {
        if (!(expression.getExpression() instanceof JSParenthesizedExpression)) {
            this.checkElementInCurrentLanguageLevel((PsiElement)expression, JSLanguageFeature.YIELD_GENERATORS);
        }
    }

    public void visitJSBindExpression(JSExpression bindExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)bindExpression, JSLanguageFeature.BIND_EXPRESSIONS);
    }

    private boolean checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @NotNull JSLanguageFeature languageFeature) {
        JSLanguageLevel currentLevel;
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkElementInCurrentLanguageLevel"));
        }
        if (languageFeature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageFeature", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkElementInCurrentLanguageLevel"));
        }
        if (this.myHolder.getCurrentAnnotationSession().getFile().getFileType() == JavaScriptSupportLoader.JAVASCRIPT && !(currentLevel = JSRootConfiguration.getInstance(elementToHighlight.getProject()).getLanguageLevel()).getDialect().getOptionHolder().hasFeature(languageFeature)) {
            String message = JSBundle.message((String)"javascript.parser.message.are.not.supported.by.dialect", (Object[])new Object[]{languageFeature});
            ArrayList<ChangeLanguageLevelFix> fixes = new ArrayList<ChangeLanguageLevelFix>(2);
            JSLanguageLevel proposedLevel = ChangeLanguageLevelFix.defineMinimalLanguageLevel(languageFeature, currentLevel);
            if (proposedLevel != null) {
                fixes.add(new ChangeLanguageLevelFix(proposedLevel));
            }
            if (DialectOptionHolder.ECMA_6.hasFeature(languageFeature)) {
                fixes.add(new ChangeLanguageLevelFix(JSLanguageLevel.ES6));
            }
            this.myProblemReporter.registerProblem(elementToHighlight, message, ProblemHighlightType.GENERIC_ERROR, (IntentionAction[])ContainerUtil.toArray(fixes, (Object[])new IntentionAction[fixes.size()]));
            return false;
        }
        return true;
    }

    public void visitJSLetStatement(JSLetStatement statement) {
        this.checkElementInCurrentLanguageLevel((PsiElement)statement, JSLanguageFeature.LET_SCOPE);
    }

    public void visitJSVarStatement(JSVarStatement node) {
        ASTNode let = node.getNode().findChildByType(JSTokenTypes.LET_KEYWORD);
        if (let != null) {
            this.checkElementInCurrentLanguageLevel(let.getPsi(), JSLanguageFeature.LET_DEFINITIONS);
        }
    }

    public void visitJSDestructuringContainer(JSDestructuringContainer destructuringContainer) {
        this.checkElementInCurrentLanguageLevel((PsiElement)destructuringContainer, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
    }

    public void visitJSExpressionStatement(JSExpressionStatement node) {
        PsiElement prevSibling = node.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof JSSourceElement) {
            JSFunction function;
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)node);
            if (prev instanceof PsiWhiteSpace) {
                prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
            }
            if (prev instanceof PsiErrorElement && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)prev, JSFunction.class)) != null && function.getBody().length == 0) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPRESSION_CLOSURES);
            }
        }
        super.visitJSExpressionStatement(node);
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression generatorExpression) {
        ASTNode eachKeyword = generatorExpression.getNode().findChildByType(JSTokenTypes.EACH_KEYWORD);
        if (eachKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(eachKeyword, this.myHolder);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)generatorExpression, JSLanguageFeature.GENERATOR_EXPRESSIONS);
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
        PsiElement parent = node.getParent();
        boolean doCheckForReferencingUnallowedMembers = false;
        if (parent instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)parent;
            ASTNode nameIdentifier = namedElement.findNameIdentifier();
            if (nameIdentifier != null && nameIdentifier.getPsi() == node) {
                if (parent instanceof JSFunction) {
                    JSFunction function = (JSFunction)parent;
                    String funName = function.getName();
                    if ((EVAL_FUNCTION_NAME.equals(funName) || "arguments".equals(funName)) && JSResolveUtil.isEcmaScript5((PsiElement)function)) {
                        this.myHolder.createErrorAnnotation(nameIdentifier, JSBundle.message((String)"javascript.validation.message.redefining.is.not.allowed", (Object[])new Object[]{funName}));
                    }
                    PsiElement functionParent = JSResolveUtil.findParent((PsiElement)function);
                    if (!(function instanceof JSFunctionExpression || functionParent instanceof JSFile || functionParent instanceof JSEmbeddedContent || functionParent instanceof JSClass || functionParent instanceof TypeScriptModule || functionParent instanceof JSBlockStatement && functionParent.getParent() instanceof JSFunction || !JSResolveUtil.isEcmaScript5((PsiElement)function))) {
                        this.myHolder.createErrorAnnotation(nameIdentifier, JSBundle.message((String)"javascript.validation.message.es5.function.declarations.allowed.on.top.level.or.function", (Object[])new Object[0]));
                    }
                    if (!(function instanceof JSFunctionExpression) || !(function.getParent() instanceof JSProperty)) {
                        this.checkFunction(function);
                    }
                    if (function.isConstructor()) {
                        if (functionParent instanceof JSClass) {
                            JSClass clazz = (JSClass)functionParent;
                            this.checkMissedSuperCall(node, function, clazz);
                        }
                    } else if (function.isSetProperty()) {
                        JSParameter[] params;
                        this.checkSetterReturnType(nameIdentifier, function);
                        JSParameterList parameterList = function.getParameterList();
                        JSParameter[] jSParameterArray = params = parameterList != null ? parameterList.getParameters() : JSParameter.EMPTY_ARRAY;
                        if (params.length != 1) {
                            this.myHolder.createErrorAnnotation((PsiElement)(parameterList != null ? parameterList : nameIdentifier.getPsi()), JSBundle.message((String)"javascript.validation.message.set.method.should.have.one.parameter", (Object[])new Object[0]));
                        } else {
                            JSFunction getter;
                            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
                            if (element instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element) && (getter = ((JSClass)element).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                                JSType retType = getter.getReturnType();
                                JSType setterType = params[0].getType();
                                this.checkGetterAndSetterTypeMatch(function, getter, params[0], setterType, retType);
                            }
                            if (params[0].hasInitializer()) {
                                ASTNode n = params[0].getInitializer().getNode();
                                ASTNode first = params[0].getNode().findChildByType(JSTokenTypes.EQ);
                                if (first != null) {
                                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.setter.parameter.initializer", false, first, n);
                                    this.myHolder.createErrorAnnotation(n, JSBundle.message((String)"javascript.validation.message.setter.parameter.cannot.have.initializer", (Object[])new Object[0])).registerFix((IntentionAction)fix);
                                }
                            }
                        }
                    } else if (function.isGetProperty()) {
                        JSParameter[] parameters;
                        JSType type = function.getReturnType();
                        this.validateGetPropertyReturnType(nameIdentifier, function, type);
                        JSParameterList parameterList = function.getParameterList();
                        if (parameterList != null && (parameters = parameterList.getParameters()).length != 0) {
                            String key = parameters.length > 1 ? "javascript.fix.remove.parameters" : "javascript.fix.remove.parameter";
                            this.myHolder.createErrorAnnotation((PsiElement)parameterList, JSBundle.message((String)"javascript.validation.message.get.method.should.have.no.parameter", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix(key, false, parameters[0].getNode(), parameters[parameters.length - 1].getNode()));
                        }
                    }
                    if ((function.isGetProperty() || function.isSetProperty()) && !(functionParent instanceof JSProperty) && PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class, (boolean)true, (Class[])new Class[]{JSClass.class}) != null) {
                        this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.accessor.could.not.be.nested.under.other.function", (Object[])new Object[0]));
                    }
                } else if (parent instanceof JSVariable) {
                    DuplicatesCheckUtil.checkDuplicatesForVariable((JSVariable)parent, this.myProblemReporter);
                }
            } else if (parent instanceof JSDefinitionExpression) {
                doCheckForReferencingUnallowedMembers = true;
            }
        } else {
            doCheckForReferencingUnallowedMembers = true;
        }
        if (doCheckForReferencingUnallowedMembers) {
            String referencedName = node.getReferenceName();
            PsiElement referenceNameElement = node.getReferenceNameElement();
            assert (referencedName == null || referenceNameElement != null) : referencedName;
            if (("caller".equals(referencedName) || "callee".equals(referencedName)) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                PsiElement resolve;
                JSExpression qualifier = node.getQualifier();
                if (qualifier instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) instanceof ImplicitJSVariableImpl || resolve instanceof JSFunction)) {
                    this.myHolder.createErrorAnnotation(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.arguments.caller.callee.is.not.allowed", (Object[])new Object[0]));
                }
            } else if ("arguments".equals(referencedName) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (node.getQualifier() != null) {
                    JSType type = JSResolveUtil.getExpressionJSType(node.getQualifier());
                    if (type != null && !(type instanceof JSAnyType) && JSTypeUtils.hasFunctionType(type)) {
                        this.myHolder.createErrorAnnotation(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.function.arguments.property.is.not.allowed", (Object[])new Object[0]));
                    } else if (type != null && !type.getSource().isExplicitlyDeclared()) {
                        this.myHolder.createWarningAnnotation(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.function.arguments.property.is.not.allowed", (Object[])new Object[0]));
                    }
                } else if (parent instanceof JSDefinitionExpression) {
                    this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.arguments.is.readonly", (Object[])new Object[0]));
                }
            } else if (EVAL_FUNCTION_NAME.equals(referencedName) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (!JSAnnotatingVisitor.isEvalAllowed(node)) {
                    this.myHolder.createErrorAnnotation(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.eval.outside.call.is.not.allowed", (Object[])new Object[0]));
                }
            } else if (referenceNameElement != null && JSKeywordSets.JS_STRICT_KEYWORDS.contains(referenceNameElement.getNode().getElementType()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                this.myHolder.createErrorAnnotation(referenceNameElement, JSBundle.message((String)"javascript.validation.message.identifier.not.allowed.in.strict.mode", (Object[])new Object[]{node.getReferenceName()}));
            }
        }
        boolean checkRefExpr = true;
        if (node.getQualifier() == null) {
            String nodeText = node.getText();
            if (!(parent instanceof JSCallExpression) && "arguments".equals(nodeText)) {
                JSParameterList parameterList;
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                if (fun == null) {
                    if (PsiTreeUtil.getParentOfType((PsiElement)node, XmlAttributeValue.class) == null) {
                        if (node.multiResolve(false).length == 0) {
                            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.arguments.out.of.function", (Object[])new Object[0]));
                        }
                    } else {
                        checkRefExpr = false;
                    }
                } else if (node.resolve() instanceof ImplicitJSVariableImpl && (parameterList = fun.getParameterList()) != null) {
                    for (JSParameter p : parameterList.getParameters()) {
                        if (!p.isRest() || p.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) == null || !DialectDetector.isActionScript((PsiElement)parameterList)) continue;
                        this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.arguments.with.rest.parameter", (Object[])new Object[0]));
                    }
                }
            }
        }
        if (checkRefExpr) {
            this.checkRefExpression(node);
        }
    }

    protected void checkSetterReturnType(ASTNode nameIdentifier, JSFunction function) {
        JSType type = function.getReturnType();
        if (type != null && !(type instanceof JSVoidType)) {
            PsiElement returnTypeElement = function.getReturnTypeElement();
            this.myHolder.createErrorAnnotation(returnTypeElement != null ? returnTypeElement : nameIdentifier.getPsi(), JSBundle.message((String)"javascript.validation.message.set.method.should.be.void.or.without.type", (Object[])new Object[0]));
        }
    }

    protected void checkGetterAndSetterTypeMatch(JSFunction setter, JSFunction getter, JSParameter param, JSType setterType, JSType retType) {
        if (!(setterType instanceof JSAnyType || retType instanceof JSAnyType || JSTypeUtils.areTypesCompatible(setterType, retType, null, (PsiElement)setter))) {
            PsiElement typeElement = param.getTypeElement();
            this.myProblemReporter.registerGenericError((PsiElement)(typeElement != null ? typeElement : param), JSBundle.message((String)"javascript.validation.message.set.method.type.is.different.from.getter", (Object[])new Object[]{retType != null ? retType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}), new IntentionAction[0]);
        }
        this.checkAccessorAccessTypeMatch(setter, getter, "javascript.validation.message.set.method.access.type.is.different.from.getter");
    }

    protected void validateGetPropertyReturnType(ASTNode nameIdentifier, JSFunction function, JSType type) {
    }

    private static boolean isEvalAllowed(JSReferenceExpression node) {
        JSDefinitionExpression definitionExpression = (JSDefinitionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, JSDefinitionExpression.class);
        if (definitionExpression != null && node.getQualifier() != null) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSCallExpression.class, JSStatement.class}) instanceof JSCallExpression;
    }

    protected static boolean isBindable(JSClass clazz) {
        if (clazz instanceof XmlBackedJSClass) {
            return true;
        }
        JSAttributeList attributeList = clazz.getAttributeList();
        return attributeList != null && attributeList.getAttributesByName("Bindable").length > 0;
    }

    protected void checkAccessorAccessTypeMatch(JSFunction function, JSFunction getter, String s) {
        JSAttributeList getterAttrList = getter.getAttributeList();
        JSAttributeList attributeList = function.getAttributeList();
        if (JSAnnotatingVisitor.differentAccessType(attributeList, getterAttrList)) {
            PsiElement typeElement = attributeList != null ? attributeList.findAccessTypeElement() : null;
            Annotation errorAnnotation = this.myHolder.createErrorAnnotation(typeElement != null ? typeElement : function.findNameIdentifier().getPsi(), JSBundle.message((String)s, (Object[])new Object[]{JSFormatUtil.formatVisibility(getterAttrList.getAccessType())}));
            errorAnnotation.registerFix((IntentionAction)new SetElementVisibilityFix((JSAttributeListOwner)function, getterAttrList.getAccessType()));
            errorAnnotation.registerFix((IntentionAction)new SetElementVisibilityFix((JSAttributeListOwner)getter, attributeList.getAccessType()));
        }
    }

    private static boolean differentAccessType(JSAttributeList attributeList, JSAttributeList setterAttrList) {
        if (attributeList != null && setterAttrList != null) {
            JSAttributeList.AccessType setterAccessType;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType != (setterAccessType = setterAttrList.getAccessType())) {
                return (accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNamespaceElement() == null) && (setterAccessType != JSAttributeList.AccessType.PACKAGE_LOCAL || setterAttrList.getNamespaceElement() == null);
            }
            return false;
        }
        return attributeList != setterAttrList;
    }

    protected void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkRefExpression"));
        }
        if (!node.shouldCheckReferences() || node.getParent() instanceof JSCallExpression) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        boolean emptyResolve = resolveResults.length == 0;
        boolean noCompleteResolve = true;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            noCompleteResolve = false;
            if (this.processExpressionResolveResult((JSExpression)node, r.getElement())) break;
        }
        if (emptyResolve || noCompleteResolve) {
            this.registerQuickFixesForUnresolvedRef(node, resolveResults);
        } else if (!JSResolveUtil.isSelfReference((PsiElement)node)) {
            ReadWriteAccessDetector.Access expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node);
            boolean hasConstProblem = false;
            if (expressionAccess != ReadWriteAccessDetector.Access.Read) {
                hasConstProblem = this.checkAssignmentToConst(node);
            }
            if (!hasConstProblem && expressionAccess == ReadWriteAccessDetector.Access.ReadWrite) {
                boolean seenRead = false;
                boolean seenWrite = false;
                for (ResolveResult r : resolveResults) {
                    PsiElement element = r.getElement();
                    if (element instanceof JSFunction && ((JSFunction)element).isGetProperty() || element instanceof JSProperty && ((JSProperty)element).isGetProperty()) {
                        seenRead = true;
                        continue;
                    }
                    if (element instanceof JSFunction && ((JSFunction)element).isSetProperty() || element instanceof JSProperty && ((JSProperty)element).isSetProperty()) {
                        seenWrite = true;
                        continue;
                    }
                    if (!(element instanceof JSProperty) && !(element instanceof JSVariable) && !(element instanceof JSDefinitionExpression)) continue;
                    seenWrite = true;
                    seenRead = true;
                    break;
                }
                if (seenRead || seenWrite) {
                    if (!seenRead) {
                        this.reportUnresolvedFunctionError(node.getReferenceNameElement(), null, JSBundle.message((String)"javascript.missing.read.property", (Object[])new Object[0]), null);
                    }
                    if (!seenWrite) {
                        this.reportUnresolvedFunctionError(node.getReferenceNameElement(), null, JSBundle.message((String)"javascript.missing.write.property", (Object[])new Object[0]), null);
                    }
                }
            }
        }
    }

    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        return true;
    }

    private void registerQuickFixesForUnresolvedRef(JSReferenceExpression node, ResolveResult[] resolveResults) {
        ProblemHighlightType type;
        boolean canHaveCreateFromUsage;
        PsiElement nameIdentifier = node.getReferenceNameElement();
        if (nameIdentifier == null) {
            return;
        }
        LinkedList<LocalQuickFix> fixes = new LinkedList<LocalQuickFix>();
        boolean inTypeContext = JSResolveUtil.isExprInTypeContext(node);
        JSExpression qualifier = node.getQualifier();
        boolean bl = canHaveCreateFromUsage = JSAnnotatingVisitor.findInsufficientVisibilityResult(resolveResults) == null && JSAnnotatingVisitor.canHaveCreateFromUsage(qualifier);
        if (canHaveCreateFromUsage) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.getPreferredQuickFixForUnresolvedRef(nameIdentifier));
            if (fixes.isEmpty()) {
                boolean reportProblem;
                PsiFile containingFile = node.getContainingFile();
                boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                ProblemHighlightType highlightType = this.getUnresolvedReferenceHighlightType(node);
                boolean bl2 = reportProblem = (!ecma || highlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) && highlightType != null;
                if (!reportProblem) {
                    return;
                }
                inTypeContext = this.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
            }
        }
        JSAnnotatingVisitor.addEscalateVisibilityFix(resolveResults, node, fixes);
        fixes.add(this.renameReferenceFix());
        String message = null;
        boolean forceErrorReporting = false;
        boolean jsSymbolNotAccessible = false;
        if (resolveResults.length >= 1 && resolveResults[0] instanceof JSResolveResult) {
            String resolveProblemKey = ((JSResolveResult)resolveResults[0]).getResolveProblemKey();
            message = resolveProblemKey != null ? JSBundle.message((String)resolveProblemKey, (Object[])new Object[0]) : null;
            jsSymbolNotAccessible = resolveProblemKey == "javascript.jsdoc.private.member.is.not.accessible.message" || resolveProblemKey == "javascript.jsdoc.protected.member.is.not.accessible.message";
            PsiElement element = resolveResults[0].getElement();
            if (jsSymbolNotAccessible && element instanceof JSQualifiedNamedElement) {
                JSAttributeList.AccessType newVisibility = JSVisibilityUtil.getEscalatedJSDocVisibility((JSQualifiedNamedElement)element, (PsiElement)node);
                fixes.add((LocalQuickFix)new JSAccessibilityCheckInspection.SetJSDocElementVisibilityFix(element, newVisibility));
            }
            boolean bl3 = forceErrorReporting = message != null && resolveProblemKey != "javascript.element.need.to.be.exported";
            if (resolveProblemKey == "javascript.element.need.to.be.included.to.config") {
                fixes.addAll(JSFixFactory.getInstance().typeScriptConfigFixes(node, element));
            }
        }
        if (message == null) {
            String key = node.getQualifier() == null ? (inTypeContext ? "javascript.unresolved.type.name.message" : "javascript.unresolved.variable.or.type.name.message") : "javascript.unresolved.variable.name.message";
            message = JSBundle.message((String)key, (Object[])new Object[]{node.getReferenceName()});
        }
        ProblemHighlightType problemHighlightType = type = forceErrorReporting ? ProblemHighlightType.ERROR : this.getUnresolvedReferenceHighlightType(node);
        if (type != null) {
            if (jsSymbolNotAccessible) {
                this.reportAccessibilityError(nameIdentifier, null, message, fixes);
            } else {
                this.reportUnresolvedVariableError(nameIdentifier, type, message, fixes);
            }
        }
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        boolean isField;
        JSExpression qualifier = node.getQualifier();
        String referencedName = node.getReferenceName();
        PsiElement parent = node.getParent();
        PsiFile containingFile = node.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(containingFile);
        boolean bl = isField = qualifier != null || (ecma || JSClassUtils.canHaveClasses((PsiElement)containingFile)) && JSResolveUtil.getClassOfContext((PsiElement)node) != null;
        if (!inTypeContext) {
            if (parent instanceof JSArgumentList && (dialect == null || !dialect.isTypeScript)) {
                fixes.add(JSFixFactory.getInstance().createJSFunctionFromArgumentIntentionAction(referencedName, qualifier, ecma));
            }
            if (parent instanceof ES7Decorator) {
                fixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(referencedName, false));
            } else if (this.suggestCreateVarFromUsage(node)) {
                fixes.add(this.createJSVariableIntentionAction(referencedName, isField, false));
                if (isField && qualifier == null) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, false, false));
                }
                if (qualifier == null) {
                    JSAnnotatingVisitor.addCreateParameterFix(parent, fixes, referencedName);
                }
                if (ecma && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, isField, true));
                }
            }
        }
        if (qualifier != null && dialect != null && dialect.isJavaScript()) {
            fixes.add(JSFixFactory.getInstance().createJSNamespaceIntentionAction(referencedName));
        }
        return inTypeContext;
    }

    protected LocalQuickFix createJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant) {
        return JSFixFactory.getInstance().createJSVariableIntentionAction(referencedName, isField, isConstant);
    }

    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        return true;
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(PsiElement nameIdentifier) {
        return null;
    }

    private static JSResolveResult findInsufficientVisibilityResult(ResolveResult[] results) {
        for (ResolveResult r : results) {
            String problemKey;
            if (r.isValidResult() || !(r instanceof JSResolveResult) || !ArrayUtil.contains((String)(problemKey = ((JSResolveResult)r).getResolveProblemKey()), (String[])JSResolveResult.INSUFFICIENT_VISIBILITY_PROBLEM_KEYS)) continue;
            return (JSResolveResult)r;
        }
        return null;
    }

    private static void addEscalateVisibilityFix(ResolveResult[] resolveResults, JSReferenceExpression refExpr, List<LocalQuickFix> fixes) {
        JSResolveResult result = JSAnnotatingVisitor.findInsufficientVisibilityResult(resolveResults);
        if (result == null || !(result.getElement() instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner element = (JSAttributeListOwner)result.getElement();
        JSAttributeList attributeList = element.getAttributeList();
        if (attributeList == null) {
            return;
        }
        if (JSProjectUtil.isInLibrary((PsiElement)element)) {
            return;
        }
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        options.ignoreClassInheritance = result.getResolveProblemKey() == "javascript.protected.member.is.not.accessible.message";
        JSAttributeList.AccessType visibility = JSVisibilityUtil.getEscalatedVisibility(element, (PsiElement)refExpr, attributeList.getAccessType(), options);
        fixes.add((LocalQuickFix)new SetElementVisibilityFix(element, visibility));
    }

    private static boolean canHaveCreateFromUsage(JSExpression qualifier) {
        JSExpression innerExpression;
        if (qualifier instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)qualifier).getInnerExpression()) instanceof JSBinaryExpression && JSTokenTypes.AS_KEYWORD == ((JSBinaryExpression)innerExpression).getOperationSign()) {
            return true;
        }
        return qualifier == null || qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier instanceof JSNewExpression || AnalysisUtils.isLHSExpression(qualifier);
    }

    protected static void addCreateParameterFix(PsiElement parentElement, List<LocalQuickFix> fixes, String referencedName) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parentElement, JSFunction.class) != null) {
            fixes.add(JSFixFactory.getInstance().createJSParameterIntentionAction(referencedName));
        }
    }

    protected void checkMissedSuperCall(JSReferenceExpression node, JSFunction constructor, JSClass jsClass) {
        if (jsClass == null || jsClass.isInterface()) {
            return;
        }
        JSFunction nontrivialSuperClassConstructor = JSAnnotatingVisitor.getNontrivialSuperClassConstructor(jsClass);
        if (nontrivialSuperClassConstructor != null) {
            Annotation annotation = null;
            if (!JSAnnotatingVisitor.hasSuperConstructorCall(constructor)) {
                annotation = this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.missed.super.constructor.call", (Object[])new Object[0]));
            }
            if (annotation != null) {
                if (constructor == null) {
                    annotation.registerFix(JSFixFactory.getInstance().addConstructorAndSuperInvocationFix(node, nontrivialSuperClassConstructor));
                } else {
                    annotation.registerFix(JSFixFactory.getInstance().addSuperInvocationFix(node, nontrivialSuperClassConstructor));
                }
            }
        }
    }

    private static boolean hasSuperConstructorCall(JSFunction jsFunction) {
        if (jsFunction == null) {
            return false;
        }
        JSSourceElement[] body = jsFunction.getBody();
        return body.length > 0 && JSAnnotatingVisitor.containsSuperCall((JSBlockStatement)body[0]);
    }

    private static boolean containsSuperCall(JSBlockStatement blockStatement) {
        for (JSStatement statement : blockStatement.getStatements()) {
            JSStatement then;
            JSExpression expr;
            if (statement instanceof JSExpressionStatement && (expr = ((JSExpressionStatement)statement).getExpression()) instanceof JSCallExpression && ((JSCallExpression)expr).getMethodExpression() instanceof JSSuperExpression) {
                return true;
            }
            if (!(statement instanceof JSIfStatement) || !((then = ((JSIfStatement)statement).getThen()) instanceof JSBlockStatement) || !JSAnnotatingVisitor.containsSuperCall((JSBlockStatement)then)) continue;
            return true;
        }
        return false;
    }

    public static JSFunction getNontrivialSuperClassConstructor(JSClass clazz) {
        JSFunction constructor;
        JSClass[] classes;
        if (clazz instanceof TypeScriptClass) {
            for (JSFunction function : ((TypeScriptClass)clazz).getIndirectSuperConstructors()) {
                if (!ValidateTypesUtil.hasRequiredParameters(function)) continue;
                return function;
            }
        }
        if ((classes = clazz.getSuperClasses()).length > 0 && (constructor = classes[0].getConstructor()) != null) {
            return ValidateTypesUtil.hasRequiredParameters(constructor) ? constructor : null;
        }
        return null;
    }

    public void visitJSSwitchStatement(JSSwitchStatement node) {
        boolean encounteredDefault = false;
        for (JSCaseClause clause : node.getCaseClauses()) {
            if (!clause.isDefault()) continue;
            if (encounteredDefault) {
                this.myHolder.createErrorAnnotation((PsiElement)clause, JSBundle.message((String)"javascript.validation.message.only.one.default.is.allowed", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.default", clause.getNode()));
            }
            encounteredDefault = true;
        }
    }

    public void visitJSParameterList(JSParameterList node) {
        boolean foundRest = false;
        boolean initializerPresent = false;
        boolean hasOptional = false;
        for (final JSParameter parameter : node.getParameters()) {
            DialectOptionHolder dialect;
            boolean hasInitializer;
            JSExpression initializer = parameter.getInitializer();
            boolean bl = hasInitializer = initializer != null;
            if (hasOptional && !parameter.isOptional() && !parameter.isRest() && DialectDetector.isTypeScript((PsiElement)parameter)) {
                this.myHolder.createErrorAnnotation(parameter.getTextRange(), JSBundle.message((String)"javascript.validation.message.parameter.non.optional.after.optional", (Object[])new Object[0]));
            }
            if (parameter.isRest() && parameter.isOptional() && DialectDetector.isTypeScript((PsiElement)parameter)) {
                this.myHolder.createErrorAnnotation(parameter.getTextRange(), JSBundle.message((String)"javascript.validation.message.parameter.rest.optional", (Object[])new Object[0]));
            }
            boolean bl2 = hasOptional = hasOptional || parameter.isOptional();
            if (hasInitializer && !initializerPresent) {
                initializerPresent = true;
            }
            if (!hasInitializer && initializerPresent && this.needsInitializer(parameter)) {
                Annotation errorAnnotation = this.myHolder.createErrorAnnotation((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.should.be.initialized", (Object[])new Object[0]));
                Function<Void, PsiElement> targetGenerator = new Function<Void, PsiElement>(){

                    public PsiElement fun(Void aVoid) {
                        if (!parameter.isValid()) {
                            return parameter;
                        }
                        String newText = parameter.getText() + "=" + JSTypeUtils.defaultValueOfType(parameter.getTypeString());
                        ASTNode tree = JSChangeUtil.createJSTreeFromText(parameter.getProject(), "function foo(" + newText + "){}", JSUtils.getDialect(parameter.getContainingFile()));
                        assert (tree != null);
                        PsiElement newElement = tree.getPsi();
                        return ((JSFunction)newElement).getParameterList().getParameters()[0];
                    }
                };
                errorAnnotation.registerFix((IntentionAction)new ReplacePsiElementFix((PsiElement)parameter, targetGenerator, "javascript.fix.initialize.parameter"));
                errorAnnotation.registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.parameter", parameter.getNode()));
            } else if (hasInitializer && parameter.isRest()) {
                Pair<ASTNode, ASTNode> nodesBefore = JSAnnotatingVisitor.getNodesBefore((PsiElement)initializer, JSTokenTypes.EQ);
                this.myHolder.createErrorAnnotation((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.rest.parameter.should.not.be.initialized", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.initializer", false, (ASTNode)nodesBefore.first, (ASTNode)nodesBefore.second));
            }
            if (parameter.isRest() && !foundRest) {
                foundRest = true;
                this.validateRestParameterType(parameter);
                continue;
            }
            if (!foundRest || (dialect = DialectDetector.dialectOfFile(node.getContainingFile())) == null || !dialect.isECMA6 && dialect.isJavaScript()) continue;
            this.myHolder.createErrorAnnotation((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.parameter", parameter.getNode()));
        }
    }

    public void visitJSClass(JSClass aClass) {
        this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)aClass), JSLanguageFeature.CLASSES);
    }

    protected boolean needsInitializer(JSParameter parameter) {
        return !parameter.isRest();
    }

    protected void validateRestParameterType(JSParameter parameter) {
    }

    protected static Pair<ASTNode, ASTNode> getNodesBefore(PsiElement initializer, IElementType eq) {
        ASTNode end;
        ASTNode start = end = initializer.getNode();
        PsiElement element = initializer.getPrevSibling();
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element != null && element.getNode().getElementType() == eq) {
            start = element.getNode();
        }
        return Pair.create((Object)start, (Object)end);
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression expression) {
        JSExpression lExpr = expression.getLOperand();
        if (lExpr == null) {
            return;
        }
        if (lExpr instanceof JSDefinitionExpression) {
            lExpr = ((JSDefinitionExpression)lExpr).getExpression();
        }
        if (lExpr == null) {
            return;
        }
        this.checkLhs(lExpr);
        ValidateTypesUtil.checkTypesInAssignment(expression, this.myTypeChecker);
    }

    private void checkLhs(JSExpression lExpr) {
        if (!AnalysisUtils.isLHSExpression(lExpr)) {
            this.myHolder.createErrorAnnotation((PsiElement)lExpr, JSBundle.message((String)"javascript.validation.message.must.be.lvalue", (Object[])new Object[0]));
        }
    }

    private boolean checkAssignmentToConst(@NotNull JSReferenceExpression lExpr) {
        if (lExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lExpr", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkAssignmentToConst"));
        }
        PsiElement resolved = lExpr.resolve();
        if (resolved instanceof JSVariable && ((JSVariable)resolved).isConst() || resolved instanceof JSImplicitElement && ((JSImplicitElement)resolved).isConst() && !JSResolveUtil.isSameReference(lExpr, resolved) || resolved instanceof JSFunction && !(resolved instanceof JSFunctionExpression) && !((JSFunction)resolved).isSetProperty() && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)lExpr) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement place = lExpr.getReferenceNameElement();
            if (place == null) {
                place = lExpr;
            }
            String message = JSBundle.message((String)"javascript.validation.message.assignment.to.const", (Object[])new Object[0]);
            if (JSResolveUtil.isEcmaScript5((PsiElement)lExpr) || resolved instanceof JSImplicitElement && ((JSImplicitElement)resolved).getType() == JSImplicitElement.Type.Variable || resolved instanceof JSVariable || resolved instanceof JSFunction && ((JSFunction)resolved).isGetProperty()) {
                this.myHolder.createErrorAnnotation(place, message);
            } else {
                this.myHolder.createWarningAnnotation(place, message);
            }
            return true;
        }
        return false;
    }

    public void visitJSTryStatement(JSTryStatement node) {
        JSCatchBlock[] blocks = node.getAllCatchBlocks();
        if (blocks.length > 1) {
            THashSet typeToCatch = new THashSet();
            for (JSCatchBlock block : blocks) {
                JSParameter p = block.getParameter();
                if (p == null) continue;
                String s = p.getTypeString();
                if (s == null) {
                    s = "";
                }
                if (typeToCatch.contains(s)) {
                    Annotation annotation = this.myHolder.createErrorAnnotation((PsiElement)block, JSBundle.message((String)"javascript.validation.message.duplicate.catch.block", (Object[])new Object[0]));
                    annotation.registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.duplicate.catch.block.fix", true, block.getNode(), block.getNode()));
                    continue;
                }
                typeToCatch.add(s);
            }
        }
    }

    public void visitJSVariable(JSVariable var) {
        String name;
        JSAttributeList attributeList;
        PsiElement nameIdentifier;
        JSSemanticHighlightingUtil.highlight(var, this.myHighlighter, this.myHolder);
        if (var.getNode() != null && var.getNode().findChildByType(JSKeywordSets.JS_STRICT_KEYWORDS) != null && JSResolveUtil.isEcmaScript5((PsiElement)var) && (nameIdentifier = var.getNameIdentifier()) != null) {
            String message = JSBundle.message((String)"javascript.validation.message.identifier.not.allowed.in.strict.mode", (Object[])new Object[]{var.getName()});
            this.myHolder.createErrorAnnotation(nameIdentifier, message);
        }
        if (var.isConst() && !var.hasInitializer() && ((attributeList = var.getAttributeList()) == null || attributeList.getAttributesByName("Embed").length == 0)) {
            if (DialectDetector.isES6((PsiElement)var)) {
                this.myHolder.createErrorAnnotation((PsiElement)var, JSBundle.message((String)"es6.validation.message.const.variable.without.initializer", (Object[])new Object[0]));
            } else if (!DialectDetector.isTypeScript((PsiElement)var) || !TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var)) {
                this.myHolder.createWarningAnnotation((PsiElement)var, JSBundle.message((String)"javascript.validation.message.const.variable.without.initializer", (Object[])new Object[0]));
            }
        }
        if (("arguments".equals(name = var.getName()) || EVAL_FUNCTION_NAME.equals(name)) && JSResolveUtil.isEcmaScript5((PsiElement)var)) {
            PsiElement nameIdentifier2 = var.getNameIdentifier();
            assert (nameIdentifier2 != null) : "name is not null, name identifier is null";
            this.myHolder.createErrorAnnotation(nameIdentifier2, JSBundle.message((String)"javascript.validation.message.redefining.is.not.allowed", (Object[])new Object[]{name}));
        }
        this.checkTypesInVariable(var);
        DuplicatesCheckUtil.checkDuplicatesForVariable(var, this.myProblemReporter);
    }

    private void checkTypesInVariable(JSVariable node) {
        if (node.getType() instanceof JSVoidType && !DialectDetector.isTypeScript((PsiElement)node)) {
            PsiElement typeElement = node.getTypeElement();
            this.myTypeChecker.registerProblem((PsiElement)(typeElement != null ? typeElement : node), JSBundle.message((String)"javascript.illegal.variable.type.void", (Object[])new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
            return;
        }
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        this.myTypeChecker.checkExpressionIsAssignableToVariable(node, initializer, node.getContainingFile(), "javascript.initializer.type.mismatch", true);
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        ValidateTypesUtil.checkTypesInConditionalExpr(node, this.myTypeChecker);
    }

    public void visitJSContinueStatement(JSContinueStatement node) {
        JSSemanticHighlightingUtil.highlight(node, this.myHighlighter, this.myHolder);
        if (node.getStatementToContinue() == null) {
            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.continue.without.target", (Object[])new Object[0]));
        }
    }

    public void visitJSBreakStatement(JSBreakStatement node) {
        JSSemanticHighlightingUtil.highlight(node, this.myHighlighter, this.myHolder);
        if (node.getStatementToBreak() == null) {
            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.break.without.target", (Object[])new Object[0]));
        }
    }

    protected void checkFunction(JSFunction node) {
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)node, this.myProblemReporter);
    }

    public void visitJSProperty(JSProperty node) {
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)node, this.myProblemReporter);
        JSSemanticHighlightingUtil.highlight(node, this.myHighlighter, this.myHolder);
        String type = JSDocumentationUtils.findType((PsiElement)node);
        JSExpression value = node.getValue();
        if (type != null && value != null) {
            JSType jsType = JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)node, true));
            this.myTypeChecker.checkExpressionIsAssignableToType(value, jsType, "javascript.initializer.type.mismatch", (PsiElement)node);
        }
        if (node instanceof ES6Property) {
            JSExpression propertyName;
            if (((ES6Property)node).isShorthanded()) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            }
            if ((propertyName = ((ES6Property)node).tryGetComputedPropertyName()) != null) {
                this.checkElementInCurrentLanguageLevel((PsiElement)propertyName, JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            }
            if (node instanceof ES6FunctionProperty) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
            }
        }
    }

    public void visitJSParameter(JSParameter node) {
        JSSemanticHighlightingUtil.highlight((JSVariable)node, this.myHighlighter, this.myHolder);
        super.visitJSParameter(node);
    }

    protected static boolean compatibleType(String overrideParameterType, String parameterType, PsiElement overrideContext, PsiElement funContext) {
        if (overrideParameterType != null && !overrideParameterType.equals(parameterType)) {
            parameterType = JSImportHandlingUtil.resolveTypeName(parameterType, funContext);
            if (!(overrideParameterType = JSImportHandlingUtil.resolveTypeName(overrideParameterType, overrideContext)).equals(parameterType)) {
                return parameterType != null && (JSTypeEvaluateManager.isArrayType(overrideParameterType) && JSTypeEvaluateManager.getBaseArrayType(overrideParameterType).equals(parameterType) || JSTypeEvaluateManager.isArrayType(parameterType) || JSTypeEvaluateManager.getBaseArrayType(parameterType).equals(overrideParameterType));
            }
            return true;
        }
        return overrideParameterType != null || parameterType == null || "*".equals(parameterType);
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, XmlTagChild.class, XmlAttributeValue.class, JSFile.class});
        if (element instanceof JSFile && !(element.getContext() instanceof PsiLanguageInjectionHost) && !((JSFile)element).isCommonJSModule() || element instanceof XmlTagChild && !(element.getParent() instanceof XmlAttributeValue)) {
            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.return.outside.function.definition", (Object[])new Object[0]));
        }
        if (element instanceof JSFunction) {
            JSType type = ((JSFunction)element).getReturnType();
            JSExpression returnedExpr = node.getExpression();
            if (!ValidateTypesUtil.emptyReturnIsAcceptable((JSFunction)element, type) && returnedExpr == null) {
                this.myTypeChecker.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.validation.message.return.value.of.type.is.required", (Object[])new Object[]{type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
            }
        }
        this.myTypeChecker.checkTypesInReturnStatement(node);
    }

    public void visitJSLabeledStatement(JSLabeledStatement node) {
        String label = node.getLabel();
        if (label != null) {
            JSSemanticHighlightingUtil.highlight(node, this.myHighlighter, this.myHolder);
            for (PsiElement run = node.getParent(); run != null; run = run.getParent()) {
                if (run instanceof JSLabeledStatement && label.equals(((JSLabeledStatement)run).getLabel())) {
                    this.myHolder.createErrorAnnotation(node.getLabelIdentifier(), JSBundle.message((String)"javascript.validation.message.duplicate.label", (Object[])new Object[0]));
                    break;
                }
                if (run instanceof JSFunction) break;
            }
        }
    }

    public void visitJSWithStatement(JSWithStatement node) {
        if (JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            JSAnnotatorProblemReporter.createErrorAnnotation(node.getFirstChild(), JSBundle.message((String)"javascript.with.statement.is.not.allowed.in.strict.mode.message", (Object[])new Object[0]), ProblemHighlightType.ERROR, this.myHolder);
        }
    }

    public void visitJSPostfixExpression(JSPostfixExpression node) {
        this.checkLhs(node.getExpression());
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.myTypeChecker);
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        PsiElement resolve;
        IElementType operationSign;
        JSExpression expression = node.getExpression();
        if (expression != null && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) == ReadWriteAccessDetector.Access.ReadWrite) {
            this.checkLhs(expression);
        }
        if ((operationSign = node.getOperationSign()) == JSTokenTypes.DELETE_KEYWORD && expression instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSParameter || resolve instanceof JSFunction || resolve instanceof JSVariable)) {
            String message = JSBundle.message((String)"javascript.invalid.delete.target.message", (Object[])new Object[0]);
            if (node.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) || JSResolveUtil.isEcmaScript5((PsiElement)expression)) {
                JSAnnotatorProblemReporter.createErrorAnnotation((PsiElement)expression, message, ProblemHighlightType.ERROR, this.myHolder);
            } else {
                Annotation warningAnnotation = this.myHolder.createWarningAnnotation((PsiElement)expression, message);
                warningAnnotation.setHighlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(operationSign, expression, this.myTypeChecker);
    }

    public void visitJSForInStatement(JSForInStatement node) {
        ASTNode ofKeyword;
        ASTNode eachKeyword = node.getNode().findChildByType(JSTokenTypes.EACH_KEYWORD);
        if (eachKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(eachKeyword, this.myHolder);
        }
        if ((ofKeyword = node.getNode().findChildByType(JSTokenTypes.OF_KEYWORD)) != null) {
            this.checkElementInCurrentLanguageLevel(ofKeyword.getPsi(), JSLanguageFeature.FOR_OF);
        }
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        ValidateTypesUtil.checkTypesInBinaryExpression(node, this.myProblemReporter, this.myTypeChecker);
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.checkElementInCurrentLanguageLevel((PsiElement)importDeclaration, JSLanguageFeature.IMPORT_DECLARATIONS);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.checkElementInCurrentLanguageLevel((PsiElement)exportDeclaration, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDefaultAssignment(node);
    }

    public void visitJSAttributeList(JSAttributeList attributeList) {
        ASTNode exportKeyword = attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD);
        if (exportKeyword != null) {
            this.checkElementInCurrentLanguageLevel(exportKeyword.getPsi(), JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        super.visitJSAttributeList(attributeList);
    }

    @NotNull
    public static PsiElement getPlaceForNamedElementProblem(@NotNull PsiNameIdentifierOwner element) {
        IElementType type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
        }
        PsiElement nameIdentifier = element.getNameIdentifier();
        if (nameIdentifier != null) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
            }
            return psiElement;
        }
        PsiElement firstChild = element.getFirstChild();
        if (firstChild != null && JSKeywordSets.IDENTIFIER_NAMES.contains(type = firstChild.getNode().getElementType())) {
            PsiElement psiElement = firstChild;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
            }
            return psiElement;
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = element;
        if (psiNameIdentifierOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
        }
        return psiNameIdentifierOwner;
    }

    @Nullable
    protected String getImportCheckInspectionId() {
        return null;
    }

    public static void highlightFromKeyword(ES6FromClause fromClause, AnnotationHolder holder) {
        ASTNode fromKeyword = fromClause.getNode().findChildByType(JSTokenTypes.FROM_KEYWORD);
        if (fromKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(fromKeyword, holder);
        }
    }

    public void visitES6FromClause(ES6FromClause fromClause) {
        JSAnnotatingVisitor.highlightFromKeyword(fromClause, this.myHolder);
    }

    public void visitImportSpecifier(ES6ImportSpecifier node) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        if (holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
            this.checkReferences((PsiElement)node, this.getImportCheckInspectionId());
        }
    }

    public void visitES6ImportedBinding(ES6ImportedBinding importedBinding) {
        PsiElement parent;
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)importedBinding, this.myProblemReporter);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)importedBinding);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return;
        }
        if (!importedBinding.isNamespaceImport() && (parent = importedBinding.getParent()) instanceof ES6ImportDeclaration) {
            Collection elements;
            ES6FromClause fromClause;
            Collection referencedElements = importedBinding.findReferencedElements();
            PsiElement resolveResult = (PsiElement)ContainerUtil.getFirstItem((Collection)referencedElements);
            if (resolveResult != null) {
                resolveResult = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult);
                JSSemanticHighlightingUtil.highlight((PsiElement)importedBinding, resolveResult, this.myHighlighter, this.myHolder);
            }
            if ((fromClause = ((ES6ImportDeclaration)parent).getFromClause()) != null && (elements = fromClause.resolveReferencedElements()).size() == 1 && referencedElements.isEmpty()) {
                PsiElement jsModule = (PsiElement)elements.iterator().next();
                ProblemHighlightType type = JSAnnotatingVisitor.getImportedBindingProblemHighlightType(jsModule);
                this.myProblemReporter.registerProblem(importedBinding.getNameIdentifier(), JSBundle.message((String)"es6.default.export.not.declared", (Object[])new Object[0]), type, this.getImportCheckInspectionId(), new LocalQuickFix[0]);
            }
        }
    }

    private static ProblemHighlightType getImportedBindingProblemHighlightType(PsiElement jsModule) {
        return ProblemHighlightType.WEAK_WARNING;
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)specifierAlias, this.myProblemReporter);
    }

    public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        if (holder != null && holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
            this.checkReferences((PsiElement)node, this.getImportCheckInspectionId());
        }
    }

    protected void reportUnresolvedVariableError(PsiElement identifier, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        this.reportUnresolvedRefProblem(problemHighlightType, fixes, identifier, message, JSUnresolvedVariableInspection.SHORT_NAME);
    }

    protected Annotation reportUnresolvedFunctionError(PsiElement referenceNameElement, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        return this.reportUnresolvedRefProblem(problemHighlightType, fixes, referenceNameElement, message, JSUnresolvedFunctionInspection.SHORT_NAME);
    }

    protected void reportAccessibilityError(PsiElement identifier, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        this.reportUnresolvedRefProblem(problemHighlightType, fixes, identifier, message, JSAccessibilityCheckInspection.SHORT_NAME);
    }

    public void visitJSFunctionDeclaration(JSFunction node) {
        if (node.isGenerator()) {
            this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)node), JSLanguageFeature.YIELD_GENERATORS);
        }
    }

    public void visitJSStringTemplateExpression(JSStringTemplateExpression stringTemplateExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)stringTemplateExpression, JSLanguageFeature.STRING_TEMPLATES);
    }

    public class SimpleErrorReportingClient
    implements ErrorReportingClient {
        @Override
        public void reportError(ASTNode nameIdentifier, String s, ErrorReportingClient.ProblemKind kind, IntentionAction ... fixes) {
            if (fixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$SimpleErrorReportingClient", "reportError"));
            }
            Annotation annotation = kind == ErrorReportingClient.ProblemKind.ERROR ? JSAnnotatingVisitor.this.myHolder.createErrorAnnotation(nameIdentifier, s) : JSAnnotatingVisitor.this.myHolder.createWarningAnnotation(nameIdentifier, s);
            for (IntentionAction fix : fixes) {
                if (fix == null) continue;
                annotation.registerFix(fix);
            }
        }
    }

    protected static enum SignatureMatchResult {
        PARAMETERS_DIFFERS,
        RETURN_TYPE_DIFFERS,
        FUNCTION_KIND_DIFFERS,
        COMPATIBLE_SIGNATURE;

    }

    public static interface ErrorReportingClient {
        public void reportError(ASTNode var1, String var2, ProblemKind var3, IntentionAction ... var4);

        public static enum ProblemKind {
            ERROR,
            WARNING;

        }
    }
}

