/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionSignatureChecker
extends JSElementVisitor {
    protected final JSTypeChecker<?> myTypeChecker;

    public JSFunctionSignatureChecker(JSTypeChecker<?> typeChecker) {
        this.myTypeChecker = typeChecker;
    }

    protected abstract void registerProblem(JSCallExpression var1, String var2, LocalQuickFix ... var3);

    public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker", "checkFunction"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker", "checkFunction"));
        }
        JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node);
        if (functionItem != null) {
            JSType returnType;
            if (!functionItem.isGetProperty() || (returnType = functionItem.getReturnType()) == null || !this.isCallableType(node instanceof JSNewExpression, returnType)) {
                this.checkCallParameters(node, (PsiElement)functionItem);
            }
        } else {
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            this.canBeCalledWithArguments(jsType, node);
        }
    }

    public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int count, String n) {
        if (node.getArguments().length != count) {
            this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{n}), new LocalQuickFix[0]);
        }
    }

    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker", "isCallableType"));
        }
        return inNewExpression ? JSTypeUtils.hasConstructorType(type) : JSTypeUtils.hasFunctionType(type);
    }

    protected void canBeCalledWithArguments(JSType type, JSCallExpression node) {
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl) {
            JSParameterTypeDecorator nextDecorator;
            JSExpression[] arguments = node.getArguments();
            List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
            Iterator<JSParameterTypeDecorator> myIterator = parameters.iterator();
            JSType restType = null;
            for (JSExpression argument : arguments) {
                JSType next;
                JSParameterTypeDecorator nextDecorator2 = null;
                if (restType != null) {
                    next = restType;
                } else if (myIterator.hasNext()) {
                    nextDecorator2 = myIterator.next();
                    next = nextDecorator2.getType();
                } else {
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{parameters.size()}), new LocalQuickFix[0]);
                    break;
                }
                if (nextDecorator2 != null && nextDecorator2.isRest()) {
                    restType = nextDecorator2.getType();
                }
                this.myTypeChecker.checkExpressionIsAssignableToType(argument, next, "javascript.argument.type.mismatch", null);
            }
            if (myIterator.hasNext() && !(nextDecorator = myIterator.next()).isOptional() && !nextDecorator.isRest()) {
                this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{parameters.size()}), new LocalQuickFix[0]);
            }
        }
    }

    protected void checkCallParameters(JSCallExpression node, @Nullable PsiElement element) {
        JSExpression[] expressions;
        JSFunctionItem function = element != null ? JSPsiImplUtils.calculatePossibleFunction(element) : null;
        JSParameterItem[] parameters = function != null ? function.getParameters() : JSParameterItem.EMPTY_ARRAY;
        JSArgumentList argumentList = node.getArgumentList();
        if (PsiTreeUtil.getChildrenOfType((PsiElement)argumentList, OuterLanguageElement.class) != null) {
            return;
        }
        JSExpression[] jSExpressionArray = expressions = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
        if (!(function != null && function.isReferencesArguments() || function instanceof JSImplicitElement && parameters.length == 0 && function.getReturnType() == null)) {
            Trinity<Integer, Integer, Boolean> minMaxParameters = ValidateTypesUtil.getMinMaxParameters(parameters);
            if (expressions.length < (Integer)minMaxParameters.first || expressions.length > (Integer)minMaxParameters.second) {
                LocalQuickFix[] fixes;
                String s;
                String string = (Boolean)minMaxParameters.third != false ? minMaxParameters.first + " or more" : (s = String.valueOf(minMaxParameters.first) + (!((Integer)minMaxParameters.first).equals(minMaxParameters.second) ? ".." + minMaxParameters.second : ""));
                if (function instanceof JSFunction) {
                    JSFunction topMethod = JSInheritanceUtil.findTopMethods((JSFunction)function).iterator().next();
                    JSFunction psiElement = topMethod != function ? topMethod : element;
                    LocalQuickFix fix = JSFixFactory.getInstance().changeSignatureFix((PsiElement)psiElement, expressions);
                    fixes = new LocalQuickFix[]{fix};
                } else {
                    fixes = LocalQuickFix.EMPTY_ARRAY;
                }
                boolean skip = false;
                if (expressions.length == 1 && "window".equalsIgnoreCase(expressions[0].getText()) && parameters.length == 2) {
                    skip = true;
                }
                if (argumentList != null && argumentList.hasSpreadElement() && expressions.length < (Integer)minMaxParameters.first) {
                    skip = true;
                }
                if (!skip) {
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{s}), fixes);
                }
                return;
            }
        }
        PsiFile containingFile = node.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(containingFile);
        int[] matchedParams = new int[expressions.length];
        if (!JSFunctionSignatureChecker.tryMakeInitialMatch(matchedParams, 0, 0, parameters)) {
            int paramWithMissedArgument;
            int arg = 0;
            for (paramWithMissedArgument = 0; paramWithMissedArgument < parameters.length; ++paramWithMissedArgument) {
                if (parameters[paramWithMissedArgument].isOptional() || parameters[paramWithMissedArgument].getType() == null) continue;
                if (arg >= expressions.length) break;
                ++arg;
            }
            if (paramWithMissedArgument < parameters.length) {
                this.registerProblem(node, JSBundle.message((String)"javascript.missed.argument.for.parameter", (Object[])new Object[]{parameters[paramWithMissedArgument].getName()}), new LocalQuickFix[0]);
            }
            return;
        }
        int[] nextMatchedParams = new int[matchedParams.length];
        while (true) {
            System.arraycopy(matchedParams, 0, nextMatchedParams, 0, matchedParams.length);
            boolean hasNextMatchedParams = this.obtainNextMatchedParams(nextMatchedParams, parameters);
            boolean allMatched = true;
            for (int argIndex = 0; argIndex < expressions.length; ++argIndex) {
                JSParameterItem p = parameters[matchedParams[argIndex]];
                if (dialect == DialectOptionHolder.ECMA_4 && p.isRest()) break;
                if (hasNextMatchedParams) {
                    if (JSResolveUtil.isAssignableJSType(this.addGenericTypesFromCall(p.getType(), node, element), JSResolveUtil.getExpressionJSType(expressions[argIndex]))) continue;
                    allMatched = false;
                    break;
                }
                if (p.isRest()) {
                    JSType type = p.getType();
                    this.myTypeChecker.checkExpressionIsAssignableToType(expressions[argIndex], this.addGenericTypesFromCall(type, node, element), "javascript.argument.type.mismatch", null);
                    continue;
                }
                this.checkCallArgumentType(p, expressions[argIndex], node, element);
            }
            if (allMatched) break;
            int[] tmp = matchedParams;
            matchedParams = nextMatchedParams;
            nextMatchedParams = tmp;
        }
    }

    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        for (int argIndexToShift = matchedParams.length - 1; argIndexToShift >= 0; --argIndexToShift) {
            int paramOffset;
            int oldParamIndex;
            if (matchedParams[argIndexToShift] >= parameters.length - 1 || !parameters[oldParamIndex = matchedParams[argIndexToShift]].isOptional() && !parameters[oldParamIndex].isRest()) continue;
            int newParamIndex = oldParamIndex + 1;
            int n = paramOffset = newParamIndex < parameters.length && parameters[newParamIndex].isRest() ? newParamIndex : newParamIndex + 1;
            if (!JSFunctionSignatureChecker.tryMakeInitialMatch(matchedParams, argIndexToShift + 1, paramOffset, parameters)) continue;
            int n2 = argIndexToShift;
            matchedParams[n2] = matchedParams[n2] + 1;
            return true;
        }
        return false;
    }

    private static boolean tryMakeInitialMatch(int[] matchedParams, int matchedParamsOffset, int paramsOffset, JSParameterItem[] parameters) {
        boolean fits;
        if (matchedParamsOffset > matchedParams.length) {
            return false;
        }
        if (paramsOffset > parameters.length) {
            return false;
        }
        int argumentsToMatch = matchedParams.length - matchedParamsOffset;
        int required = 0;
        boolean hasRest = false;
        for (int i = paramsOffset; i < parameters.length; ++i) {
            if (parameters[i].isRest()) {
                hasRest = true;
                continue;
            }
            if (parameters[i].isOptional()) continue;
            ++required;
        }
        boolean bl = fits = required <= argumentsToMatch && (hasRest || argumentsToMatch <= parameters.length - paramsOffset);
        if (!fits) {
            return false;
        }
        for (int i = matchedParamsOffset; i < matchedParams.length; ++i) {
            if (required == matchedParams.length - i) {
                while (parameters[paramsOffset].isRest() || parameters[paramsOffset].isOptional()) {
                    ++paramsOffset;
                }
            }
            matchedParams[i] = paramsOffset;
            if (parameters[paramsOffset].isRest()) continue;
            if (!parameters[paramsOffset].isOptional()) {
                --required;
            }
            ++paramsOffset;
        }
        return true;
    }

    @Nullable
    @Contract(value="!null, _, _ -> !null")
    protected final JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult) {
        return this.addGenericTypesFromCall(type, callExpression, resolveResult, null);
    }

    @Nullable
    @Contract(value="!null, _, _,_ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        return type;
    }

    protected void checkCallArgumentType(JSParameterItem p, JSExpression expression, JSCallExpression node, PsiElement resolveResult) {
        this.myTypeChecker.checkExpressionIsAssignableToType(expression, p.getType(), "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null));
    }

    public static interface ErrorReporter {
        public void error(String var1);
    }
}

