/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedJSAnnotatingVisitor
extends JSAnnotatingVisitor {
    protected static JSAnnotatingVisitor.SignatureMatchResult checkCompatibleSignature(JSFunction fun, JSFunction override) {
        JSAnnotatingVisitor.SignatureMatchResult result;
        JSParameterList nodeParameterList = fun.getParameterList();
        JSParameterList overrideParameterList = override.getParameterList();
        JSParameter[] parameters = nodeParameterList != null ? nodeParameterList.getParameters() : JSParameter.EMPTY_ARRAY;
        JSParameter[] overrideParameters = overrideParameterList != null ? overrideParameterList.getParameters() : JSParameter.EMPTY_ARRAY;
        JSAnnotatingVisitor.SignatureMatchResult signatureMatchResult = result = parameters.length != overrideParameters.length ? JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS : JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE;
        if (result == JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE) {
            for (int i = 0; i < parameters.length; ++i) {
                if (TypedJSAnnotatingVisitor.compatibleType(overrideParameters[i].getTypeString(), parameters[i].getTypeString(), (PsiElement)overrideParameterList, (PsiElement)nodeParameterList) && overrideParameters[i].hasInitializer() == parameters[i].hasInitializer()) continue;
                result = JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS;
                break;
            }
        }
        if (result == JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE && !TypedJSAnnotatingVisitor.compatibleType(override.getReturnTypeString(), fun.getReturnTypeString(), (PsiElement)override, (PsiElement)fun)) {
            result = JSAnnotatingVisitor.SignatureMatchResult.RETURN_TYPE_DIFFERS;
        }
        if (result == JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE && override.getKind() != fun.getKind()) {
            result = JSAnnotatingVisitor.SignatureMatchResult.FUNCTION_KIND_DIFFERS;
        }
        return result;
    }

    protected static ASTNode findElementForAccessModifierError(@NotNull JSFunction o, JSAttributeList attributeList) {
        PsiElement accessTypeElement;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/lang/javascript/validation/TypedJSAnnotatingVisitor", "findElementForAccessModifierError"));
        }
        if (attributeList != null && (accessTypeElement = attributeList.findAccessTypeElement()) != null) {
            return accessTypeElement.getNode();
        }
        return o.findNameIdentifier();
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/TypedJSAnnotatingVisitor", "getUnresolvedReferenceHighlightType"));
        }
        JSExpression qualifier = node.getQualifier();
        if (qualifier == null && node instanceof JSReferenceExpressionImpl) {
            qualifier = ((JSReferenceExpressionImpl)node).getResolveQualifier();
        }
        if (qualifier == null) {
            JSExpression expression;
            JSWithStatement withStatement = (JSWithStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSWithStatement.class);
            if (withStatement != null && (expression = withStatement.getExpression()) != null && expression != node && PsiTreeUtil.findCommonParent((PsiElement)node, (PsiElement)expression) != expression) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    @Nullable
    protected JSType getResolveResultType(JSExpression qualifier, PsiElement resultElement) {
        return JSResolveUtil.getExpressionJSType(qualifier);
    }

    public void visitJSReferenceList(JSReferenceList referenceList) {
        boolean isImplements;
        JSClass jsClass = (JSClass)referenceList.getParent();
        if (JSResolveUtil.isArtificialClassUsedForReferenceList(jsClass)) {
            return;
        }
        boolean isExtends = jsClass.getExtendsList() == referenceList;
        boolean bl = isImplements = jsClass.getImplementsList() == referenceList;
        if (isImplements && jsClass.isInterface()) {
            this.myHolder.createErrorAnnotation((PsiElement)referenceList, JSBundle.message((String)"javascript.validation.message.implements.for.interface.not.allowed", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().replaceImplementsKeywordByExtendsFix(referenceList));
            return;
        }
        HashSet hasErrorExpressions = ContainerUtil.newHashSet();
        HashSet hasCircularErrorErrorExpressions = ContainerUtil.newHashSet();
        for (Pair pair : referenceList.getResolvedExpressions()) {
            JSExpression expr = (JSExpression)pair.first;
            Collection second = (Collection)pair.getSecond();
            if (second == null || second.isEmpty()) {
                this.checkNotResolvedReferenceListExpression(jsClass, expr, isExtends);
                continue;
            }
            for (JSClass clazz : second) {
                if (isImplements && !hasErrorExpressions.contains(expr)) {
                    if (!this.checkImplementsRef(clazz, expr)) {
                        hasErrorExpressions.add(expr);
                    }
                } else if (isExtends && !hasErrorExpressions.contains(expr) && !this.checkExtendsRef(jsClass, clazz, expr)) {
                    hasErrorExpressions.add(expr);
                }
                if (clazz != jsClass || hasCircularErrorErrorExpressions.contains(expr)) continue;
                this.myHolder.createErrorAnnotation((PsiElement)expr, JSBundle.message((String)"javascript.validation.message.circular.dependency", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.circular.dependency", referenceList.getNode()));
                hasCircularErrorErrorExpressions.add(expr);
            }
        }
        if (isImplements || isExtends && DialectDetector.isTypeScript((PsiElement)jsClass)) {
            this.checkImplementedMethods(jsClass, new JSAnnotatingVisitor.SimpleErrorReportingClient());
        }
        if (isExtends) {
            this.checkOverriddenMethods(jsClass);
        }
    }

    @Override
    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        JSClass clazz;
        JSExpression qualifier = node.getQualifier();
        JSClass targetClass = null;
        if (qualifier == null) {
            targetClass = JSResolveUtil.getClassOfContext((PsiElement)node);
        } else if (qualifier instanceof JSReferenceExpression && (clazz = JSResolveUtil.findClassOfQualifier(qualifier, node.getContainingFile())) != null) {
            targetClass = clazz;
        }
        if (targetClass != null) {
            return !targetClass.isInterface();
        }
        return true;
    }

    protected void checkNotResolvedReferenceListExpression(JSClass jsClass, JSExpression expression, boolean isExtends) {
    }

    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        if (referencedClass.isInterface() != jsClass.isInterface()) {
            this.myHolder.createErrorAnnotation((PsiElement)expr, JSBundle.message((String)(jsClass.isInterface() ? "javascript.validation.message.interface.name.expected.here" : "javascript.validation.message.class.name.expected.here"), (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        if (!jsClass.isInterface()) {
            this.myHolder.createErrorAnnotation((PsiElement)expr, JSBundle.message((String)"javascript.validation.message.interface.name.expected.here", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void checkImplementedMethods(JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
    }

    protected void checkOverriddenMethods(JSClass aClass) {
    }
}

