/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetElementVisibilityFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final JSAttributeList.AccessType myVisibility;
    private final String myNamespace;

    public SetElementVisibilityFix(JSAttributeListOwner method, @NotNull JSAttributeList.AccessType visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "<init>"));
        }
        super((PsiElement)method);
        this.myVisibility = visibility;
        this.myNamespace = null;
    }

    public SetElementVisibilityFix(JSAttributeListOwner method, @NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "<init>"));
        }
        super((PsiElement)method);
        this.myVisibility = null;
        this.myNamespace = namespace;
    }

    @NotNull
    public String getText() {
        JSAttributeListOwner myClassOrMethod = (JSAttributeListOwner)this.getStartElement();
        if (myClassOrMethod == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "getText"));
            }
            return "";
        }
        String type = myClassOrMethod instanceof JSClass ? JSBundle.message((String)(((JSClass)myClassOrMethod).isInterface() ? "interface.description" : "class.description"), (Object[])new Object[]{myClassOrMethod.getName()}) : (myClassOrMethod instanceof JSFunction ? (((JSFunction)myClassOrMethod).isConstructor() ? JSBundle.message((String)"constructor.description", (Object[])new Object[]{myClassOrMethod.getName()}) : (((JSFunction)myClassOrMethod).isGetProperty() ? JSBundle.message((String)"getter.description", (Object[])new Object[]{myClassOrMethod.getName()}) : (((JSFunction)myClassOrMethod).isSetProperty() ? JSBundle.message((String)"setter.description", (Object[])new Object[]{myClassOrMethod.getName()}) : JSBundle.message((String)"method.description", (Object[])new Object[]{myClassOrMethod.getName()})))) : (myClassOrMethod instanceof JSVariable ? JSBundle.message((String)(((JSVariable)myClassOrMethod).isConst() ? "constant.description" : "field.description"), (Object[])new Object[]{myClassOrMethod.getName()}) : ""));
        String newVisibility = this.myVisibility != null ? JSFormatUtil.formatVisibility(this.myVisibility, (PsiElement)myClassOrMethod) : this.myNamespace;
        String string = JSBundle.message((String)"javascript.fix.set.element.visibility", (Object[])new Object[]{type, newVisibility});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "invoke"));
        }
        SetElementVisibilityFix.setVisibility((JSAttributeListOwner)startElement, this.myVisibility, this.myNamespace);
    }

    public static void setVisibility(@NotNull JSAttributeListOwner startElement, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/SetElementVisibilityFix", "setVisibility"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)startElement)) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(startElement.getAttributeList());
        if (visibility != null) {
            wrapper.overrideAccessType(visibility);
        } else if (namespace != null) {
            wrapper.overrideNamespace(namespace);
        }
        wrapper.applyTo(startElement);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

