/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementFieldsFix
extends BaseCreateMethodsFix<TypeScriptPropertySignature>
implements IntentionAction {
    public TypeScriptImplementFieldsFix(JSClass jsClass) {
        super(jsClass);
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.implement.fields", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementFieldsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementFieldsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementFieldsFix", "isAvailable"));
        }
        return this.myJsClass.isValid();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Override
    public String buildFunctionText(TypeScriptPropertySignature fun, @Nullable MultiMap<String, String> types) {
        JSType type;
        String processedType;
        String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)fun);
        if (StringUtil.isEmpty((String)name)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(name);
        JSTypeDeclaration typeDeclaration = fun.getType();
        if (typeDeclaration != null && !StringUtil.isEmpty((String)(processedType = TypeScriptImplementFieldsFix.getProcessedType(type = TypeScriptTypeParser.buildTypeFromTypeScript(typeDeclaration), this.myJsClass, (PsiElement)fun)))) {
            builder.append(":");
            builder.append(processedType);
        }
        builder.append(";");
        return builder.toString();
    }
}

