/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.compiler.JSLanguageCompileInfo;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerCommand;
import com.intellij.lang.typescript.compiler.protocol.commands.TypeScriptCompilerCommandToCompile;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileInfo
implements JSLanguageCompileInfo {
    @Nullable
    private final Map<String, String> myUnsavedFilesContent;
    @NotNull
    private final Map<String, Long> myChangedFilesToTimeStamp;
    private final boolean myIsAnnotate;
    private final boolean myShouldGetValueFromCache;
    private final Pair<String, String> myModuleInfo;
    @NotNull
    private final String myCompilerId;

    @NotNull
    public String getCompilerId() {
        String string = this.myCompilerId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfo", "getCompilerId"));
        }
        return string;
    }

    public TypeScriptCompileInfo(@NotNull Collection<String> changedFiles, Pair<String, String> moduleInfo, @NotNull String compilerId) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfo", "<init>"));
        }
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfo", "<init>"));
        }
        this.myModuleInfo = moduleInfo;
        this.myCompilerId = compilerId;
        this.myChangedFilesToTimeStamp = ContainerUtil.newHashMap();
        this.myIsAnnotate = true;
        this.myShouldGetValueFromCache = false;
        this.myUnsavedFilesContent = null;
        for (String file : changedFiles) {
            this.myChangedFilesToTimeStamp.put(file, -1L);
        }
    }

    public TypeScriptCompileInfo(@NotNull Map<String, Long> changedFilesToTimeStamp, @Nullable Map<String, String> unsavedFilesContent, boolean isAnnotate, boolean shouldGetValueFromCache, Pair<String, String> moduleInfo, @NotNull String compilerId) {
        if (changedFilesToTimeStamp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFilesToTimeStamp", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfo", "<init>"));
        }
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfo", "<init>"));
        }
        this.myCompilerId = compilerId;
        this.myModuleInfo = moduleInfo;
        this.myUnsavedFilesContent = unsavedFilesContent;
        this.myChangedFilesToTimeStamp = changedFilesToTimeStamp;
        this.myIsAnnotate = isAnnotate;
        this.myShouldGetValueFromCache = shouldGetValueFromCache;
    }

    @Override
    public boolean shouldShowErrorsInToolWindow() {
        return true;
    }

    @Override
    public boolean shouldSaveValueToCache() {
        return this.myIsAnnotate;
    }

    protected boolean isReturnCompiledFiles() {
        return false;
    }

    @Override
    @Nullable
    public String getCacheKey() {
        if (this.myChangedFilesToTimeStamp.size() != 1) {
            return null;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(this.myChangedFilesToTimeStamp.entrySet());
        if (item == null) {
            return null;
        }
        return (String)item.getKey();
    }

    @Override
    public boolean shouldGetValueFromCache(Map<String, Long> filePathToLastCompileTimeStamp) {
        if (!this.myShouldGetValueFromCache) {
            return false;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(this.myChangedFilesToTimeStamp.entrySet());
        assert (item != null);
        Long oldTimestamp = filePathToLastCompileTimeStamp.get(item.getKey());
        return ((Long)item.getValue()).equals(oldTimestamp);
    }

    @Override
    @Nullable
    public JSLanguageCompilerCommand updateCompileTimeStampsAndReturnCommand(Map<String, Long> pathToChangeTimeStamp) {
        ArrayList newToCompileChangedFiles = ContainerUtil.newArrayList();
        for (Map.Entry<String, Long> entry : this.myChangedFilesToTimeStamp.entrySet()) {
            String path = entry.getKey();
            if (entry.getValue() < 0L) {
                newToCompileChangedFiles.add(path);
                pathToChangeTimeStamp.remove(path);
                continue;
            }
            long fixedModifiedStamp = entry.getValue();
            Long timeStamp = pathToChangeTimeStamp.get(path);
            if (timeStamp != null && !this.myIsAnnotate && fixedModifiedStamp == timeStamp) continue;
            newToCompileChangedFiles.add(path);
            pathToChangeTimeStamp.put(path, entry.getValue());
        }
        return newToCompileChangedFiles.isEmpty() ? null : new TypeScriptCompilerCommandToCompile(this.myCompilerId, newToCompileChangedFiles, this.myUnsavedFilesContent, this.myModuleInfo, this.isReturnCompiledFiles());
    }

    public String toString() {
        return this.myChangedFilesToTimeStamp.keySet().toString();
    }

    @NotNull
    public Set<String> getChangedFiles() {
        Set<String> set = this.myChangedFilesToTimeStamp.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfo", "getChangedFiles"));
        }
        return set;
    }
}

