/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.JsonElement;
import com.intellij.lang.javascript.compiler.JSCompilerCompileResultProcessor;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResult;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResultContainer;
import com.intellij.lang.javascript.compiler.JSLanguageExternalCompiler;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerAnswer;
import com.intellij.lang.typescript.compiler.TypeScriptCompiledFilePropertyPusher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompilerCompileResultProcessor
implements JSCompilerCompileResultProcessor {
    private final Project myProject;

    public TypeScriptCompilerCompileResultProcessor(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public JSLanguageCompilerResultContainer process(@NotNull JSLanguageCompilerAnswer answer) {
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/TypeScriptCompilerCompileResultProcessor", "process"));
        }
        this.processEmitFilesAfterCompiling(answer);
        JSLanguageCompilerResultContainer jSLanguageCompilerResultContainer = JSLanguageCompilerResult.build((JsonElement)answer.getElement());
        if (jSLanguageCompilerResultContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerCompileResultProcessor", "process"));
        }
        return jSLanguageCompilerResultContainer;
    }

    private void processEmitFilesAfterCompiling(JSLanguageCompilerAnswer answer) {
        JsonElement emitFiles = answer.getElement().get("emitFiles");
        if (emitFiles != null) {
            assert (emitFiles.isJsonArray());
            final List files = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Iterable)emitFiles.getAsJsonArray()), (Function)new Function<JsonElement, String>(){

                public String fun(JsonElement element) {
                    return element.getAsString();
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    if (TypeScriptCompilerCompileResultProcessor.this.myProject.isDisposed()) {
                        return;
                    }
                    HashSet dirtyFiles = ContainerUtil.newHashSet();
                    for (String file : files) {
                        String systemIndependentName = FileUtil.toSystemIndependentName((String)file);
                        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                        if (path != null) {
                            dirtyFiles.add(path);
                            continue;
                        }
                        String parentDir = VfsUtil.getParentDir((String)systemIndependentName);
                        if (StringUtil.isEmpty((String)parentDir) || (path = LocalFileSystem.getInstance().findFileByPath(parentDir)) == null) continue;
                        dirtyFiles.add(path);
                    }
                    for (String file : dirtyFiles) {
                        Boolean data;
                        if (file.isDirectory() || (data = (Boolean)file.getUserData(JSLanguageExternalCompiler.GENERATED_FILE_MARKER)) == Boolean.TRUE) continue;
                        PushedFilePropertiesUpdater.getInstance((Project)TypeScriptCompilerCompileResultProcessor.this.myProject).findAndUpdateValue((VirtualFile)file, (FilePropertyPusher)new TypeScriptCompiledFilePropertyPusher(), (Object)true);
                    }
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)dirtyFiles));
                }
            });
        }
    }
}

