/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.JsonObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.compiler.JSCompilerCommandResultProcessor;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResult;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResultContainer;
import com.intellij.lang.javascript.compiler.JSLanguageExternalCompiler;
import com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerAnswer;
import com.intellij.lang.javascript.compiler.ui.JSLanguageCompilerToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfo;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerCompileResultProcessor;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.lang.typescript.compiler.protocol.TypeScriptCompilerProtocol;
import com.intellij.lang.typescript.compiler.protocol.commands.TypeScriptCompilerAddConfigCommand;
import com.intellij.lang.typescript.compiler.protocol.commands.TypeScriptCompilerCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerService
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final String TYPE_SCRIPT_COMPILER_INFO = "TypeScript Compiler Info";
    public static final String GO_TO_CONFIG_ACTION = "PATH";
    public static final String DEFAULT_COMPILER_NAME = "default";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Alarm myCompilerQueueAlarm;
    @NotNull
    private Set<String> myConfigStartedCompilerId;
    private Set<String> myDiscoveredCompilerId;
    @Nullable
    private final JSLanguageCompilerToolWindowManager myToolWindowManager;
    private Set<VirtualFile> myQueueFiles;
    private final Object myLock;
    private final Alarm myCheckCompilerAliveAlarm;
    private volatile JSLanguageExternalCompiler myCompiler;

    @NotNull
    public static GlobalSearchScope getCompileScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompileScope"));
        }
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)project, (String)TypeScriptCompilerSettings.getSettings(project).getScopeName());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompileScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public JSLanguageCompilerToolWindowManager getToolWindowManager() {
        return this.myToolWindowManager;
    }

    public static TypeScriptCompilerService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getService"));
        }
        return (TypeScriptCompilerService)ServiceManager.getService((Project)project, TypeScriptCompilerService.class);
    }

    public TypeScriptCompilerService(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "<init>"));
        }
        this.myConfigStartedCompilerId = ContainerUtil.newConcurrentSet();
        this.myDiscoveredCompilerId = ContainerUtil.newConcurrentSet();
        this.myQueueFiles = ContainerUtil.newHashSet();
        this.myLock = new Object();
        this.myProject = project;
        NotificationsConfiguration.getNotificationsConfiguration().register(TYPE_SCRIPT_COMPILER_INFO, NotificationDisplayType.NONE, true);
        TypeScriptCompileCurrentAction typeScriptCompileCurrentAction = new TypeScriptCompileCurrentAction(){

            @Override
            protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
                return FileEditorManager.getInstance((Project)project).getSelectedFiles();
            }

            @Override
            protected void logErrors(JSLanguageCompilerToolWindowManager manager, Collection<JSLanguageCompilerResult> infos) {
                manager.logCurrentErrors((ImmutableList<JSLanguageCompilerResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
            }
        };
        AnAction restartCompilerAction = new AnAction(JSBundle.message((String)"typescript.compiler.action.restart", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.restart", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication){

            public void actionPerformed(AnActionEvent e) {
                TypeScriptCompilerService.this.restartCompilerProcessImpl(false);
            }
        };
        this.myToolWindowManager = new JSLanguageCompilerToolWindowManager(this.myProject, "TypeScript Compiler", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, typeScriptCompileCurrentAction, new TypeScriptCompileAllAction(), restartCompilerAction);
        Disposer.register((Disposable)this, (Disposable)this.myToolWindowManager);
        this.myCheckCompilerAliveAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this);
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TypeScriptCompilerService.this.myCheckCompilerAliveAlarm.isDisposed() || TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                JSLanguageExternalCompiler compiler = TypeScriptCompilerService.this.myCompiler;
                if (compiler != null) {
                    Object object = TypeScriptCompilerService.this.myLock;
                    synchronized (object) {
                        compiler = TypeScriptCompilerService.this.myCompiler;
                        if (compiler != null && compiler.getState() == JSLanguageExternalCompiler.State.ERROR_OR_TIMEOUT) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    TypeScriptCompilerService.this.restartCompilerProcessImpl(false);
                                }
                            });
                        }
                    }
                }
                if (TypeScriptCompilerService.this.myCheckCompilerAliveAlarm.isDisposed() || TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                TypeScriptCompilerService.this.myCheckCompilerAliveAlarm.addRequest((Runnable)this, 5000);
            }
        }.run();
        this.myCompilerQueueAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this);
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet toProcess;
                if (TypeScriptCompilerService.this.myCompilerQueueAlarm.isDisposed() || TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                Object object = TypeScriptCompilerService.this.myLock;
                synchronized (object) {
                    if (TypeScriptCompilerService.this.myQueueFiles == null) {
                        return;
                    }
                    toProcess = ContainerUtil.newHashSet((Iterable)TypeScriptCompilerService.this.myQueueFiles);
                    TypeScriptCompilerService.this.myQueueFiles.clear();
                }
                if (!toProcess.isEmpty()) {
                    final Ref compilerIdToFileRef = Ref.create();
                    DumbService.getInstance((Project)TypeScriptCompilerService.this.myProject).runReadActionInSmartMode(new Runnable(){

                        @Override
                        public void run() {
                            compilerIdToFileRef.set((Object)TypeScriptCompilerService.this.splitByCompilerId(toProcess));
                        }
                    });
                    MultiMap compilerIdToFile = (MultiMap)compilerIdToFileRef.get();
                    for (Map.Entry compilerIdToFiles : compilerIdToFile.entrySet()) {
                        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                        Collection files = (Collection)compilerIdToFiles.getValue();
                        String compilerId = (String)compilerIdToFiles.getKey();
                        LinkedHashMap fileToTimeStampWithModule = ContainerUtil.newLinkedHashMap();
                        LinkedHashMap FileToTimeStampWithoutModule = ContainerUtil.newLinkedHashMap();
                        try {
                            for (VirtualFile virtualFile : files) {
                                if (!virtualFile.isInLocalFileSystem() || !virtualFile.isValid() || !TypeScriptCompilerService.getCompileScope(TypeScriptCompilerService.this.myProject).accept(virtualFile) || null != virtualFile.getUserData(JSLanguageExternalCompiler.GENERATED_FILE_MARKER)) continue;
                                Pair<String, String> moduleInfo = TypeScriptCompileInfoBuilder.getModuleInfoIfNeed(virtualFile, project);
                                Map mapToProcess = moduleInfo != null ? (Map)ContainerUtil.getOrCreate((Map)fileToTimeStampWithModule, moduleInfo, (Factory)new Factory<Map<String, Long>>(){

                                    public Map<String, Long> create() {
                                        return ContainerUtil.newLinkedHashMap();
                                    }
                                }) : FileToTimeStampWithoutModule;
                                mapToProcess.put(TypeScriptCompilerService.normalizeNameAndPath(virtualFile), virtualFile.getModificationStamp());
                            }
                        }
                        finally {
                            token.finish();
                        }
                        for (Map.Entry entry : fileToTimeStampWithModule.entrySet()) {
                            Map value = (Map)entry.getValue();
                            if (value == null || value.size() <= 0) continue;
                            TypeScriptCompilerService.this.compile(new TypeScriptCompileInfo(value, null, false, true, (Pair<String, String>)((Pair)entry.getKey()), compilerId));
                        }
                        LOGGER.debug("Compile from queue");
                        if (FileToTimeStampWithoutModule.size() <= 0) continue;
                        TypeScriptCompilerService.this.compile(new TypeScriptCompileInfo(FileToTimeStampWithoutModule, null, false, true, null, compilerId));
                    }
                }
                if (TypeScriptCompilerService.this.myCompilerQueueAlarm.isDisposed() || TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                TypeScriptCompilerService.this.myCompilerQueueAlarm.addRequest((Runnable)this, 2000);
            }
        }.run();
        this.initToolWindow();
    }

    @NotNull
    private MultiMap<String, VirtualFile> splitByCompilerId(@NotNull Set<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "splitByCompilerId"));
        }
        MultiMap map = MultiMap.create();
        for (VirtualFile file : files) {
            map.putValue((Object)this.getCompilerId(file), (Object)file);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "splitByCompilerId"));
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCompilerForConfig(final @NotNull String compilerId, final @NotNull JSLanguageExternalCompiler compiler) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "startCompilerForConfig"));
        }
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "startCompilerForConfig"));
        }
        Object object = this.myLock;
        synchronized (object) {
            JSCompilerCommandResultProcessor processor = new JSCompilerCommandResultProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(@NotNull JSLanguageCompilerAnswer answer) {
                    String errorText;
                    if (answer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$5", "process"));
                    }
                    JsonObject object = answer.getElement();
                    String string = errorText = object.has("error") ? object.get("error").getAsString() : null;
                    if (errorText != null) {
                        Object object2 = TypeScriptCompilerService.this.myLock;
                        synchronized (object2) {
                            TypeScriptCompilerService.this.myConfigStartedCompilerId.remove(compilerId);
                        }
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (errorText != null) {
                                JSLanguageCompilerToolWindowManager manager = TypeScriptCompilerService.this.myToolWindowManager;
                                if (manager != null) {
                                    manager.logCurrentErrors(JSLanguageCompilerResult.buildError(errorText), false);
                                }
                            } else {
                                TypeScriptConfig config = TypeScriptCompilerConfigUtil.getConfigByCompilerId(TypeScriptCompilerService.this.myProject, compilerId);
                                if (config != null) {
                                    boolean shouldLogDiscovered;
                                    Object object = TypeScriptCompilerService.this.myLock;
                                    synchronized (object) {
                                        shouldLogDiscovered = TypeScriptCompilerService.this.myDiscoveredCompilerId.add(compilerId);
                                    }
                                    if (shouldLogDiscovered) {
                                        TypeScriptCompilerService.this.logConfigDiscovered(config.getConfigFile());
                                    }
                                }
                            }
                        }
                    }, (Condition)new Condition<JSLanguageCompilerAnswer>(){

                        public boolean value(JSLanguageCompilerAnswer o) {
                            return compiler.getState() == JSLanguageExternalCompiler.State.DISPOSED;
                        }
                    });
                }
            };
            this.myConfigStartedCompilerId.add(compilerId);
            compiler.sendCommandToCompiler(new TypeScriptCompilerAddConfigCommand(compilerId, TypeScriptCompilerConfigUtil.getConfigDirectoryByCompilerId(compilerId)), processor);
        }
    }

    private static JSCompilerCommandResultProcessor getResetCachesProcessor(final @NotNull JSLanguageExternalCompiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getResetCachesProcessor"));
        }
        return new JSCompilerCommandResultProcessor(){

            @Override
            public void process(@NotNull JSLanguageCompilerAnswer answer) {
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$6", "process"));
                }
                compiler.resetCaches();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCleanCommandToCompiler(@NotNull TypeScriptCompilerCommandClean command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "sendCleanCommandToCompiler"));
        }
        JSLanguageExternalCompiler compiler = this.getCompilerProcess();
        if (compiler == null) {
            return;
        }
        String id = command.getCompilerId();
        if (id == null && !command.isAll()) {
            compiler.sendCommandToCompiler(command, TypeScriptCompilerService.getResetCachesProcessor(compiler));
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (command.isAll()) {
                this.myConfigStartedCompilerId.clear();
            } else {
                if (!this.myConfigStartedCompilerId.contains(id)) {
                    return;
                }
                this.myConfigStartedCompilerId.remove(id);
            }
            compiler.sendCommandToCompiler(command, TypeScriptCompilerService.getResetCachesProcessor(compiler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Future<JSLanguageCompilerResultContainer> compile(@NotNull TypeScriptCompileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "compile"));
        }
        JSLanguageExternalCompiler compiler = this.getCompilerProcess();
        if (compiler == null) {
            return null;
        }
        String id = info.getCompilerId();
        if (!id.equals(DEFAULT_COMPILER_NAME)) {
            Object object = this.myLock;
            synchronized (object) {
                Set<String> ids = this.myConfigStartedCompilerId;
                if (!ids.contains(id)) {
                    this.startCompilerForConfig(id, compiler);
                }
            }
        }
        return compiler.compile(info, new TypeScriptCompilerCompileResultProcessor(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private JSLanguageExternalCompiler getCompilerProcess() {
        JSLanguageExternalCompiler compiler = this.myCompiler;
        if (compiler != null) {
            return compiler;
        }
        Object object = this.myLock;
        synchronized (object) {
            compiler = this.myCompiler;
            if (compiler == null) {
                Collection<TypeScriptConfig> files;
                TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
                boolean useConfig = settings.isUseConfigForCompiler();
                if (useConfig && (files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject)).isEmpty()) {
                    if (this.myToolWindowManager != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String message = "Cannot find tsconfig.json in the project";
                                TypeScriptCompilerService.this.myToolWindowManager.logCurrentErrors(JSLanguageCompilerResult.buildError(message), true);
                            }
                        });
                    }
                    return null;
                }
                this.myCompiler = compiler = new JSLanguageExternalCompilerImpl(this.myProject, new TypeScriptCompilerProtocol(this.myProject, useConfig), this.myToolWindowManager);
            }
        }
        return compiler;
    }

    private void logConfigDiscovered(final VirtualFile file) {
        String path = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.myProject.getBaseDir());
        Notifications.Bus.notify((Notification)new Notification(TYPE_SCRIPT_COMPILER_INFO, "TypeScript Compiler", "Discovered tsconfig.json: <a href='PATH'>" + path + "</a>", NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$8", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$8", "hyperlinkUpdate"));
                }
                if (TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                if (TypeScriptCompilerService.GO_TO_CONFIG_ACTION.equals(event.getDescription()) && file.isValid()) {
                    new OpenFileDescriptor(TypeScriptCompilerService.this.myProject, file, 0).navigate(true);
                }
            }
        }), (Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "addFileToCompileQueue"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myQueueFiles != null) {
                this.myQueueFiles.addAll(files);
            }
        }
    }

    public void resetCompilerCaches() {
        JSLanguageExternalCompiler process = this.getCompilerProcess();
        if (process != null) {
            process.resetCaches();
        }
    }

    @NotNull
    String getCompilerId(@NotNull VirtualFile fileToCompile) {
        if (fileToCompile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToCompile", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        if (!settings.isUseConfigForCompiler()) {
            if (DEFAULT_COMPILER_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
            }
            return DEFAULT_COMPILER_NAME;
        }
        Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
        if (files.isEmpty()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    JSLanguageCompilerToolWindowManager manager = TypeScriptCompilerService.this.myToolWindowManager;
                    if (manager != null) {
                        manager.printToConsole("IDE message: Project doesn't contain tsconfig.json\n");
                    }
                }
            });
            if (DEFAULT_COMPILER_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
            }
            return DEFAULT_COMPILER_NAME;
        }
        String file = TypeScriptCompilerConfigUtil.getCompilerIdForFile(this.myProject, fileToCompile);
        String string = file == null ? DEFAULT_COMPILER_NAME : file;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
        }
        return string;
    }

    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "normalizeNameAndPath"));
        }
        String path = name.getCanonicalPath();
        if (!name.isInLocalFileSystem() || null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    public static String normalizeNameAndPath(@Nullable String path) {
        if (null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompiler(@Nullable JSLanguageExternalCompiler compiler) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCompiler = compiler;
            this.myConfigStartedCompilerId.clear();
            this.myDiscoveredCompilerId.clear();
        }
    }

    public void restartCompiler() {
        this.restartCompilerProcessImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartCompilerProcessImpl(boolean recreateToolWindow) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myToolWindowManager != null && (recreateToolWindow || this.myToolWindowManager.isConnectedToProcessHandler())) {
                this.myToolWindowManager.cleanPanel();
            }
            final JSLanguageExternalCompiler compiler = this.myCompiler;
            this.initToolWindow();
            this.myConfigStartedCompilerId.clear();
            this.myDiscoveredCompilerId.clear();
            if (compiler != null) {
                this.myCompiler = null;
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (compiler.getState() != JSLanguageExternalCompiler.State.DISPOSED) {
                            Disposer.dispose((Disposable)compiler);
                        }
                    }
                });
            }
            this.initToolWindow();
        }
    }

    private boolean isCompilerEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && TypeScriptCompilerSettings.getSettings(this.myProject).isCompilerEnabled();
    }

    private void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TypeScriptCompilerService.this.isCompilerEnabled()) {
                            TypeScriptCompilerService.this.myToolWindowManager.init();
                        }
                    }
                }, TypeScriptCompilerService.this.myProject.getDisposed());
            }
        });
    }

    public Object getCompilerStartLock() {
        return this.myLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        JSLanguageExternalCompiler compiler = this.myCompiler;
        if (compiler != null) {
            Disposer.dispose((Disposable)compiler);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueueFiles = null;
        }
    }
}

