/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.protocol;

import com.google.common.base.Charsets;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerAnswer;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerAnswerConsumer;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerProtocol;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

public class TypeScriptCompilerProtocol
implements JSLanguageCompilerProtocol {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    private static final String ANSWER_READY = "ready";
    private static final String ANSWER_ERROR = "error";
    public static final String SOURCE_MAP = "--sourceMap";
    public static final int OBJECT_LENGTH = 0x3200000;
    private static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    private final Project myProject;
    private final boolean myWithConfig;
    private JSLanguageCompilerAnswerConsumer myDefaultConsumer = new JSLanguageCompilerAnswerConsumer(){

        @Override
        public void consume(JSLanguageCompilerAnswer message) {
            if (message != null) {
                LOGGER.debug(message.toString());
            }
        }
    };
    private Channel myChannel;
    private final ConcurrentMap<String, JSLanguageCompilerAnswerConsumer> myCallbacks = ContainerUtil.newConcurrentMap();
    private final long mySessionId = System.currentTimeMillis();
    @Nullable
    private String myInitializeError;

    public TypeScriptCompilerProtocol(Project project, boolean withConfig) {
        this.myProject = project;
        this.myWithConfig = withConfig;
    }

    @Override
    public ProcessHandler createCompilerProcessAndConnection() throws Exception {
        String localHostString;
        int socketPort = NetUtils.findAvailableSocketPort();
        GeneralCommandLine line = this.createCommandLine(socketPort, localHostString = NetUtils.getLocalHostString());
        if (line == null) {
            LOGGER.debug("Cannot create command line for typescript compiler");
            return null;
        }
        OSProcessHandler processHandler = new OSProcessHandler(line);
        if (!this.waitingReadyNotification(processHandler)) {
            processHandler.destroyProcess();
            return null;
        }
        Bootstrap bootstrap = NettyKt.oioClientBootstrap();
        LOGGER.debug("Initialize Channel connection");
        final CountDownLatch latch = new CountDownLatch(1);
        bootstrap.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                try {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new ChannelRegistrar(), new JsonObjectDecoder(0x3200000), new StringDecoder(CharsetUtil.UTF_8), new SimpleChannelInboundHandlerAdapter<String>(){

                        protected void messageReceived(ChannelHandlerContext context, String message) throws Exception {
                            String command;
                            long timeMillis = System.currentTimeMillis();
                            JSLanguageCompilerAnswer compilerMessage = new JSLanguageCompilerAnswer(message);
                            try {
                                command = compilerMessage.getCommand();
                            }
                            catch (RuntimeException e) {
                                JSLanguageExternalCompilerImpl.LOGGER.debug("Message: " + compilerMessage.toString(), (Throwable)e);
                                throw e;
                            }
                            JSLanguageCompilerAnswerConsumer consumer = (JSLanguageCompilerAnswerConsumer)TypeScriptCompilerProtocol.this.myCallbacks.remove(command);
                            if (consumer != null) {
                                consumer.consume(compilerMessage);
                                JSLanguageExternalCompilerImpl.LOGGER.debug("Consume end at " + (System.currentTimeMillis() - timeMillis));
                                return;
                            }
                            TypeScriptCompilerProtocol.this.myDefaultConsumer.consume(compilerMessage);
                        }
                    }, ChannelExceptionHandler.getInstance()});
                    pipeline.addLast(new ChannelHandler[]{new StringEncoder(Charsets.UTF_8)});
                    JSLanguageExternalCompilerImpl.LOGGER.debug("INIT HANDLER");
                }
                finally {
                    latch.countDown();
                }
            }
        });
        InetSocketAddress address = new InetSocketAddress(localHostString, socketPort);
        JSLanguageExternalCompilerImpl.LOGGER.debug(address.toString());
        this.myChannel = NettyKt.connect((Bootstrap)bootstrap, (InetSocketAddress)address);
        if (this.myChannel == null) {
            throw new RuntimeException("Cannot establish connection to compiler server");
        }
        LOGGER.debug("Start waiting channel connection");
        latch.await(30L, TimeUnit.SECONDS);
        LOGGER.debug("End waiting channel connection");
        return processHandler;
    }

    private boolean waitingReadyNotification(OSProcessHandler processHandler) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result = new Ref((Object)false);
        ProcessAdapter listener = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                    String prefix;
                    LOGGER.debug("TS COMPILER OUT(1): " + event.getText());
                    String text = event.getText().trim();
                    if (TypeScriptCompilerProtocol.this.toSystemCommand(TypeScriptCompilerProtocol.ANSWER_READY).equals(text)) {
                        result.set((Object)true);
                        countDownLatch.countDown();
                    }
                    if (text.startsWith(prefix = TypeScriptCompilerProtocol.this.toSystemCommand(TypeScriptCompilerProtocol.ANSWER_ERROR))) {
                        LOGGER.debug("Error parsing options " + text);
                        TypeScriptCompilerProtocol.this.myInitializeError = text.substring(prefix.length());
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                countDownLatch.countDown();
            }
        };
        processHandler.addProcessListener((ProcessListener)listener);
        processHandler.startNotify();
        try {
            LOGGER.debug("Start waiting for ready start");
            countDownLatch.await(30L, TimeUnit.SECONDS);
            LOGGER.debug("End waiting for process starting. Result " + result.get());
        }
        catch (InterruptedException e) {
            LOGGER.debug("Process interrupted while waiting ready state");
        }
        processHandler.removeProcessListener((ProcessListener)listener);
        return (Boolean)result.get();
    }

    @Nullable
    private GeneralCommandLine createCommandLine(int socketPort, String localHostString) throws Exception {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        String interpreter = settings.getNodeInterpreter();
        if (interpreter == null) {
            File file = NodeDetectionUtil.findInterpreterInPath();
            if (file == null) {
                return null;
            }
            interpreter = file.getAbsolutePath();
        }
        if (StringUtil.isEmpty((String)interpreter)) {
            throw new RuntimeException("Node interpreter path is empty. Please check the TypeScript Compiler settings");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreter});
        File file = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "bridge.js");
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource bridge.js: " + file.getAbsolutePath());
        }
        commandLine.withWorkDirectory(this.myProject.getBasePath());
        commandLine.addParameter(file.getAbsolutePath());
        commandLine.addParameters(new String[]{this.getSessionIdParam(), this.getServicePathParam(), TypeScriptCompilerProtocol.getPortParam(socketPort), TypeScriptCompilerProtocol.getHostParam(localHostString)});
        if (this.myWithConfig) {
            TypeScriptCompilerProtocol.setSkipForTSConfig(commandLine);
        } else {
            this.setManualOptions(settings, commandLine);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Commandline " + commandLine.toString());
        }
        return commandLine;
    }

    private VirtualFile getRootDir() {
        return this.myProject.getBaseDir();
    }

    private static void setSkipForTSConfig(GeneralCommandLine line) {
        line.addParameter("-skip=true");
    }

    private void setManualOptions(TypeScriptCompilerSettings settings, GeneralCommandLine commandLine) throws Macro.ExecutionCancelledException {
        boolean hasMainFile;
        boolean bl = hasMainFile = settings.isUseMainFile() && !StringUtil.isEmpty((String)settings.getMainFilePath());
        if (hasMainFile) {
            String mainFilePath = FileUtil.toSystemDependentName((String)settings.getMainFilePath());
            commandLine.addParameter("-mainFilePath=" + mainFilePath);
        }
        String outFile = null;
        if (settings.isHasOutDirectory() && !StringUtil.isEmpty((String)settings.getOutDirectory())) {
            int indexOfSeparator;
            int indexOfDot;
            String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)settings.getOutDirectory());
            DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
            for (Macro macro : PROJECT_LEVEL_MACRO) {
                String macroName = "$" + macro.getName() + "$";
                if (!outWithExpandedProjectMacro.contains(macroName)) continue;
                String expand = macro.expand(context);
                if (expand == null) {
                    expand = "";
                }
                outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
            }
            commandLine.addParameter(this.getProjectPath());
            if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
                if (indexOfSeparator >= 0) {
                    outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                    outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
                } else {
                    outFile = outWithExpandedProjectMacro;
                    outWithExpandedProjectMacro = null;
                }
            }
            if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
                commandLine.addParameter(TypeScriptCompilerProtocol.getOutPath(FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro)));
            }
        }
        if (settings.isGenerateSourceMap()) {
            commandLine.addParameter(SOURCE_MAP);
        }
        boolean existsCommandLineOutParam = false;
        if (null != settings.getTypeScriptCompilerParams()) {
            String[] parse;
            for (String s : parse = ParametersList.parse((String)settings.getTypeScriptCompilerParams())) {
                if (!"-out".equals(s)) continue;
                existsCommandLineOutParam = true;
                break;
            }
            commandLine.addParameters(parse);
        }
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            commandLine.addParameter("-out");
            commandLine.addParameter(FileUtilRt.toSystemDependentName(outFile));
        }
    }

    private String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    private String getProjectPath() {
        String path = this.getRootDir().getCanonicalPath();
        assert (path != null);
        return "-projectPath=" + FileUtil.toSystemDependentName((String)path);
    }

    private static String getOutPath(String path) {
        return "-outPathTemplate=" + path;
    }

    private String getServicePathParam() {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        return "-servicePath=" + TypeScriptCompilerSettings.getOSDependTypeScriptServicesFilePathByDirectory(settings.getTypeScriptServiceDirectoryOrDefault());
    }

    private String toSystemCommand(String command) {
        return this.mySessionId + " " + command;
    }

    private static String getPortParam(int socketPort) {
        return "-port=" + socketPort;
    }

    private static String getHostParam(String host) {
        return "-host=" + host;
    }

    private void write(String data) {
        if (this.myChannel != null) {
            this.myChannel.write((Object)data);
            this.myChannel.flush();
        }
    }

    @Override
    public void writeWithCallback(@NotNull String command, @NotNull String data, @NotNull JSLanguageCompilerAnswerConsumer callable) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/protocol/TypeScriptCompilerProtocol", "writeWithCallback"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/typescript/compiler/protocol/TypeScriptCompilerProtocol", "writeWithCallback"));
        }
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/lang/typescript/compiler/protocol/TypeScriptCompilerProtocol", "writeWithCallback"));
        }
        this.myCallbacks.put(command, callable);
        this.write(data + '\n' + this.toSystemCommand("end " + command) + '\n');
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    public void dispose() {
        try {
            if (this.myChannel != null) {
                NettyKt.closeAndShutdownEventLoop((Channel)this.myChannel);
                this.myChannel = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

