/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.protocol.commands;

import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerCommand;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerCommandToCompile
implements JSLanguageCompilerCommand {
    public static final String COMPILE = "compile";
    private final String command;
    @NotNull
    private final String compilerId;
    private final List<String> filesToCompile;
    private final Map<String, String> unsavedFilesContent;
    private final String contentRoot;
    private final String sourceRoot;
    private boolean sendCompileFiles;

    public List<String> getFilesToCompile() {
        return this.filesToCompile;
    }

    public TypeScriptCompilerCommandToCompile(@NotNull String compilerId, @NotNull List<String> filesToCompile, @Nullable Map<String, String> fileContent, Pair<String, String> moduleInfo, boolean doReturnCompileFiles) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/protocol/commands/TypeScriptCompilerCommandToCompile", "<init>"));
        }
        if (filesToCompile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToCompile", "com/intellij/lang/typescript/compiler/protocol/commands/TypeScriptCompilerCommandToCompile", "<init>"));
        }
        this.compilerId = compilerId;
        this.filesToCompile = filesToCompile;
        this.unsavedFilesContent = fileContent == null ? ContainerUtil.newHashMap() : fileContent;
        this.command = COMPILE;
        if (moduleInfo != null) {
            this.contentRoot = (String)moduleInfo.first;
            this.sourceRoot = (String)moduleInfo.second;
        } else {
            this.contentRoot = null;
            this.sourceRoot = null;
        }
        this.sendCompileFiles = doReturnCompileFiles;
    }

    @Override
    public String getCommand() {
        return this.command;
    }
}

