/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptCompilerVersionPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerVersionDialog
extends DialogWrapper {
    private JBRadioButton myEmbeddedRadio;
    private JBRadioButton myServiceDirectoryRadio;
    private final JPanel myPanel;
    private final TextFieldWithBrowseButton myTypeScriptServiceDirectoryField;

    protected TypeScriptCompilerVersionDialog(@NotNull Project project, TypeScriptCompilerVersionPanel versionPanel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerVersionDialog", "<init>"));
        }
        super(project);
        this.setTitle(JSBundle.message((String)"typescript.compiler.configurable.options.service.directory.configure", (Object[])new Object[0]));
        this.createButtonGroup();
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myTypeScriptServiceDirectoryField = new TextFieldWithBrowseButton();
        this.myTypeScriptServiceDirectoryField.addBrowseFolderListener("Choose service directory", null, project, new FileChooserDescriptor(false, true, false, false, false, false));
        builder.addComponent((JComponent)this.myEmbeddedRadio);
        builder.addLabeledComponent((JComponent)this.myServiceDirectoryRadio, (JComponent)this.myTypeScriptServiceDirectoryField);
        JBLabel noteLabel = new JBLabel(JSBundle.message((String)"typescript.compiler.configurable.options.service.directory.info", (Object[])new Object[0]));
        builder.addComponent((JComponent)noteLabel);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)noteLabel);
        noteLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)7));
        this.myTypeScriptServiceDirectoryField.setMinimumSize(new Dimension(300, this.myTypeScriptServiceDirectoryField.getMinimumSize().height));
        this.setDefaults(versionPanel);
        this.myPanel = builder.getPanel();
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"typescript.compiler.name", (Object[])new Object[0])));
        this.init();
    }

    private void setDefaults(TypeScriptCompilerVersionPanel panel) {
        switch (panel.getMyVersionType()) {
            case EMBEDDED: {
                this.myEmbeddedRadio.setSelected(true);
                break;
            }
            case SERVICE_DIRECTORY: {
                this.myServiceDirectoryRadio.setSelected(true);
                this.myTypeScriptServiceDirectoryField.setText(panel.getServiceDirectory());
                break;
            }
        }
    }

    private void createButtonGroup() {
        this.myEmbeddedRadio = new JBRadioButton(String.format("Bundled (%s)", JSBundle.message((String)"typescript.compiler.embedded.version", (Object[])new Object[0])));
        this.myServiceDirectoryRadio = new JBRadioButton(JSBundle.message((String)"typescript.compiler.configurable.options.service.directory", (Object[])new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myEmbeddedRadio);
        group.add((AbstractButton)this.myServiceDirectoryRadio);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myServiceDirectoryRadio.isSelected()) {
            String value = this.myTypeScriptServiceDirectoryField.getText();
            if (StringUtil.isEmpty((String)value)) {
                return new ValidationInfo(JSBundle.message((String)"typescript.compiler.configurable.options.service.directory.error.empty", (Object[])new Object[0]));
            }
            if (!new File(TypeScriptCompilerSettings.getOSDependTypeScriptServicesFilePathByDirectory(value)).exists()) {
                return new ValidationInfo(JSBundle.message((String)"typescript.compiler.configurable.options.service.directory.error.cannot.find.file", (Object[])new Object[]{"typescriptServices.js", value}));
            }
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public String getServiceDirectory() {
        if (this.myEmbeddedRadio.isSelected()) {
            return null;
        }
        return this.myTypeScriptServiceDirectoryField.getText();
    }

    public TypeScriptCompilerSettings.TypeScriptCompilerVersionType getVersionType() {
        if (this.myServiceDirectoryRadio.isSelected()) {
            return TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY;
        }
        return TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED;
    }
}

