/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui.projectView;

import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.typescript.compiler.ui.projectView.TypeScriptNestingTreeStructureProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptNestingTreeNode
extends PsiFileNode {
    private final String myName;

    public TypeScriptNestingTreeNode(PsiFileNode node) {
        super(node.getProject(), (PsiFile)node.getValue(), node.getSettings());
        VirtualFile file = node.getVirtualFile();
        assert (file != null);
        this.myName = file.getNameWithoutExtension();
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        Collection superResult = super.getChildrenImpl();
        PsiFile value = (PsiFile)this.getValue();
        if (value == null) {
            return superResult;
        }
        ArrayList result = superResult == null ? ContainerUtil.newArrayList() : ContainerUtil.newArrayList((Iterable)superResult);
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return superResult;
        }
        for (Object child : parent.getChildren()) {
            PsiFileNode psiFileNode;
            VirtualFile file;
            String name;
            if (!(child instanceof PsiFileNode) || StringUtil.isEmpty((String)(name = TypeScriptNestingTreeStructureProvider.getName(file = (psiFileNode = (PsiFileNode)child).getVirtualFile()))) || !StringUtil.equals((CharSequence)name, (CharSequence)this.myName) || !TypeScriptNestingTreeStructureProvider.isAcceptableExtension(file)) continue;
            result.add(psiFileNode);
        }
        return result;
    }

    public boolean contains(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeNode", "contains"));
        }
        boolean contains = super.contains(file);
        if (contains) {
            return true;
        }
        Collection<AbstractTreeNode> impl = this.getChildrenImpl();
        if (impl == null) {
            return false;
        }
        return ContainerUtil.find(impl, (Condition)new Condition<AbstractTreeNode>(){

            public boolean value(AbstractTreeNode node) {
                Object nodeValue = node.getValue();
                return nodeValue instanceof PsiFile && file.equals(((PsiFile)nodeValue).getVirtualFile());
            }
        }) != null;
    }
}

