/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.projectView.TypeScriptNestingTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    public static final String MAP_EXTENSION = "map";
    public static final Collection<String> JS_EXTENSIONS = ContainerUtil.newHashSet((Object[])new String[]{"js", "jsx"});

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
        }
        if (!TypeScriptCompilerSettings.getSettings(parent.getProject()).isCompilerEnabled() || !(parent instanceof PsiDirectoryNode)) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        final MultiMap equalFileNamesFiles = MultiMap.createSet();
        final HashMap nameToTypeScriptFiles = ContainerUtil.newHashMap();
        final HashSet typeScriptFiles = ContainerUtil.newHashSet();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof PsiFileNode)) continue;
            PsiFileNode psiFileNode = (PsiFileNode)child;
            PsiFile value = (PsiFile)psiFileNode.getValue();
            VirtualFile virtualFile = psiFileNode.getVirtualFile();
            String name = TypeScriptNestingTreeStructureProvider.getName(virtualFile);
            if (value == null || StringUtil.isEmpty((String)name)) continue;
            if (TypeScriptNestingTreeStructureProvider.isAcceptableExtension(virtualFile) && !StringUtil.isEmpty((String)name)) {
                equalFileNamesFiles.putValue((Object)name, (Object)value);
            }
            if (!TypeScriptCompilerSettings.acceptFileType(value.getFileType())) continue;
            nameToTypeScriptFiles.put(name, psiFileNode);
            typeScriptFiles.add(psiFileNode);
        }
        if (typeScriptFiles.isEmpty()) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        List list = ContainerUtil.mapNotNull(children, (Function)new Function<AbstractTreeNode, AbstractTreeNode>(){

            public AbstractTreeNode fun(AbstractTreeNode node) {
                if (!(node instanceof PsiFileNode)) {
                    return node;
                }
                PsiFileNode psiFileNode = (PsiFileNode)node;
                String name = TypeScriptNestingTreeStructureProvider.getName(psiFileNode.getVirtualFile());
                if (StringUtil.isEmpty((String)name)) {
                    return node;
                }
                if (typeScriptFiles.contains(node)) {
                    if (!StringUtil.isEmpty((String)name) && equalFileNamesFiles.get((Object)name).size() > 0) {
                        return new TypeScriptNestingTreeNode(psiFileNode);
                    }
                    return node;
                }
                if (nameToTypeScriptFiles.containsKey(name) && equalFileNamesFiles.get((Object)name).contains(psiFileNode.getValue())) {
                    return null;
                }
                return node;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
        }
        return list;
    }

    @Nullable
    public static String getName(VirtualFile file) {
        return TypeScriptNestingTreeStructureProvider.getName(file.getName());
    }

    public static String getName(String fullName) {
        String extension = FileUtilRt.getExtension((String)fullName);
        if (MAP_EXTENSION.equals(extension)) {
            String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)fullName);
            return FileUtil.getNameWithoutExtension((String)nameWithoutExtension);
        }
        return FileUtil.getNameWithoutExtension((String)fullName);
    }

    public static boolean isAcceptableExtension(VirtualFile file) {
        return file != null && (JS_EXTENSIONS.contains(file.getExtension()) || MAP_EXTENSION.equals(file.getExtension()));
    }

    @Nullable
    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }
}

