/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion.config;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptConfigCompletionContributor
extends CompletionContributor {
    private static final String[] COMPILER_OPTIONS = new String[]{"charset", "declaration", "diagnostics", "emitBOM", "listFiles", "locale", "mapRoot", "module", "noEmit", "noEmitOnError", "noImplicitAny", "noLib", "noLibCheck", "noResolve", "out", "outDir", "preserveConstEnums", "removeComments", "sourceMap", "sourceRoot", "suppressImplicitAnyIndexErrors", "target", "watch", "newLine", "noEmitHelpers", "inlineSourceMap", "inlineSources", "emitDecoratorMetadata", "isolatedModules", "experimentalDecorators", "jsx", "moduleResolution", "rootDir", "experimentalAsyncFunctions", "codepage"};
    public static final Set<String> FILES = ContainerUtil.newHashSet((Object[])new String[]{"files", "exclude"});

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/config/TypeScriptConfigCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/config/TypeScriptConfigCompletionContributor", "fillCompletionVariants"));
        }
        if (!TypeScriptConfigCompletionContributor.isConfigFile(parameters.getOriginalFile())) {
            return;
        }
        PsiElement originalPosition = parameters.getOriginalPosition();
        PsiElement position = parameters.getPosition();
        if (originalPosition == null) {
            return;
        }
        JsonProperty type = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)position, JsonProperty.class);
        if (type == null) {
            return;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)type.getValue(), (PsiElement)position, (boolean)true)) {
            if (FILES.contains(type.getName())) {
                result.consume((LookupElement)LookupElementBuilder.create((String)"[]").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        context.getEditor().getCaretModel().moveToOffset(context.getStartOffset() + 1);
                    }
                }));
            }
        } else {
            PsiElement parent = originalPosition.getParent();
            if (!(parent instanceof JsonObject)) {
                return;
            }
            PsiElement parentOfParent = parent.getParent();
            if (parentOfParent instanceof PsiFile) {
                result.consume((LookupElement)LookupElementBuilder.create((String)StringUtil.wrapWithDoubleQuote((String)"compilerOptions")));
                result.consume((LookupElement)LookupElementBuilder.create((String)StringUtil.wrapWithDoubleQuote((String)"files")));
                result.consume((LookupElement)LookupElementBuilder.create((String)StringUtil.wrapWithDoubleQuote((String)"exclude")));
            } else if (parentOfParent instanceof JsonProperty && StringUtil.equals((CharSequence)"compilerOptions", (CharSequence)((JsonProperty)parentOfParent).getName())) {
                for (String option : COMPILER_OPTIONS) {
                    result.consume((LookupElement)LookupElementBuilder.create((String)StringUtil.wrapWithDoubleQuote((String)option)));
                }
            }
        }
    }

    public static boolean isConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/completion/config/TypeScriptConfigCompletionContributor", "isConfigFile"));
        }
        return file.getLanguage().is((Language)JsonLanguage.INSTANCE) && "tsconfig.json".equals(file.getName());
    }
}

