/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferencesLibraryFix
extends FixAndIntentionAction
implements HighPriorityAction {
    public static final String LIBRARY_NAME = "ts-external-references";

    public TypeScriptReferencesLibraryFix(PsiElement comment) {
        this.registerElementRefForFix(comment, null);
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile psiFile, Editor editor) {
        if (!(psiFile instanceof JSFile)) {
            return;
        }
        JSFile file = (JSFile)psiFile;
        Collection<VirtualFile> files = TypeScriptReferencesLibraryFix.getFilesForLibrary(file);
        if (files.isEmpty()) {
            return;
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        Library library = libTable.getLibraryByName(LIBRARY_NAME);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        ScriptingLibraryModel libraryModel = null;
        if (library != null) {
            ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
            libraryModel = libraryTable.getModel(library);
            if (libraryModel != null) {
                Set oldFiles = libraryModel.getSourceFiles();
                HashSet resultSet = ContainerUtil.newHashSet();
                for (VirtualFile source : oldFiles) {
                    if (!source.isValid() || scope.accept(source)) continue;
                    resultSet.add(source);
                }
                resultSet.addAll(files);
                libraryModel.setSourceFiles(VfsUtilCore.toVirtualFileArray((Collection)resultSet));
            }
        } else {
            libraryModel = libraryManager.createLibrary(LIBRARY_NAME, VfsUtilCore.toVirtualFileArray(files), VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PROJECT, false);
            ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
            mappings.associate(null, LIBRARY_NAME);
        }
        if (libraryModel != null) {
            TypeScriptReferencesLibraryFix.configureModules(project, libraryModel, file.getVirtualFile());
            libraryManager.commitChanges();
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static void configureModules(@NotNull Project project, @NotNull ScriptingLibraryModel libraryModel, @Nullable VirtualFile owner) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix", "configureModules"));
        }
        if (libraryModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryModel", "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix", "configureModules"));
        }
        Object[] allModules = ModuleHelper.getModules((Project)project);
        if (allModules.length == 1) {
            return;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = null;
        if (owner != null) {
            module = index.getModuleForFile(owner);
        }
        if (libraryModel.isPredefined()) {
            return;
        }
        Set modules = libraryModel.getAssociatedModules();
        if (modules != null && module != null) {
            for (Module associatedModule : modules) {
                if (!module.equals(associatedModule)) continue;
                return;
            }
        }
        HashSet newModules = ContainerUtil.newHashSet();
        if (modules != null) {
            newModules.addAll(modules);
        }
        if (module != null) {
            newModules.add(module);
        } else {
            ContainerUtil.addAll((Collection)newModules, (Object[])allModules);
        }
        libraryModel.setAssociatedModules((Set)newModules);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesForLibrary(JSFile file) {
        Collection<VirtualFile> collection = JSFixFactory.getInstance().typeScriptReferencePathValidator().getOutOfProjectReferences(file);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix", "getFilesForLibrary"));
        }
        return collection;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile psiFile) {
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)psiFile;
        return JSFixFactory.getInstance().typeScriptReferencePathValidator().hasOutOfProjectReferences(file);
    }

    @Nls
    @NotNull
    public String getName() {
        if ("Create library with files outside the project" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix", "getName"));
        }
        return "Create library with files outside the project";
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

