/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.types.ES6ImportDeclarationElementType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptNodeReference;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT});

    public static boolean isAvailableForImport(@NotNull JSElement elementToImport, JSReferencePlaceInfo placeInfo, @NotNull Project project) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        assert (DialectDetector.isTypeScript((PsiElement)elementToImport));
        JSReferenceExpression place = placeInfo.place;
        if (place.getQualifier() == null && TypeScriptModuleAccessibilityChecker.checkElementCanBeExported((PsiElement)elementToImport)) {
            String refName;
            JSExportAssignment assignment;
            if (elementToImport instanceof TypeScriptModule) {
                return false;
            }
            boolean isClassType = elementToImport instanceof JSClass;
            if (placeInfo.isStrictTypeContext && !isClassType) {
                return false;
            }
            if (!TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType)) {
                return false;
            }
            PsiElement parent = elementToImport.getParent();
            if (parent instanceof JSVarStatement) {
                parent = parent.getParent();
            }
            if (parent instanceof ES6ExportDefaultAssignment) {
                return true;
            }
            if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.container)) {
                return false;
            }
            TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
            if (checker.check((PsiElement)place, (PsiElement)elementToImport) != null) {
                return false;
            }
            PsiFile file = elementToImport.getContainingFile();
            VirtualFile elementVirtualFile = file.getVirtualFile();
            if (!(file instanceof JSFile) || !TypeScriptConfigService.Provider.isAccessible(project, placeInfo.file, elementVirtualFile)) {
                return false;
            }
            if (ES6ImportHandler.isExported(elementToImport)) {
                return true;
            }
            if (isClassType && (assignment = TypeScriptAutoImportUtil.getExportAssignment(elementToImport)) != null && (refName = assignment.getInitializerReference()) != null) {
                return refName.equals(elementToImport.getName());
            }
        }
        return false;
    }

    private static boolean isElementCanBeUsedInContext(@NotNull JSElement elementToImport, @NotNull JSReferencePlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        PsiElement parentContext = placeInfo.parent;
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptInterface) || !isCallContext;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(element)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$1", "contains"));
                }
                return super.contains(file) && TypeScriptAutoImportUtil.checkDefinitionForNodeModules(file, project);
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        return delegatingGlobalSearchScope;
    }

    public static boolean checkDefinitionForNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (TypeScriptUtil.isUnderNodeModules(file, project)) {
            return TypeScriptUtil.isDefinitionFile(file);
        }
        return true;
    }

    public static void addImportStatement(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        ES6ImportDeclarationElementType expectedType;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        Project project = place.getProject();
        String name = elementToImport.getName();
        String externalModuleName = null;
        boolean addName = false;
        boolean isExportDefault = false;
        if (elementToImport instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)elementToImport).getAttributeList();
            if (elementToImport.getParent() instanceof ES6ExportDefaultAssignment) {
                isExportDefault = true;
            } else if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || ES6ImportHandler.isExported((JSElement)elementToImport)) {
                addName = true;
            }
        }
        JSQualifiedName qualifier = null;
        JSQualifiedName namespace = elementToImport.getNamespace();
        if (namespace == null) {
            externalModuleName = TypeScriptAutoImportUtil.getExternalModuleName(project, elementToImport, place);
        } else {
            String topmostParent = JSQualifiedNameImpl.getTopmostParent(namespace);
            if (StringUtil.isQuotedString((String)topmostParent)) {
                externalModuleName = topmostParent;
                qualifier = ((JSQualifiedNameImpl)namespace).withoutInnermostComponent(null);
            } else {
                qualifier = namespace;
            }
        }
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment((JSElement)elementToImport);
        boolean hasTypeScriptExportAssignment = exportAssignment instanceof TypeScriptExportAssignment;
        isExportDefault |= exportAssignment instanceof ES6ExportDefaultAssignment;
        StringBuilder builder = new StringBuilder("import ");
        if (externalModuleName != null) {
            if (hasTypeScriptExportAssignment) {
                builder.append(name).append(" = require(").append(externalModuleName).append(')');
                expectedType = TypeScriptElementTypes.IMPORT_STATEMENT;
            } else {
                if (addName) {
                    TypeScriptAutoImportUtil.wrapAndAppendName(name, isExportDefault, builder);
                } else {
                    builder.append(name);
                }
                builder.append(" from ").append(externalModuleName);
                expectedType = ES6ElementTypes.IMPORT_DECLARATION;
            }
        } else {
            builder.append(name).append(" = ");
            if (qualifier != null) {
                builder.append(qualifier);
            }
            if (addName) {
                if (qualifier != null) {
                    builder.append('.');
                }
                builder.append(name);
            }
            expectedType = TypeScriptElementTypes.IMPORT_STATEMENT;
        }
        builder.append(';');
        ASTNode importNode = JSChangeUtil.createStatementFromText(project, builder.toString(), JavaScriptSupportLoader.TYPESCRIPT);
        if (importNode == null || importNode.getElementType() != expectedType) {
            return;
        }
        final JSSourceElement importPsi = (JSSourceElement)importNode.getPsi();
        final PsiNamedElement scope = (PsiNamedElement)(externalModuleName == null ? (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{JSFile.class, TypeScriptModule.class}) : (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)place, JSFile.class));
        if (scope == null) {
            return;
        }
        final Pair<Boolean, PsiElement> placeForImport = TypeScriptAutoImportUtil.findPlaceForImport((PsiElement)scope);
        new WriteCommandAction.Simple<Void>(project, TypeScriptAutoImportUtil.getActionName(), new PsiFile[]{place.getContainingFile()}){

            protected void run() throws Throwable {
                if (((Boolean)placeForImport.first).booleanValue()) {
                    scope.addAfter((PsiElement)importPsi, (PsiElement)placeForImport.second);
                } else {
                    scope.addBefore((PsiElement)importPsi, (PsiElement)placeForImport.second);
                }
            }
        }.execute();
    }

    @Nullable
    private static String getExternalModuleName(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleName"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleName"));
        }
        String externalModuleName = null;
        PsiFile placePsiFile = place.getContainingFile();
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        PsiFile dstPsiFile = elementToImport.getContainingFile();
        VirtualFile dstFile = dstPsiFile.getVirtualFile();
        VirtualFile moduleDirectory = TypeScriptAutoImportUtil.findParentNodeModule(project, dstFile);
        if (moduleDirectory != null) {
            externalModuleName = TypeScriptAutoImportUtil.getModuleNameUsingNodeModules(project, elementToImport, moduleDirectory, dstFile, placePsiFile);
        }
        if (externalModuleName == null) {
            externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)dstFile, (char)'/');
            if (externalModuleName == null) {
                return null;
            }
            if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(String.valueOf(File.separatorChar))) {
                externalModuleName = "./" + externalModuleName;
            }
        }
        externalModuleName = StringUtil.trimEnd(externalModuleName, (String)".d.ts");
        externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".ts");
        externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".tsx");
        String quote = JSCodeStyleSettings.getQuote((PsiElement)elementToImport);
        externalModuleName = quote + externalModuleName + quote;
        return externalModuleName;
    }

    @Nullable
    public static String getModuleNameUsingNodeModules(Project project, @NotNull JSQualifiedNamedElement elementToImport, VirtualFile moduleDirectory, VirtualFile dstFile, PsiFile placePsiFile) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile nodeModulesDirectory = moduleDirectory.getParent();
        assert (nodeModulesDirectory != null);
        VirtualFile parentOfNodeModules = nodeModulesDirectory.getParent();
        if (!VfsUtilCore.isAncestor((VirtualFile)parentOfNodeModules, (VirtualFile)placeFile, (boolean)true)) {
            return null;
        }
        if (!dstFile.getParent().equals(moduleDirectory)) {
            VirtualFile moduleMainFile;
            ResolvedModuleInfo info = TypeScriptNodeReference.resolveModuleInfoFromNodeModulesDir(project, parentOfNodeModules, moduleDirectory.getName());
            if (info != null && TypeScriptAutoImportUtil.checkSymbolInFile(project, moduleMainFile = info.getModuleMainFile(), elementToImport, placePsiFile)) {
                return VfsUtil.getPath((VirtualFile)nodeModulesDirectory, (VirtualFile)moduleMainFile, (char)'/');
            }
            for (VirtualFile file : moduleDirectory.getChildren()) {
                if (!TypeScriptUtil.isDefinitionFile(file) || !TypeScriptAutoImportUtil.checkSymbolInFile(project, file, elementToImport, placePsiFile)) continue;
                dstFile = file;
                break;
            }
        }
        return VfsUtil.getPath((VirtualFile)nodeModulesDirectory, (VirtualFile)dstFile, (char)'/');
    }

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile) {
        ResolveResult[] results;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        PsiFile possiblePsiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(possiblePsiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)possiblePsiFile;
        String name = elementToImport.getQualifiedName();
        if (name == null) {
            return false;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)placePsiFile, name);
        TypeScriptQualifiedItemProcessor<ResolveResultSink> processor = new TypeScriptQualifiedItemProcessor<ResolveResultSink>(sink, placePsiFile);
        ES6PsiUtil.processExportDeclarationInScope((JSElement)file, processor, ResolveState.initial(), null, (PsiElement)placePsiFile);
        for (ResolveResult result : results = sink.getResultsAsResolveResults()) {
            PsiElement element = result.getElement();
            if (element == null || !element.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile findParentNodeModule(Project project, VirtualFile dstFile) {
        VirtualFile prevDirectory = null;
        VirtualFile stopDir = project.getBaseDir();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null && !stopDir.equals(currentDirectory); currentDirectory = currentDirectory.getParent()) {
            if ("node_modules".equals(currentDirectory.getName())) {
                return prevDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    @Nullable
    private static JSExportAssignment getExportAssignment(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExportAssignment"));
        }
        JSElement module = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)elementToImport, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren((PsiElement)module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NotNull
    private static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        ASTNode lBrace;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        PsiElement currentChild = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            currentChild = lBrace.getPsi().getNextSibling();
        }
        PsiElement lastImport = null;
        while (currentChild != null) {
            if (currentChild instanceof TypeScriptImportStatement || currentChild instanceof ES6ImportDeclaration) {
                lastImport = currentChild;
            } else if (lastImport == null && !(currentChild instanceof PsiWhiteSpace) && !(currentChild instanceof PsiComment)) break;
            currentChild = currentChild.getNextSibling();
        }
        Pair pair = Pair.create((Object)(lastImport != null ? 1 : 0), (Object)(lastImport != null ? lastImport : currentChild));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        return pair;
    }

    private static void wrapAndAppendName(String name, boolean isExportDefault, StringBuilder builder) {
        if (!isExportDefault) {
            builder.append('{');
        }
        builder.append(name);
        if (!isExportDefault) {
            builder.append('}');
        }
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }

    public static class JSReferencePlaceInfo {
        @NotNull
        private final JSReferenceExpression place;
        @NotNull
        private final PsiElement parent;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final PsiElement container;
        private final boolean isStrictTypeContext;

        public JSReferencePlaceInfo(@NotNull JSReferenceExpression place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$JSReferencePlaceInfo", "<init>"));
            }
            this.place = place;
            this.parent = place.getParent();
            this.file = place.getContainingFile().getOriginalFile().getVirtualFile();
            this.container = TypeScriptPsiUtil.getTopLevelContainer((PsiElement)place);
            this.isStrictTypeContext = JSResolveUtil.isExprInStrictTypeContext(place);
        }
    }
}

