/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptChangeUtil {
    private static final Logger LOG = Logger.getInstance((String)TypeScriptChangeUtil.class.getName());

    private TypeScriptChangeUtil() {
    }

    @NotNull
    public static TypeScriptType createTypeFromText(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/typescript/psi/TypeScriptChangeUtil", "createTypeFromText"));
        }
        TypeScriptType type = TypeScriptChangeUtil.tryCreateTypeFromText(project, text);
        if (type == null) {
            LOG.error(text + " wasn't parsed as TypeScript type", new Attachment[]{new Attachment("text.txt", text)});
        }
        TypeScriptType typeScriptType = type;
        if (typeScriptType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptChangeUtil", "createTypeFromText"));
        }
        return typeScriptType;
    }

    public static PsiElement createClassMemberFromText(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/typescript/psi/TypeScriptChangeUtil", "createClassMemberFromText"));
        }
        return JSChangeUtil.createClassMemberFromText(project, text, JavaScriptSupportLoader.TYPESCRIPT).getPsi();
    }

    @Nullable
    private static TypeScriptType tryCreateTypeFromText(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/typescript/psi/TypeScriptChangeUtil", "tryCreateTypeFromText"));
        }
        text = "var a:" + text;
        ASTNode node = JSChangeUtil.createStatementFromText(project, text, JavaScriptSupportLoader.TYPESCRIPT);
        if (node == null) {
            return null;
        }
        JSVarStatement varStatement = (JSVarStatement)node.getPsi();
        JSVariable variable = varStatement.getVariables()[0];
        return (TypeScriptType)variable.getTypeElement();
    }

    @Nullable
    public static JSClass createClassDefinitionFromText(Project project, boolean isExtends, String list) {
        ASTNode node = JSChangeUtil.createStatementFromText(project, "class A" + (isExtends ? " extends" : " implements") + list + " {}", JavaScriptSupportLoader.TYPESCRIPT);
        if (node == null) {
            return null;
        }
        return (JSClass)node.getPsi();
    }
}

